/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.constraint;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;
import org.sonatype.nexus.validation.constraint.Hostname;

public class HostnameValidator
extends ConstraintValidatorSupport<Hostname, String> {
    private static final Pattern RFC_1123_HOST = Pattern.compile("^(((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))|(\\[(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}\\])|(\\[((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)\\])|(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))(:([0-9]+))?$");

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Strings2.isBlank((String)value)) {
            return true;
        }
        return RFC_1123_HOST.matcher(value).matches();
    }
}

