/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.constraint;

import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;
import org.sonatype.nexus.validation.constraint.Url;
import org.sonatype.nexus.validation.constraint.UrlValidator;

public class UrlStringValidator
extends ConstraintValidatorSupport<Url, String> {
    private static final UrlValidator urlValidator = new UrlValidator();

    public boolean isValid(String url, ConstraintValidatorContext constraintValidatorContext) {
        if (Strings2.isBlank((String)url)) {
            return true;
        }
        try {
            URI uri = new URI(url);
            return urlValidator.isValid(uri, constraintValidatorContext);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

