/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.validator.HibernateValidator;
import org.sonatype.nexus.validation.Validate;

public class ValidationInterceptor
implements MethodInterceptor {
    @Inject
    private ExecutableValidator methodValidator;

    public Object invoke(MethodInvocation mi) throws Throwable {
        Preconditions.checkNotNull((Object)this.methodValidator);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            Validate validate = mi.getMethod().getAnnotation(Validate.class);
            this.validateParameters(mi.getThis(), mi.getMethod(), mi.getArguments(), validate.groups());
            Object result = mi.proceed();
            this.validateReturnValue(mi.getThis(), mi.getMethod(), result, validate.groups());
            Object object = result;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void validateParameters(Object obj, Method method, Object[] args, Class<?>[] groups) {
        Set violations = this.methodValidator.validateParameters(obj, method, args, (Class[])groups);
        if (!violations.isEmpty()) {
            String message = "Invalid arguments calling '" + method + "' with " + Arrays.deepToString(args);
            throw new ConstraintViolationException(message, violations);
        }
    }

    private void validateReturnValue(Object obj, Method method, Object value, Class<?>[] groups) {
        Set violations = this.methodValidator.validateReturnValue(obj, method, value, (Class[])groups);
        if (!violations.isEmpty()) {
            String message = "Invalid value returned by '" + method + "' was " + value;
            throw new ConstraintViolationException(message, violations);
        }
    }
}

