/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.webhooks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.webhooks.WebhookConfiguration;
import org.sonatype.nexus.webhooks.WebhookPayload;
import org.sonatype.nexus.webhooks.WebhookRequest;
import org.sonatype.nexus.webhooks.WebhookRequestSendEvent;
import org.sonatype.nexus.webhooks.WebhookSubscription;
import org.sonatype.nexus.webhooks.WebhookType;

public abstract class Webhook
extends ComponentSupport {
    private EventManager eventManager;
    private final Set<SubscriptionImpl> subscriptions = new CopyOnWriteArraySet<SubscriptionImpl>();

    @Inject
    public void setEventManager(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public abstract WebhookType getType();

    public abstract String getName();

    public String getId() {
        return "rm:" + this.getType() + ":" + this.getName();
    }

    protected Set<WebhookSubscription> getSubscriptions() {
        return ImmutableSet.copyOf(this.subscriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebhookSubscription subscribe(WebhookConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Set<SubscriptionImpl> set = this.subscriptions;
        synchronized (set) {
            SubscriptionImpl subscription = new SubscriptionImpl(configuration);
            this.subscriptions.add(subscription);
            this.log.debug("Added subscription: {}", (Object)subscription);
            if (this.subscriptions.size() == 1) {
                this.eventManager.register((Object)this);
                this.log.debug("Listening for events");
            }
            return subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(WebhookSubscription subscription) {
        Preconditions.checkNotNull((Object)subscription);
        Set<SubscriptionImpl> set = this.subscriptions;
        synchronized (set) {
            this.subscriptions.remove(subscription);
            this.log.debug("Removed subscription: {}", (Object)subscription);
            if (this.subscriptions.isEmpty()) {
                this.eventManager.unregister((Object)this);
                this.log.debug("Stopped listening for events");
            }
        }
    }

    protected void queue(WebhookSubscription subscription, WebhookPayload body) {
        this.log.debug("Queuing request for {} -> {}", (Object)subscription, (Object)body);
        WebhookRequest request = new WebhookRequest();
        request.setWebhook(this);
        request.setPayload(body);
        WebhookConfiguration configuration = subscription.getConfiguration();
        request.setUrl(configuration.getUrl());
        request.setSecret(configuration.getSecret());
        this.eventManager.post((Object)new WebhookRequestSendEvent(request));
    }

    public String toString() {
        return this.getId();
    }

    private class SubscriptionImpl
    implements WebhookSubscription {
        private final WebhookConfiguration configuration;

        public SubscriptionImpl(WebhookConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public WebhookConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public void cancel() {
            Webhook.this.unsubscribe(this);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "configuration=" + this.configuration + '}';
        }
    }
}

