/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.mime.MimeRule;

public class NexusMimeTypes {
    private static Logger log = LoggerFactory.getLogger(NexusMimeTypes.class);
    public static final String BUILTIN_MIMETYPES_FILENAME = "builtin-mimetypes.properties";
    public static final String MIMETYPES_FILENAME = "nexus.mimetypes";
    private Map<String, MimeRule> extensions = Maps.newHashMap();

    public NexusMimeTypes() {
        this.load(BUILTIN_MIMETYPES_FILENAME);
        this.load(MIMETYPES_FILENAME);
    }

    private void load(String filename) {
        InputStream stream = this.getClass().getResourceAsStream("/" + filename);
        if (stream != null) {
            Properties properties = new Properties();
            try {
                properties.load(stream);
                this.initMimeTypes(properties);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.warn("Could not load nexus.mimetypes", (Throwable)e);
                }
                log.warn("Could not load nexus.mimetypes: {}", (Object)e.getMessage());
            }
        }
    }

    @VisibleForTesting
    void initMimeTypes(Properties properties) {
        List mimetypes;
        Set<String> keys = properties.stringPropertyNames();
        HashMap overrides = Maps.newHashMap();
        HashMap additional = Maps.newHashMap();
        for (String key : keys) {
            if (key.startsWith("override.")) {
                overrides.put(key.substring("override.".length()), this.types(properties.getProperty(key, null)));
                continue;
            }
            additional.put(key, this.types(properties.getProperty(key, null)));
        }
        for (String extension : overrides.keySet()) {
            mimetypes = (List)overrides.get(extension);
            if (additional.containsKey(extension)) {
                mimetypes.addAll((Collection)additional.get(extension));
                additional.remove(extension);
            }
            this.extensions.put(extension, new MimeRule(true, mimetypes));
        }
        for (String extension : additional.keySet()) {
            mimetypes = (List)additional.get(extension);
            this.extensions.put(extension, new MimeRule(false, mimetypes));
        }
    }

    private List<String> types(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)value));
    }

    @Nullable
    public MimeRule getMimeRuleForExtension(String extension) {
        while (!extension.isEmpty()) {
            if (this.extensions.containsKey(extension)) {
                return this.extensions.get(extension);
            }
            extension = Files.getFileExtension((String)extension);
        }
        return null;
    }
}

