/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model;

import java.io.Serializable;

public class ScanReceipt
implements Serializable {
    private static final long serialVersionUID = 3364592229802071709L;
    private String scanId;
    private Long timeToReport;
    private String reportUrl;
    private String pdfUrl;
    private String dataUrl;
    private Integer reportTimeoutInSeconds;

    public String getScanId() {
        return this.scanId;
    }

    public void setScanId(String string) {
        this.scanId = string;
    }

    public Long getTimeToReport() {
        return this.timeToReport;
    }

    public void setTimeToReport(Long l2) {
        this.timeToReport = l2;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(String string) {
        this.reportUrl = string;
    }

    public String resolveReportUrl(String string) {
        return ScanReceipt.resolveUrl(string, this.getReportUrl());
    }

    public String getPdfUrl() {
        return this.pdfUrl;
    }

    public void setPdfUrl(String string) {
        this.pdfUrl = string;
    }

    public String resolvePdfUrl(String string) {
        return ScanReceipt.resolveUrl(string, this.getPdfUrl());
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String string) {
        this.dataUrl = string;
    }

    public String resolveDataUrl(String string) {
        return ScanReceipt.resolveUrl(string, this.getDataUrl());
    }

    private static String resolveUrl(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("server base URL missing");
        }
        if (string2 == null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(string);
        if (!string.endsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2.startsWith("/") ? string2.substring(1) : string2);
        return stringBuilder.toString();
    }

    public void waitForReport() throws InterruptedException {
        if (this.getTimeToReport() != null) {
            Thread.sleep(this.getTimeToReport() * 1000L);
        }
    }

    public Integer getReportTimeoutInSeconds() {
        return this.reportTimeoutInSeconds;
    }

    public void setReportTimeoutInSeconds(Integer n2) {
        this.reportTimeoutInSeconds = n2;
    }
}

