/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.ComponentInfo;
import com.sonatype.clm.dto.model.License;
import com.sonatype.clm.dto.model.SecurityVulnerability;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.ide.LicenseStatus;
import com.sonatype.clm.dto.model.policy.PolicyAlert;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ComponentDetails
implements ComponentInfo {
    private String hash;
    private String matchState;
    private Set<License> declaredLicenses;
    private Set<License> observedLicenses = new LinkedHashSet<License>();
    private Set<License> overriddenLicenses;
    private Set<License> effectiveLicenses;
    private LicenseStatus effectiveLicenseStatus;
    private Long catalogDate;
    private Integer relativePopularity;
    private List<SecurityVulnerability> securityVulnerabilities;
    private String website;
    private List<PolicyAlert> policyAlerts;
    private Integer licenseThreatLevel;
    private List<String> licenseThreatGroupNames;
    @Deprecated
    private boolean majorRevisionStep;
    private String identificationSource;
    private String identificationSourceComment;
    private ComponentIdentifier componentIdentifier;

    public ComponentDetails() {
        this.declaredLicenses = new LinkedHashSet<License>();
        this.overriddenLicenses = new LinkedHashSet<License>();
        this.effectiveLicenses = new LinkedHashSet<License>();
        this.securityVulnerabilities = new ArrayList<SecurityVulnerability>();
    }

    @Deprecated
    public ComponentDetails(String string, String string2, String string3) {
        this();
        this.componentIdentifier = ComponentIdentifier.createMavenCoordinates(string, string2, string3);
    }

    public ComponentDetails(ComponentIdentifier componentIdentifier) {
        this();
        this.componentIdentifier = componentIdentifier;
    }

    @Override
    @Deprecated
    public String getArtifactId() {
        return this.getMavenCoordinate("artifactId");
    }

    @Override
    public Long getCatalogDate() {
        return this.catalogDate;
    }

    public Set<License> getDeclaredLicenses() {
        return this.declaredLicenses;
    }

    @Override
    @Deprecated
    public String getGroupId() {
        return this.getMavenCoordinate("groupId");
    }

    public Set<License> getObservedLicenses() {
        return this.observedLicenses;
    }

    public Set<License> getOverriddenLicenses() {
        return this.overriddenLicenses;
    }

    public Set<License> getEffectiveLicenses() {
        return this.effectiveLicenses;
    }

    public LicenseStatus getEffectiveLicenseStatus() {
        return this.effectiveLicenseStatus;
    }

    public void setEffectiveLicenses(Set<License> set) {
        this.effectiveLicenses = set;
    }

    public void setEffectiveLicenseStatus(LicenseStatus licenseStatus) {
        this.effectiveLicenseStatus = licenseStatus;
    }

    public List<PolicyAlert> getPolicyAlerts() {
        return this.policyAlerts;
    }

    @Override
    public Integer getRelativePopularity() {
        return this.relativePopularity;
    }

    @Override
    public List<SecurityVulnerability> getSecurityVulnerabilities() {
        return this.securityVulnerabilities;
    }

    @Override
    @Deprecated
    public String getVersion() {
        return this.getMavenCoordinate("version");
    }

    private String getMavenCoordinate(String string) {
        return this.componentIdentifier != null && this.componentIdentifier.isMaven() ? this.componentIdentifier.get(string) : null;
    }

    public void setCatalogDate(Long l2) {
        this.catalogDate = l2;
    }

    public void setDeclaredLicenses(Set<License> set) {
        this.declaredLicenses = set;
    }

    public void setObservedLicenses(Set<License> set) {
        this.observedLicenses = set;
    }

    public void setOverriddenLicenses(Set<License> set) {
        this.overriddenLicenses = set;
    }

    public void setPolicyAlerts(List<PolicyAlert> list) {
        this.policyAlerts = list;
    }

    public void setRelativePopularity(Integer n2) {
        this.relativePopularity = n2;
    }

    public void setSecurityVulnerabilities(List<SecurityVulnerability> list) {
        this.securityVulnerabilities = list;
    }

    public void addSecurityVulnerability(SecurityVulnerability securityVulnerability) {
        if (securityVulnerability == null) {
            return;
        }
        this.securityVulnerabilities.add(securityVulnerability);
    }

    public Integer getLicenseThreatLevel() {
        return this.licenseThreatLevel;
    }

    public void setLicenseThreatLevel(Integer n2) {
        this.licenseThreatLevel = n2;
    }

    public List<String> getLicenseThreatGroupNames() {
        return this.licenseThreatGroupNames;
    }

    public void setLicenseThreatGroupNames(List<String> list) {
        this.licenseThreatGroupNames = list;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public void setHash(String string) {
        this.hash = string;
    }

    @Override
    public String getMatchState() {
        return this.matchState;
    }

    public void setMatchState(String string) {
        this.matchState = string;
    }

    @Override
    public Set<String> getDeclaredLicenseIds() {
        return this.toLicenseIds(this.getDeclaredLicenses());
    }

    @Override
    public Set<String> getObservedLicenseIds() {
        return this.toLicenseIds(this.getObservedLicenses());
    }

    private Set<String> toLicenseIds(Set<License> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (License license : set) {
            linkedHashSet.add(license.getLicenseId());
        }
        return linkedHashSet;
    }

    public boolean isMajorRevisionStep() {
        return this.majorRevisionStep;
    }

    public void setMajorRevisionStep(boolean bl2) {
        this.majorRevisionStep = bl2;
    }

    @Override
    public String getIdentificationSource() {
        return this.identificationSource;
    }

    public void setIdentificationSource(String string) {
        this.identificationSource = string;
    }

    public String getIdentificationSourceComment() {
        return this.identificationSourceComment;
    }

    public void setIdentificationSourceComment(String string) {
        this.identificationSourceComment = string;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String string) {
        this.website = string;
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setComponentIdentifier(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }
}

