/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import java.util.Map;

public class ComponentDisplayNameUtil {
    public static final String GAV_SEPARATOR = " : ";
    public static final String NUGET_SEPARATOR = " ";
    public static final String ANAME_SEPARATOR = " ";
    public static final String GROUP_LABEL = "Group";
    public static final String ARTIFACT_LABEL = "Artifact";
    public static final String VERSION_LABEL = "Version";
    public static final String EXTENSION_LABEL = "Extension";
    public static final String CLASSIFIER_LABEL = "Classifier";
    public static final String ID_LABEL = "ID";
    public static final String NAME_LABEL = "Name";
    public static final String QUALIFIER_LABEL = "Qualifier";
    public static final String ARCHITECTURE_LABEL = "Architecture";
    public static final String PLATFORM_LABEL = "Platform";

    private static ComponentDisplayName fromGavec(String string, String string2, String string3, String string4, String string5) {
        boolean bl2;
        if (string == null) {
            return null;
        }
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(GROUP_LABEL, string).add(GAV_SEPARATOR).add(ARTIFACT_LABEL, string2);
        boolean bl3 = string5 != null && !string5.isEmpty();
        boolean bl4 = bl2 = string4 != null && !string4.isEmpty() && (!string4.equalsIgnoreCase("jar") || bl3);
        if (bl2) {
            componentDisplayName.add(GAV_SEPARATOR).add(EXTENSION_LABEL, string4);
        } else if (bl3) {
            componentDisplayName.add(GAV_SEPARATOR);
        }
        if (bl3) {
            componentDisplayName.add(GAV_SEPARATOR).add(CLASSIFIER_LABEL, string5);
        }
        return componentDisplayName.add(GAV_SEPARATOR).add(VERSION_LABEL, string3);
    }

    private static ComponentDisplayName fromNuGet(String string, String string2) {
        return new ComponentDisplayName().add(ID_LABEL, string).add(" ").add(VERSION_LABEL, string2);
    }

    private static ComponentDisplayName fromAname(String string, String string2, String string3) {
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(NAME_LABEL, string);
        if (string3 != null && !string3.isEmpty()) {
            componentDisplayName.add(" ").add("(").add(QUALIFIER_LABEL, string3).add(")");
        }
        componentDisplayName.add(" ").add(VERSION_LABEL, string2);
        return componentDisplayName;
    }

    private static ComponentDisplayName fromPypi(String string, String string2, String string3, String string4) {
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(NAME_LABEL, string);
        if (string3 != null && !string3.isEmpty()) {
            componentDisplayName.add(" (").add(QUALIFIER_LABEL, string3).add(")");
        }
        componentDisplayName.add(" ").add(VERSION_LABEL, string2);
        componentDisplayName.add(" (.").add(EXTENSION_LABEL, string4).add(")");
        return componentDisplayName;
    }

    private static ComponentDisplayName fromRpm(String string, String string2, String string3) {
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(NAME_LABEL, string);
        componentDisplayName.add("-").add(VERSION_LABEL, string2);
        if (string3 != null && !string3.isEmpty()) {
            componentDisplayName.add(".").add(ARCHITECTURE_LABEL, string3);
        }
        return componentDisplayName;
    }

    private static ComponentDisplayName fromRubyGems(String string, String string2, String string3) {
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(NAME_LABEL, string);
        if (string3 != null && !"".equals(string3) && !"ruby".equals(string3)) {
            componentDisplayName.add(" (").add(PLATFORM_LABEL, string3).add(") ");
        } else {
            componentDisplayName.add(" ");
        }
        componentDisplayName.add(VERSION_LABEL, string2);
        return componentDisplayName;
    }

    public static ComponentDisplayName fromIdentifier(ComponentIdentifier componentIdentifier) {
        if (componentIdentifier == null) {
            return null;
        }
        if (componentIdentifier.isMaven()) {
            return ComponentDisplayNameUtil.fromGavec(componentIdentifier.get("groupId"), componentIdentifier.get("artifactId"), componentIdentifier.get("version"), componentIdentifier.get("extension"), componentIdentifier.get("classifier"));
        }
        if ("nuget".equals(componentIdentifier.getFormat())) {
            return ComponentDisplayNameUtil.fromNuGet(componentIdentifier.get("packageId"), componentIdentifier.get("version"));
        }
        if ("a-name".equals(componentIdentifier.getFormat())) {
            return ComponentDisplayNameUtil.fromAname(componentIdentifier.get("name"), componentIdentifier.get("version"), componentIdentifier.get("qualifier"));
        }
        if ("pypi".equals(componentIdentifier.getFormat())) {
            return ComponentDisplayNameUtil.fromPypi(componentIdentifier.get("name"), componentIdentifier.get("version"), componentIdentifier.get("qualifier"), componentIdentifier.get("extension"));
        }
        if ("rpm".equals(componentIdentifier.getFormat())) {
            return ComponentDisplayNameUtil.fromRpm(componentIdentifier.get("name"), componentIdentifier.get("version"), componentIdentifier.get("architecture"));
        }
        if ("gem".equals(componentIdentifier.getFormat())) {
            return ComponentDisplayNameUtil.fromRubyGems(componentIdentifier.get("name"), componentIdentifier.get("version"), componentIdentifier.get("platform"));
        }
        ComponentDisplayName componentDisplayName = new ComponentDisplayName();
        boolean bl2 = true;
        for (Map.Entry<String, String> entry : componentIdentifier.getCoordinates().entrySet()) {
            if (!bl2) {
                componentDisplayName.add(GAV_SEPARATOR);
            }
            bl2 = false;
            componentDisplayName.add(entry.getKey(), entry.getValue());
        }
        return componentDisplayName;
    }
}

