/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.component.InvalidComponentIdentifierException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import zz.com.fasterxml.jackson.annotation.JsonIgnore;

public class ComponentIdentifier
implements Comparable<ComponentIdentifier> {
    static final String MUST_HAVE_FORMAT_MESSAGE = "A component identifier must have a format.";
    static final String MUST_HAVE_COORDINATE_MESSAGE = "A component identifier must have at least one coordinate.";
    static final String INCORRECT_COORDINATES = "Coordinates contain the following incorrect entries for the given format: ";
    static final String MISSING_COORDINATES = "The following coordinates are missing for given format: ";
    private static final SortedMap<String, String> UNMODIFIABLE_EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    private String format;
    private SortedMap<String, String> coordinates;
    public static final String NPM_PACKAGE_ID = "packageId";
    public static final String NUGET_PACKAGE_ID = "packageId";
    public static final String VERSION = "version";
    public static final String MAVEN_EXTENSION = "extension";
    public static final String MAVEN_CLASSIFIER = "classifier";
    public static final String MAVEN_ARTIFACT_ID = "artifactId";
    public static final String MAVEN_GROUP_ID = "groupId";
    public static final String ANAME_NAME = "name";
    public static final String ANAME_QUALIFIER = "qualifier";
    public static final String PYPI_NAME = "name";
    public static final String PYPI_QUALIFIER = "qualifier";
    public static final String PYPI_EXTENSION = "extension";
    public static final String RPM_NAME = "name";
    public static final String RPM_ARCHITECTURE = "architecture";
    public static final String RUBYGEMS_NAME = "name";
    public static final String RUBYGEMS_PLATFORM = "platform";
    static final String RUBYGEMS_PLATFORM_DEFAULT = "ruby";
    private static final LinkedHashSet<String> MAVEN_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "classifier", "extension"));
    private static final LinkedHashSet<String> MAVEN_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "extension"));
    private static final LinkedHashSet<String> ANAME_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "qualifier"));
    private static final LinkedHashSet<String> ANAME_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> NPM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NPM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NUGET_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NUGET_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> PYPI_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "qualifier", "extension"));
    private static final LinkedHashSet<String> PYPI_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version", "extension"));
    private static final LinkedHashSet<String> RPM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "architecture"));
    private static final LinkedHashSet<String> RPM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version", "architecture"));
    private static final LinkedHashSet<String> RUBYGEMS_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "platform"));
    private static final LinkedHashSet<String> RUBYGEMS_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    public static final String FORMAT_MAVEN = "maven";
    public static final String FORMAT_NPM = "npm";
    public static final String FORMAT_NUGET = "nuget";
    public static final String FORMAT_ANAME = "a-name";
    public static final String FORMAT_PYPI = "pypi";
    public static final String FORMAT_RPM = "rpm";
    public static final String FORMAT_RUBYGEMS = "gem";
    private static final Map<String, Set<String>> FORMAT_TO_COORDINATES = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> FORMAT_TO_REQUIRED_COORDINATES;

    public ComponentIdentifier() {
    }

    public ComponentIdentifier(String string, Map<String, String> map) {
        this.format = string;
        this.setCoordinates(map);
        this.validate();
    }

    public String get(String string) {
        return (String)this.coordinates.get(string);
    }

    public ComponentIdentifier createAlternativeVersion(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.coordinates);
        linkedHashMap.put(VERSION, string);
        return new ComponentIdentifier(this.format, linkedHashMap);
    }

    public static Set<String> getAllCoordinateNames(String string) {
        if (!FORMAT_TO_COORDINATES.containsKey(string)) {
            return Collections.emptySet();
        }
        return FORMAT_TO_COORDINATES.get(string);
    }

    public static Set<String> getAllRequiredCoordinateNames(String string) {
        if (!FORMAT_TO_REQUIRED_COORDINATES.containsKey(string)) {
            return Collections.emptySet();
        }
        return FORMAT_TO_REQUIRED_COORDINATES.get(string);
    }

    public static ComponentIdentifier createNpmCoordinates(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("packageId", string);
        linkedHashMap.put(VERSION, string2);
        return new ComponentIdentifier(FORMAT_NPM, linkedHashMap);
    }

    public static ComponentIdentifier createNugetCoordinates(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("packageId", string);
        linkedHashMap.put(VERSION, string2);
        return new ComponentIdentifier(FORMAT_NUGET, linkedHashMap);
    }

    public static ComponentIdentifier createMavenCoordinates(String string, String string2, String string3, String string4, String string5) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(MAVEN_GROUP_ID, string);
        linkedHashMap.put(MAVEN_ARTIFACT_ID, string2);
        linkedHashMap.put(VERSION, string3);
        linkedHashMap.put(MAVEN_CLASSIFIER, string4);
        linkedHashMap.put("extension", string5);
        return new ComponentIdentifier(FORMAT_MAVEN, linkedHashMap);
    }

    public static ComponentIdentifier createMavenCoordinates(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(MAVEN_GROUP_ID, string);
        linkedHashMap.put(MAVEN_ARTIFACT_ID, string2);
        linkedHashMap.put(VERSION, string3);
        return new ComponentIdentifier(FORMAT_MAVEN, linkedHashMap);
    }

    public static ComponentIdentifier createAnameCoordinates(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("name", string);
        linkedHashMap.put("qualifier", string2);
        linkedHashMap.put(VERSION, string3);
        return new ComponentIdentifier(FORMAT_ANAME, linkedHashMap);
    }

    public static ComponentIdentifier createPypiCoordinates(String string, String string2, String string3, String string4) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("name", string);
        linkedHashMap.put(VERSION, string2);
        linkedHashMap.put("qualifier", string3);
        linkedHashMap.put("extension", string4);
        return new ComponentIdentifier(FORMAT_PYPI, linkedHashMap);
    }

    public static ComponentIdentifier createRpmCoordinates(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("name", string);
        linkedHashMap.put(VERSION, string2);
        linkedHashMap.put(RPM_ARCHITECTURE, string3);
        return new ComponentIdentifier(FORMAT_RPM, linkedHashMap);
    }

    public static ComponentIdentifier createRubyGemsCoordinates(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("name", string);
        linkedHashMap.put(VERSION, string2);
        linkedHashMap.put(RUBYGEMS_PLATFORM, string3);
        return new ComponentIdentifier(FORMAT_RUBYGEMS, linkedHashMap);
    }

    public void ensureComplete() throws InvalidComponentIdentifierException {
        if (this.isMaven()) {
            this.validateRequiredCoordinates(MAVEN_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey(MAVEN_CLASSIFIER)) {
                this.coordinates.put(MAVEN_CLASSIFIER, "");
            }
        } else if (FORMAT_NPM.equals(this.format)) {
            this.validateRequiredCoordinates(NPM_REQUIRED_COORDINATES);
        } else if (FORMAT_NUGET.equals(this.format)) {
            this.validateRequiredCoordinates(NUGET_REQUIRED_COORDINATES);
        } else if (FORMAT_ANAME.equals(this.format)) {
            this.validateRequiredCoordinates(ANAME_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey("qualifier")) {
                this.coordinates.put("qualifier", "");
            }
        } else if (FORMAT_PYPI.equals(this.format)) {
            this.validateRequiredCoordinates(PYPI_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey("qualifier")) {
                this.coordinates.put("qualifier", "");
            }
        } else if (FORMAT_RPM.equals(this.format)) {
            this.validateRequiredCoordinates(RPM_REQUIRED_COORDINATES);
        } else if (FORMAT_RUBYGEMS.equals(this.format)) {
            this.validateRequiredCoordinates(RUBYGEMS_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey(RUBYGEMS_PLATFORM) || "".equals(this.coordinates.get(RUBYGEMS_PLATFORM))) {
                this.coordinates.put(RUBYGEMS_PLATFORM, RUBYGEMS_PLATFORM_DEFAULT);
            }
        }
    }

    private void validateRequiredCoordinates(Set<String> set) throws InvalidComponentIdentifierException {
        if (!this.coordinates.keySet().containsAll(set)) {
            TreeSet<String> treeSet = new TreeSet<String>(set);
            treeSet.removeAll(this.coordinates.keySet());
            throw new InvalidComponentIdentifierException(MISSING_COORDINATES + treeSet);
        }
    }

    public String toString() {
        return this.format + ": " + this.coordinates;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + ComponentIdentifier.hash(this.format);
        n3 = 31 * n3 + ComponentIdentifier.hash(this.coordinates);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ComponentIdentifier)) {
            return false;
        }
        ComponentIdentifier componentIdentifier = (ComponentIdentifier)object;
        if (!ComponentIdentifier.eq(this.format, componentIdentifier.format)) {
            return false;
        }
        return this.coordinates.equals(componentIdentifier.getCoordinates());
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 == null ? t3 == null : t2.equals(t3);
    }

    private static int hash(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    @Override
    public int compareTo(ComponentIdentifier componentIdentifier) {
        int n2 = this.format.compareTo(componentIdentifier.format);
        if (n2 != 0) {
            return n2;
        }
        if (this.isMaven()) {
            return this.compareCoordinates(componentIdentifier, MAVEN_COORDINATE_NAMES);
        }
        if (FORMAT_NPM.equals(this.format)) {
            return this.compareCoordinates(componentIdentifier, NPM_COORDINATE_NAMES);
        }
        if (FORMAT_NUGET.equals(this.format)) {
            return this.compareCoordinates(componentIdentifier, NUGET_COORDINATE_NAMES);
        }
        if (FORMAT_ANAME.equals(this.format)) {
            return this.compareCoordinates(componentIdentifier, ANAME_COORDINATE_NAMES);
        }
        if (FORMAT_PYPI.equals(this.format)) {
            return this.compareCoordinates(componentIdentifier, PYPI_COORDINATE_NAMES);
        }
        if (FORMAT_RPM.equals(this.format)) {
            return this.compareCoordinates(componentIdentifier, RPM_COORDINATE_NAMES);
        }
        if (FORMAT_RUBYGEMS.equals(this.format)) {
            return this.compareCoordinates(componentIdentifier, RUBYGEMS_COORDINATE_NAMES);
        }
        return ComponentIdentifier.join(this.coordinates).compareTo(ComponentIdentifier.join(componentIdentifier.coordinates));
    }

    private int compareCoordinates(ComponentIdentifier componentIdentifier, LinkedHashSet<String> linkedHashSet) {
        for (String string : linkedHashSet) {
            int n2 = ComponentIdentifier.compareNullableStrings(this.get(string), componentIdentifier.get(string));
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private static String join(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.values()) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static int compareNullableStrings(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        return string.compareTo(string2);
    }

    public String getFormat() {
        return this.format;
    }

    public SortedMap<String, String> getCoordinates() {
        if (this.coordinates == null) {
            return UNMODIFIABLE_EMPTY_SORTED_MAP;
        }
        return Collections.unmodifiableSortedMap(this.coordinates);
    }

    public void validate() throws InvalidComponentIdentifierException {
        if (this.format == null || this.format.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_FORMAT_MESSAGE);
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_COORDINATE_MESSAGE);
        }
        if (this.format.equals(FORMAT_MAVEN)) {
            this.validateNoUnexpectedCoordinates(MAVEN_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NPM)) {
            this.validateNoUnexpectedCoordinates(NPM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NUGET)) {
            this.validateNoUnexpectedCoordinates(NUGET_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_ANAME)) {
            this.validateNoUnexpectedCoordinates(ANAME_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_PYPI)) {
            this.validateNoUnexpectedCoordinates(PYPI_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_RPM)) {
            this.validateNoUnexpectedCoordinates(RPM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_RUBYGEMS)) {
            this.validateNoUnexpectedCoordinates(RUBYGEMS_COORDINATE_NAMES);
        }
    }

    private void validateNoUnexpectedCoordinates(Set<String> set) {
        if (!set.containsAll(this.coordinates.keySet())) {
            TreeSet<String> treeSet = new TreeSet<String>(this.coordinates.keySet());
            treeSet.removeAll(set);
            throw new InvalidComponentIdentifierException(INCORRECT_COORDINATES + treeSet);
        }
    }

    private void setCoordinates(Map<String, String> map) {
        if (map == null) {
            return;
        }
        this.coordinates = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            this.coordinates.put(entry.getKey(), entry.getValue());
        }
    }

    @JsonIgnore
    public boolean isMaven() {
        return FORMAT_MAVEN.equals(this.format);
    }

    @JsonIgnore
    public boolean isAname() {
        return FORMAT_ANAME.equals(this.format);
    }

    static {
        FORMAT_TO_COORDINATES.put(FORMAT_MAVEN, Collections.unmodifiableSet(MAVEN_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_ANAME, Collections.unmodifiableSet(ANAME_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_NPM, Collections.unmodifiableSet(NPM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_NUGET, Collections.unmodifiableSet(NUGET_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_PYPI, Collections.unmodifiableSet(PYPI_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_RPM, Collections.unmodifiableSet(RPM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_RUBYGEMS, Collections.unmodifiableSet(RUBYGEMS_COORDINATE_NAMES));
        FORMAT_TO_REQUIRED_COORDINATES = new HashMap<String, Set<String>>();
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_MAVEN, Collections.unmodifiableSet(MAVEN_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_ANAME, Collections.unmodifiableSet(ANAME_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_NPM, Collections.unmodifiableSet(NPM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_NUGET, Collections.unmodifiableSet(NUGET_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_PYPI, Collections.unmodifiableSet(PYPI_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_RPM, Collections.unmodifiableSet(RPM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_RUBYGEMS, Collections.unmodifiableSet(RUBYGEMS_REQUIRED_COORDINATES));
    }
}

