/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.policy.ConstraintFact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonIgnore;

public class ComponentFact
implements Cloneable {
    private ComponentIdentifier componentIdentifier;
    private String hash;
    private List<ConstraintFact> constraintFacts;
    private List<String> pathnames = new ArrayList<String>();
    private ComponentDisplayName displayName;

    public ComponentFact() {
    }

    public ComponentFact(ComponentIdentifier componentIdentifier, String string) {
        this.componentIdentifier = componentIdentifier;
        this.hash = string;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public String getHash() {
        return this.hash;
    }

    public ComponentDisplayName getDisplayName() {
        return this.displayName;
    }

    public List<ConstraintFact> getConstraintFacts() {
        return this.constraintFacts != null ? Collections.unmodifiableList(this.constraintFacts) : Collections.EMPTY_LIST;
    }

    public List<String> getPathnames() {
        return Collections.unmodifiableList(this.pathnames);
    }

    public void addConstraintFact(ConstraintFact constraintFact) {
        if (this.constraintFacts == null) {
            this.constraintFacts = new ArrayList<ConstraintFact>();
        }
        this.constraintFacts.add(constraintFact);
    }

    public void addPathnames(List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            if (string == null || string.trim().isEmpty()) continue;
            this.pathnames.add(string);
        }
    }

    public void setDisplayName(ComponentDisplayName componentDisplayName) {
        this.displayName = componentDisplayName;
    }

    public ComponentFact with(List<ConstraintFact> list) {
        try {
            ComponentFact componentFact = (ComponentFact)this.clone();
            componentFact.constraintFacts = list;
            return componentFact;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException();
        }
    }

    public ComponentFact with(ConstraintFact ... constraintFactArray) {
        return this.with(Arrays.asList(constraintFactArray));
    }

    @JsonIgnore
    public String getComponentId() {
        return this.hash;
    }

    public String toString() {
        return "\n Component(displayName=" + this.displayName + ", hash=" + this.hash + ") " + this.constraintFacts;
    }
}

