/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import com.sonatype.clm.dto.model.policy.ComponentFact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonInclude;

public class PolicyFact
implements Cloneable {
    private String policyId;
    private String policyName;
    private int threatLevel;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ComponentFact> componentFacts;

    public PolicyFact() {
    }

    public PolicyFact(String string, String string2, int n2) {
        this.policyId = string;
        this.policyName = string2;
        this.threatLevel = n2;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public int getThreatLevel() {
        return this.threatLevel;
    }

    public List<ComponentFact> getComponentFacts() {
        return this.componentFacts != null ? Collections.unmodifiableList(this.componentFacts) : Collections.EMPTY_LIST;
    }

    public void setComponentFacts(List<ComponentFact> list) {
        this.componentFacts = list;
    }

    public void addComponentFact(ComponentFact componentFact) {
        if (this.componentFacts == null) {
            this.componentFacts = new ArrayList<ComponentFact>();
        }
        this.componentFacts.add(componentFact);
    }

    public PolicyFact with(List<ComponentFact> list) {
        try {
            PolicyFact policyFact = (PolicyFact)this.clone();
            policyFact.componentFacts = list;
            return policyFact;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException();
        }
    }

    public PolicyFact with(ComponentFact ... componentFactArray) {
        return this.with(Arrays.asList(componentFactArray));
    }

    public String toString() {
        return "\nPolicy(" + this.policyName + ") " + this.componentFacts;
    }
}

