/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.rest;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.clm.dto.model.Resource;
import com.sonatype.clm.dto.model.ScanReceipt;
import com.sonatype.clm.dto.model.application.ApplicationSummaryList;
import com.sonatype.clm.dto.model.component.FirewallIgnorePatterns;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.component.UnquarantinedComponentList;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationResult;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.clm.dto.model.repository.migration.MigrationDetails;
import com.sonatype.insight.rm.rest.Stage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;

public interface RestClient {

    public static interface FirewallMigration {
        public static final String PROTOCOL_V1 = "v1";

        public void verifyMigrationSupport(String var1) throws IOException;

        public void migrateRepositoryHistory(String var1, String var2, String var3, String var4) throws IOException;

        public MigrationDetails getRepositoryMigrationState(String var1, String var2) throws IOException;
    }

    public static interface Repository {
        public void setEnabled(boolean var1) throws IOException;

        public void setQuarantine(boolean var1) throws IOException;

        public void removeComponent(String var1) throws IOException;

        public void evaluateComponents(RepositoryComponentEvaluationDataRequestList var1) throws IOException;

        public RepositoryComponentEvaluationDataList evaluateComponentWithQuarantine(RepositoryComponentEvaluationDataRequestList var1) throws IOException;

        public RepositoryPolicyEvaluationSummary getPolicyEvaluationSummary() throws IOException;

        public UnquarantinedComponentList getUnquarantinedComponents(long var1) throws IOException;
    }

    public static interface Scan {
        public PolicyEvaluationResult evaluatePolicies(Stage var1) throws IOException;
    }

    public static interface App {
        public ScanReceipt uploadScan(File var1) throws IOException;

        public Scan forScan(String var1);
    }

    public static interface Base {
        public void validateConfiguration() throws IOException;

        public ApplicationSummaryList getApplicationsForApplicationEvaluation() throws IOException;

        public ProprietaryConfig getProprietaryConfigForApplicationEvaluation(String var1) throws IOException;

        public App forApplication(String var1);

        public Repository forRepository(String var1, String var2);

        public FirewallMigration forFirewallMigration();

        public Resource getResource(String var1) throws IOException, URISyntaxException;

        public Resource getResource(String var1, Map<String, String[]> var2) throws IOException, URISyntaxException;

        public FirewallIgnorePatterns getFirewallIgnorePatterns() throws IOException;
    }
}

