/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.rest;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.clm.dto.model.Resource;
import com.sonatype.clm.dto.model.ScanReceipt;
import com.sonatype.clm.dto.model.application.ApplicationSummaryList;
import com.sonatype.clm.dto.model.component.FirewallIgnorePatterns;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.component.UnquarantinedComponentList;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationResult;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.clm.dto.model.repository.migration.MigrationDetails;
import com.sonatype.insight.rm.rest.HttpException;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.insight.rm.rest.Stage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.utils.URIBuilder;
import zz.b;
import zz.c;
import zz.d;
import zz.e;
import zz.g;
import zz.j;
import zz.q;

public class RestClientFactory {
    public RestClient.Base forConfiguration(RestClientConfiguration restClientConfiguration) {
        if (restClientConfiguration == null) {
            throw new IllegalArgumentException("REST client configuration missing");
        }
        return new BaseClient(restClientConfiguration.getConfig());
    }

    b newConfigurationClient(q.a a2) {
        return new b(a2);
    }

    c newFirewallClient(q.a a2, String string, String string2) {
        return new c(a2, string, string2);
    }

    d newFirewallMigrationClient(q.a a2) {
        return new d(a2);
    }

    j newScanClient(q.a a2, String string) {
        return new j(a2, string);
    }

    private class FirewallMigrationSpecificClient
    extends BaseClient
    implements RestClient.FirewallMigration {
        FirewallMigrationSpecificClient(q.a a2) {
            super(a2);
        }

        @Override
        public void verifyMigrationSupport(String string) throws IOException {
            RestClientFactory.this.newFirewallMigrationClient(this.config).a(string);
        }

        @Override
        public void migrateRepositoryHistory(String string, String string2, String string3, String string4) throws IOException {
            RestClientFactory.this.newFirewallMigrationClient(this.config).a(string, string2, string3, string4);
        }

        @Override
        public MigrationDetails getRepositoryMigrationState(String string, String string2) throws IOException {
            return RestClientFactory.this.newFirewallMigrationClient(this.config).a(string, string2);
        }
    }

    private class ScanSpecificClient
    extends AppSpecificClient
    implements RestClient.Scan {
        protected final String scanId;

        public ScanSpecificClient(q.a a2, String string, String string2) {
            super(a2, string);
            this.scanId = string2;
        }

        @Override
        public PolicyEvaluationResult evaluatePolicies(Stage stage) throws IOException {
            com.sonatype.clm.dto.model.policy.Stage stage2;
            if (stage == null) {
                throw new IllegalArgumentException("stage missing");
            }
            switch (stage) {
                case CLOSE_REPOSITORY: {
                    stage2 = new com.sonatype.clm.dto.model.policy.Stage("stage-release");
                    break;
                }
                case RELEASE_REPOSITORY: {
                    stage2 = new com.sonatype.clm.dto.model.policy.Stage("release");
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported stage " + (Object)((Object)stage));
                }
            }
            return new e(this.config, this.appId).a(this.scanId, stage2);
        }
    }

    private class AppSpecificClient
    extends BaseClient
    implements RestClient.App {
        protected final String appId;

        public AppSpecificClient(q.a a2, String string) {
            super(a2);
            this.appId = string;
        }

        @Override
        public ScanReceipt uploadScan(File file) throws IOException {
            try {
                return RestClientFactory.this.newScanClient(this.config, this.appId).b(file);
            }
            catch (IOException iOException) {
                throw this.handleError(iOException);
            }
        }

        @Override
        public RestClient.Scan forScan(String string) {
            return new ScanSpecificClient(this.config, this.appId, string);
        }
    }

    private class RepositorySpecificClient
    extends BaseClient
    implements RestClient.Repository {
        private final String repositoryManagerInstanceId;
        private final String repositoryPublicId;

        public RepositorySpecificClient(q.a a2, String string, String string2) {
            super(a2);
            this.repositoryManagerInstanceId = string;
            this.repositoryPublicId = string2;
        }

        @Override
        public void setEnabled(boolean bl2) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).a(bl2);
        }

        @Override
        public void setQuarantine(boolean bl2) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).b(bl2);
        }

        @Override
        public void evaluateComponents(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).a(repositoryComponentEvaluationDataRequestList);
        }

        @Override
        public RepositoryComponentEvaluationDataList evaluateComponentWithQuarantine(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).b(repositoryComponentEvaluationDataRequestList);
        }

        @Override
        public RepositoryPolicyEvaluationSummary getPolicyEvaluationSummary() throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).a();
        }

        @Override
        public void removeComponent(String string) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).a(string);
        }

        @Override
        public UnquarantinedComponentList getUnquarantinedComponents(long l2) throws IOException {
            try {
                return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId).a(l2);
            }
            catch (HttpResponseException httpResponseException) {
                if (httpResponseException.getStatusCode() == 405) {
                    throw new UnsupportedOperationException("IQ Server doesn't support unquarantined component updates, upgrade it to version 1.20, or newer, to support it.", httpResponseException);
                }
                throw httpResponseException;
            }
        }
    }

    private class BaseClient
    implements RestClient.Base {
        protected final q.a config;

        public BaseClient(q.a a2) {
            this.config = a2;
        }

        @Override
        public void validateConfiguration() throws IOException {
            try {
                RestClientFactory.this.newConfigurationClient(this.config).c();
            }
            catch (IOException iOException) {
                throw this.handleError(iOException);
            }
        }

        @Override
        public ApplicationSummaryList getApplicationsForApplicationEvaluation() throws IOException {
            try {
                return RestClientFactory.this.newConfigurationClient(this.config).a();
            }
            catch (IOException iOException) {
                throw this.handleError(iOException);
            }
        }

        @Override
        public RestClient.App forApplication(String string) {
            return new AppSpecificClient(this.config, string);
        }

        protected IOException handleError(IOException iOException) {
            if (iOException instanceof HttpResponseException) {
                HttpResponseException httpResponseException = (HttpResponseException)((Object)iOException);
                return new HttpException(httpResponseException.getStatusCode(), httpResponseException.getMessage(), httpResponseException);
            }
            return iOException;
        }

        @Override
        public Resource getResource(String string) throws IOException, URISyntaxException {
            return this.getResource(string, Collections.emptyMap());
        }

        @Override
        public Resource getResource(String string, Map<String, String[]> map) throws IOException, URISyntaxException {
            URIBuilder uRIBuilder = new URIBuilder();
            uRIBuilder.setPath(string);
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                for (String string2 : entry.getValue()) {
                    uRIBuilder.addParameter(entry.getKey(), string2);
                }
            }
            return new g(this.config).a(uRIBuilder.build().toString());
        }

        @Override
        public RestClient.Repository forRepository(String string, String string2) {
            return new RepositorySpecificClient(this.config, string, string2);
        }

        @Override
        public RestClient.FirewallMigration forFirewallMigration() {
            return new FirewallMigrationSpecificClient(this.config);
        }

        @Override
        public ProprietaryConfig getProprietaryConfigForApplicationEvaluation(String string) throws IOException {
            try {
                return RestClientFactory.this.newConfigurationClient(this.config).c(string);
            }
            catch (IOException iOException) {
                throw this.handleError(iOException);
            }
        }

        @Override
        public FirewallIgnorePatterns getFirewallIgnorePatterns() throws IOException {
            try {
                return RestClientFactory.this.newConfigurationClient(this.config).d();
            }
            catch (HttpResponseException httpResponseException) {
                if (httpResponseException.getStatusCode() == 404) {
                    throw new UnsupportedOperationException("IQ Server doesn't support firewall ignore patterns, upgrade it to version 1.35, or newer, to support it.", httpResponseException);
                }
                throw this.handleError((IOException)((Object)httpResponseException));
            }
        }
    }
}

