/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.scan;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.insight.rm.scan.RepositoryItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ScanConfiguration {
    private File workDir = ScanConfiguration.getDefaultWorkDir();
    private Properties scanOptions = new Properties();
    private String repositoryId;
    private String repositoryName;
    private String repositoryFormat;
    private ProprietaryConfig proprietaryConfig;
    private final List<RepositoryItem> componentItems = new ArrayList<RepositoryItem>(128);
    private final List<RepositoryItem> scanItems = new ArrayList<RepositoryItem>();

    private static File getDefaultWorkDir() {
        return new File(System.getProperty("java.io.tmpdir", "")).getAbsoluteFile();
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public ScanConfiguration setWorkDir(File file) {
        this.workDir = file != null ? file : ScanConfiguration.getDefaultWorkDir();
        return this;
    }

    public Properties getScanOptions() {
        return this.scanOptions;
    }

    public ScanConfiguration setScanOptions(Properties properties) {
        this.scanOptions.clear();
        if (properties != null) {
            this.scanOptions.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public ScanConfiguration setScanOption(String string, String string2) {
        if (string2 == null) {
            this.scanOptions.remove(string);
        } else {
            this.scanOptions.setProperty(string, string2);
        }
        return this;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryFormat() {
        return this.repositoryFormat;
    }

    public ScanConfiguration setRepository(String string, String string2, String string3) {
        this.repositoryId = string;
        this.repositoryFormat = string2;
        this.repositoryName = string3;
        return this;
    }

    public ScanConfiguration setProprietaryConfig(ProprietaryConfig proprietaryConfig) {
        this.proprietaryConfig = proprietaryConfig;
        return this;
    }

    public ProprietaryConfig getProprietaryConfig() {
        return this.proprietaryConfig;
    }

    public void addItem(RepositoryItem repositoryItem) {
        if (repositoryItem != null) {
            if (this.isScanItem(repositoryItem)) {
                this.scanItems.add(repositoryItem);
            } else if (this.isComponentItem(repositoryItem)) {
                this.componentItems.add(repositoryItem);
            }
        }
    }

    private boolean isScanItem(RepositoryItem repositoryItem) {
        String string = repositoryItem.getPath();
        return string.endsWith("-sonatype-clm-scan.xml.gz") || string.endsWith("-nexus-iq-scan.xml.gz");
    }

    private boolean isComponentItem(RepositoryItem repositoryItem) {
        String string = repositoryItem.getPath();
        if (string.endsWith(".pom") || string.endsWith(".asc") || string.endsWith(".sha1") || string.endsWith(".md5")) {
            return false;
        }
        return !string.endsWith("-sources.jar") && !string.endsWith("-javadoc.jar") && !string.endsWith("-tests.jar");
    }

    List<RepositoryItem> getComponentItems() {
        return this.componentItems;
    }

    List<RepositoryItem> getScanItems() {
        return this.scanItems;
    }
}

