/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.scan;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.insight.rm.scan.Bindings;
import com.sonatype.insight.rm.scan.RepositoryItem;
import com.sonatype.insight.rm.scan.ScanConfiguration;
import com.sonatype.insight.scan.client.ClientScanRequest;
import com.sonatype.insight.scan.config.ScanPropertiesLoader;
import com.sonatype.insight.scan.file.FileScanner;
import com.sonatype.insight.scan.file.b;
import com.sonatype.insight.scan.file.h;
import com.sonatype.insight.scan.file.m;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.util.HashUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.ai;
import zz.as;
import zz.l;
import zz.org.codehaus.plexus.util.IOUtil;
import zz.org.codehaus.plexus.util.ReaderFactory;
import zz.org.codehaus.plexus.util.StringUtils;
import zz.org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import zz.org.codehaus.plexus.util.xml.XmlStreamReader;
import zz.org.codehaus.plexus.util.xml.pull.MXParser;
import zz.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import zz.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ScanFactory {
    private static final Logger log = LoggerFactory.getLogger(ScanFactory.class);
    private static final String CONFIGURATION_RESOURCE = ScanFactory.class.getName().replace('.', '/').replace(ScanFactory.class.getSimpleName(), "configuration.properties");

    public File forConfiguration(ScanConfiguration scanConfiguration) throws IOException {
        if (scanConfiguration == null) {
            throw new IllegalArgumentException("scan configuration missing");
        }
        File file = File.createTempFile("sonatype-clm-scan-", ".xml.gz", scanConfiguration.getWorkDir());
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file), 32768)), "UTF-8");){
            this.scan(scanConfiguration, outputStreamWriter);
        }
        catch (IOException | RuntimeException exception) {
            try {
                new l().a(file);
            }
            catch (l.a a2) {
                log.error("Unable to delete scanFile: {}", (Object)file, (Object)a2);
            }
            throw exception;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(ScanConfiguration scanConfiguration, Writer writer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        Object object7;
        Scan scan = new Scan();
        scan.setConfiguration(this.getConfiguration(scanConfiguration));
        ScanSummary scanSummary = scan.getSummary();
        scanSummary.setStartTime();
        Bindings.clientScanner().scan(new ClientScanRequest(scan));
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<as> hashSet2 = new HashSet<as>();
        HashSet<as> hashSet3 = new HashSet<as>();
        List<RepositoryItem> list = scanConfiguration.getComponentItems();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            object7 = list.get(i2);
            hashSet.add(((RepositoryItem)object7).getCoordinates().getModuleId());
            object6 = ((RepositoryItem)object7).getSha1();
            if (object6 == null || ((String)object6).isEmpty()) {
                try (InputStream inputStream = ((RepositoryItem)object7).newInputStream();){
                    object6 = HashUtils.hash((InputStream)inputStream, (String)"SHA-1");
                }
                list.set(i2, new HashedRepositoryItem((RepositoryItem)object7, (String)object6));
            }
            hashSet2.add(this.normalizeSha1((String)object6));
        }
        ScanWriter scanWriter = Bindings.scanWriterFactory().newWriter(writer);
        object7 = new PrettyPrintXMLWriter(writer);
        scanWriter.openScan(scan);
        scanWriter.writeRepository(new Repository(null, scanConfiguration.getRepositoryId(), scanConfiguration.getRepositoryName(), scanConfiguration.getRepositoryFormat(), null));
        scanWriter.writeConfiguration(scan.getConfiguration());
        object6 = new b((com.sonatype.insight.scan.model.ScanConfiguration)scan.getConfiguration()).m;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (RepositoryItem object52 : scanConfiguration.getScanItems()) {
            if (!hashSet.contains(object52.getCoordinates().getModuleId())) continue;
            try {
                XmlStreamReader xmlPullParserException = ReaderFactory.newXmlReader(new GZIPInputStream(object52.newInputStream()));
                Throwable throwable = null;
                try {
                    object4 = new MXParser();
                    ((MXParser)object4).setInput(xmlPullParserException);
                    int n5 = ((MXParser)object4).getEventType();
                    while (n5 != 1) {
                        if (n5 == 2) {
                            object3 = ((MXParser)object4).getName();
                            if (((MXParser)object4).getDepth() == 1) {
                                if (!"scan".equals(object3)) {
                                    throw new XmlPullParserException("Unexpected root tag: " + (String)object3, (XmlPullParser)object4, null);
                                }
                                object2 = ((MXParser)object4).getAttributeValue(null, "version");
                                if (!scan.getVersion().equals(object2)) {
                                    log.warn("Unexpected file format in " + object52.getPath() + ", scan might be inaccurate" + ", please ensure the employed Nexus IQ client tools are compatible");
                                }
                            } else if (((MXParser)object4).getDepth() == 2 && "configuration".equals(object3)) {
                                ((MXParser)object4).skipSubTree();
                            } else if (((MXParser)object4).getDepth() == 2 && "summary".equals(object3)) {
                                ((MXParser)object4).skipSubTree();
                            } else if (((MXParser)object4).getDepth() == 3 && "dir".equals(object3) && !Boolean.parseBoolean(((MXParser)object4).getAttributeValue(null, "dependency")) && this.isNotPresentInRepo(((MXParser)object4).getAttributeValue(null, "sha1"), hashSet2)) {
                                ((MXParser)object4).skipSubTree();
                            } else {
                                ((PrettyPrintXMLWriter)object7).startElement((String)object3);
                                boolean bl2 = "item".equals(object3);
                                int n6 = ((MXParser)object4).getAttributeCount();
                                for (int i2 = 0; i2 < n6; ++i2) {
                                    object = ((MXParser)object4).getAttributeName(i2);
                                    String string = ((MXParser)object4).getAttributeValue(i2);
                                    if (bl2 && "path".equals(object) && string != null && object6.a(string) != ai.a.a) {
                                        ((PrettyPrintXMLWriter)object7).addAttribute("noPathReason", object6.a());
                                        continue;
                                    }
                                    ((PrettyPrintXMLWriter)object7).addAttribute((String)object, string);
                                }
                                if ("dir".equals(object3)) {
                                    ++n2;
                                    if (!Boolean.parseBoolean(((MXParser)object4).getAttributeValue(null, "dependency"))) {
                                        hashSet3.add(this.normalizeSha1(((MXParser)object4).getAttributeValue(null, "sha1")));
                                    }
                                } else if ("item".equals(object3)) {
                                    ++n3;
                                    String string = ((MXParser)object4).getAttributeValue(null, "path");
                                    if (string != null && string.endsWith(".class")) {
                                        ++n4;
                                    }
                                }
                            }
                        } else if (n5 == 3) {
                            if (((MXParser)object4).getDepth() > 1) {
                                ((PrettyPrintXMLWriter)object7).endElement();
                            }
                        } else if (n5 == 4) {
                            ((PrettyPrintXMLWriter)object7).writeText(((MXParser)object4).getText());
                        }
                        n5 = ((MXParser)object4).next();
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (xmlPullParserException == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)xmlPullParserException).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((Reader)xmlPullParserException).close();
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new IOException("Could not read scan file " + object52.getPath(), xmlPullParserException);
            }
        }
        scanSummary.setArchives(n2);
        scanSummary.setFiles(n3);
        scanSummary.setClassFiles(n4);
        FileScanner fileScanner = Bindings.fileScanner();
        m m2 = new m(scan, scanWriter);
        for (RepositoryItem repositoryItem : list) {
            if (hashSet3.contains(this.normalizeSha1(repositoryItem.getSha1()))) continue;
            object4 = repositoryItem.getFile();
            File file = null;
            try {
                if (object4 == null) {
                    object3 = new File(repositoryItem.getPath()).getName();
                    object3 = ((String)object3).substring(((String)object3).indexOf(46) + 1);
                    file = File.createTempFile("sonatype-clm-file-", "." + (String)object3, scanConfiguration.getWorkDir());
                    object4 = file;
                    object2 = repositoryItem.newInputStream();
                    Throwable throwable = null;
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream((File)object4);
                        object = null;
                        try {
                            IOUtil.copy((InputStream)object2, (OutputStream)fileOutputStream);
                        }
                        catch (Throwable throwable5) {
                            object = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (fileOutputStream != null) {
                                if (object != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        ((Throwable)object).addSuppressed(throwable6);
                                    }
                                } else {
                                    fileOutputStream.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (object2 != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)object2).close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                ((InputStream)object2).close();
                            }
                        }
                    }
                }
                object3 = new h(m2);
                ((h)object3).a((File)object4, this.trimLeadingSlash(repositoryItem.getPath()), repositoryItem.getCoordinates().getId());
                fileScanner.scan((h)object3);
                if (file == null) continue;
            }
            catch (Throwable throwable) {
                if (file != null) {
                    try {
                        new l().a(file);
                    }
                    catch (l.a a2) {
                        log.error("Unable to delete temporary file: {}", file, (Object)a2);
                    }
                }
                throw throwable;
            }
            try {
                new l().a(file);
            }
            catch (l.a a3) {
                log.error("Unable to delete temporary file: {}", (Object)file, (Object)a3);
            }
        }
        scanSummary.setEndTime();
        scanWriter.writeSummary(scanSummary);
        scanWriter.closeScan();
    }

    private boolean isNotPresentInRepo(String string, Set<as> set) {
        return string != null && !set.contains(this.normalizeSha1(string));
    }

    private as normalizeSha1(String string) {
        return string != null ? as.b(string) : null;
    }

    private String trimLeadingSlash(String string) {
        return string != null && string.startsWith("/") ? string.substring(1) : string;
    }

    private com.sonatype.insight.scan.model.ScanConfiguration getConfiguration(ScanConfiguration scanConfiguration) throws IOException {
        ProprietaryConfig proprietaryConfig;
        Properties properties = new Properties();
        if (scanConfiguration.getProprietaryConfig() != null) {
            proprietaryConfig = scanConfiguration.getProprietaryConfig();
            properties.put("proprietaryPackages", StringUtils.join(proprietaryConfig.getPackages().iterator(), ","));
            properties.put("proprietaryRegexes", StringUtils.join(proprietaryConfig.getRegexes().iterator(), ":::"));
        }
        properties.putAll((Map<?, ?>)scanConfiguration.getScanOptions());
        proprietaryConfig = new ScanPropertiesLoader(LoggerFactory.getLogger(ScanPropertiesLoader.class));
        proprietaryConfig.resolveAliases(properties);
        proprietaryConfig.loadDefaults(properties, CONFIGURATION_RESOURCE);
        return new com.sonatype.insight.scan.model.ScanConfiguration(properties);
    }

    private static class HashedRepositoryItem
    extends RepositoryItem {
        private final RepositoryItem delegate;
        private final String sha1;

        public HashedRepositoryItem(RepositoryItem repositoryItem, String string) {
            this.delegate = repositoryItem;
            this.sha1 = string;
        }

        @Override
        public String getSha1() {
            return this.sha1;
        }

        @Override
        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public String getPath() {
            return this.delegate.getPath();
        }

        @Override
        public RepositoryItem.Coords getCoordinates() {
            return this.delegate.getCoordinates();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.delegate.newInputStream();
        }
    }
}

