/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.file.FileScanner;
import com.sonatype.insight.scan.file.h;
import com.sonatype.insight.scan.file.i;
import com.sonatype.insight.scan.file.j;
import com.sonatype.insight.scan.file.l;
import com.sonatype.insight.scan.file.n;
import com.sonatype.insight.scan.file.o;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.Dependency;
import com.sonatype.insight.scan.model.ProjectScanItem;
import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanItemContainer;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.ScanWriter;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.ak;
import zz.an;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsScheme;

@Named
public class DefaultFileScanner
implements FileScanner {
    private final Logger log;
    private final Anonymizer anonymizer;
    private final an digester;
    private Exception simulateExceptionForTests = null;

    @Inject
    public DefaultFileScanner(an an2, Anonymizer anonymizer) {
        this(an2, anonymizer, LoggerFactory.getLogger(DefaultFileScanner.class));
    }

    public DefaultFileScanner(an an2, Anonymizer anonymizer, Logger logger) {
        this.digester = an2;
        this.anonymizer = anonymizer;
        this.log = logger;
    }

    @Override
    public void scan(h h2) {
        TArchiveDetector tArchiveDetector;
        j j2;
        ReverseLookupTable reverseLookupTable;
        Scan scan = h2.d().a();
        o o2 = new o();
        try {
            if (this.simulateExceptionForTests != null) {
                throw this.simulateExceptionForTests;
            }
            reverseLookupTable = h2.d().c();
            j2 = new j();
            tArchiveDetector = this.getArchiveDetector(scan.getConfiguration());
            this.log.debug("Using archive detector {}", (Object)tArchiveDetector);
            for (h.a a2 : h2.a()) {
                File file = a2.a;
                file = file.getAbsoluteFile();
                if (reverseLookupTable != null) {
                    reverseLookupTable.addFile(file);
                }
                i i2 = new i(h2.d(), h2.c(), a2.b != null ? a2.b : DefaultFileScanner.getPrefix(file, h2.b()), a2.c, false, o2, this.digester, this.anonymizer, this.log);
                j2.a(new TFile(file, tArchiveDetector), i2);
            }
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.log.error("Error details:", (Throwable)exception);
            o2.g.incrementAndGet();
        }
        this.updateSummary(scan.getSummary(), o2);
        reverseLookupTable = scan.getApplication();
        if (reverseLookupTable != null && (reverseLookupTable.getVersion() == null || reverseLookupTable.getVersion().isEmpty()) && scan.getItems().size() == 1 && (j2 = (ScanItem)scan.getItems().get(0)).getIds().size() == 1) {
            tArchiveDetector = (ArtifactId)j2.getIds().get(0);
            tArchiveDetector = new ArtifactId(tArchiveDetector.getKind(), this.anonymizer.restoreArtifactId(tArchiveDetector.getId(), h2.d().c()));
            reverseLookupTable.setVersion(tArchiveDetector.getVersion());
        }
    }

    @Override
    public void scan(l l2) {
        Scan scan = l2.i().a();
        o o2 = new o();
        try {
            Object object;
            Object object2;
            if (this.simulateExceptionForTests != null) {
                throw this.simulateExceptionForTests;
            }
            TArchiveDetector tArchiveDetector = this.getArchiveDetector(scan.getConfiguration());
            this.log.debug("Using archive detector {}", (Object)tArchiveDetector);
            ScanWriter scanWriter = l2.i().b();
            ProjectScanItem projectScanItem = new ProjectScanItem(l2.c(), l2.b());
            String string = n.a(l2.d(), l2.a());
            if (string == null && l2.d() != null) {
                string = l2.d().getName();
            }
            projectScanItem.setPath(string);
            for (Map.Entry<String, List<String>> entry : l2.g().entrySet()) {
                object2 = entry.getKey();
                boolean bl2 = l2.h().contains(object2);
                object = new Dependency();
                object.setId((String)object2);
                object.setDirect(bl2);
                List<String> list = entry.getValue();
                if (list != null && !list.isEmpty()) {
                    for (String string2 : list) {
                        Dependency dependency = new Dependency();
                        dependency.setId(string2);
                        object.addDependency(dependency);
                    }
                }
                projectScanItem.addDependency(object);
            }
            if (scanWriter == null) {
                scan.addItem((ScanItem)projectScanItem);
            } else {
                scanWriter.openProjectScanItem(projectScanItem, l2.d());
            }
            for (Map.Entry<Object, Object> entry : l2.e().entrySet()) {
                object2 = (File)entry.getKey();
                String string3 = (String)entry.getValue();
                object = new i(l2.i(), (ScanItemContainer)projectScanItem, ((File)object2).getName(), string3, true, o2, this.digester, this.anonymizer, this.log);
                new j().a(new TFile((File)object2, tArchiveDetector), (i)object);
            }
            for (Map.Entry<Object, Object> entry : l2.f().entrySet()) {
                object2 = (File)entry.getKey();
                String string4 = (String)entry.getValue();
                object = new i(l2.i(), (ScanItemContainer)projectScanItem, DefaultFileScanner.getPrefix((File)object2, l2.a()), string4, o2, this.digester, this.anonymizer, this.log);
                new j().a(new TFile((File)object2, tArchiveDetector), (i)object);
            }
            if (scanWriter != null) {
                scanWriter.closeProjectScanItem(l2.d());
            }
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.log.error("Error details:", (Throwable)exception);
            o2.g.incrementAndGet();
        }
        this.updateSummary(scan.getSummary(), o2);
    }

    private void updateSummary(ScanSummary scanSummary, o o2) {
        scanSummary.setArchives(scanSummary.getArchives() + o2.a.get());
        scanSummary.setDirectories(scanSummary.getDirectories() + o2.b.get());
        scanSummary.setFiles(scanSummary.getFiles() + o2.d.get());
        scanSummary.setClassFiles(scanSummary.getClassFiles() + o2.e.get());
        scanSummary.setInaccessibleFiles(scanSummary.getInaccessibleFiles() + o2.f.get());
        scanSummary.setErrorCount(scanSummary.getErrorCount() + o2.g.get());
    }

    private TArchiveDetector getArchiveDetector(ScanConfiguration scanConfiguration) {
        HashMap<ak.a, String> hashMap = new HashMap<ak.a, String>();
        for (ak.a a2 : ak.a.values()) {
            hashMap.put(a2, scanConfiguration.getString(null, new String[]{a2.name().toLowerCase(Locale.ENGLISH)}));
        }
        TreeSet treeSet = new TreeSet();
        TArchiveDetector tArchiveDetector = ak.a(hashMap, (Collection<String>)treeSet);
        if (!treeSet.isEmpty()) {
            this.log.warn("Ignored invalid file extensions {}", (Object)treeSet);
        }
        return tArchiveDetector;
    }

    static String getPrefix(File file, File file2) {
        String string;
        if (file == null) {
            return null;
        }
        String string2 = string = file2 != null ? n.a(file, file2) : null;
        if (string == null) {
            string = file.getName();
        }
        return string;
    }

    @Override
    public Set<String> getSupportedArchiveTypes(ScanConfiguration scanConfiguration) {
        TArchiveDetector tArchiveDetector = this.getArchiveDetector(scanConfiguration);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<FsScheme, FsDriver> entry : tArchiveDetector.get().entrySet()) {
            treeSet.add(entry.getKey().toString());
        }
        treeSet.remove("file");
        treeSet.remove("exe");
        return treeSet;
    }

    public void setSimulateExceptionForTests(Exception exception) {
        this.simulateExceptionForTests = exception;
    }
}

