/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.annotation;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import zz.com.fasterxml.jackson.annotation.JacksonAnnotation;
import zz.com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import zz.com.fasterxml.jackson.annotation.OptBoolean;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JacksonInject {
    public String value() default "";

    public OptBoolean useInput() default OptBoolean.DEFAULT;

    public static class Value
    implements Serializable,
    JacksonAnnotationValue<JacksonInject> {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY = new Value(null, null);
        protected final Object _id;
        protected final Boolean _useInput;

        protected Value(Object object, Boolean bl2) {
            this._id = object;
            this._useInput = bl2;
        }

        @Override
        public Class<JacksonInject> valueFor() {
            return JacksonInject.class;
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value construct(Object object, Boolean bl2) {
            if ("".equals(object)) {
                object = null;
            }
            if (Value._empty(object, bl2)) {
                return EMPTY;
            }
            return new Value(object, bl2);
        }

        public static Value from(JacksonInject jacksonInject) {
            if (jacksonInject == null) {
                return EMPTY;
            }
            return Value.construct(jacksonInject.value(), jacksonInject.useInput().asBoolean());
        }

        public static Value forId(Object object) {
            return Value.construct(object, null);
        }

        public Value withId(Object object) {
            if (object == null ? this._id == null : object.equals(this._id)) {
                return this;
            }
            return new Value(object, this._useInput);
        }

        public Value withUseInput(Boolean bl2) {
            if (bl2 == null ? this._useInput == null : bl2.equals(this._useInput)) {
                return this;
            }
            return new Value(this._id, bl2);
        }

        public Object getId() {
            return this._id;
        }

        public Boolean getUseInput() {
            return this._useInput;
        }

        public boolean hasId() {
            return this._id != null;
        }

        public boolean willUseInput(boolean bl2) {
            return this._useInput == null ? bl2 : this._useInput;
        }

        public String toString() {
            return String.format("JacksonInject.Value(id=%s,useInput=%s)", this._id, this._useInput);
        }

        public int hashCode() {
            int n2 = 1;
            if (this._id != null) {
                n2 += this._id.hashCode();
            }
            if (this._useInput != null) {
                n2 += this._useInput.hashCode();
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                Value value = (Value)object;
                if (OptBoolean.equals(this._useInput, value._useInput)) {
                    if (this._id == null) {
                        return value._id == null;
                    }
                    return this._id.equals(value._id);
                }
            }
            return false;
        }

        private static boolean _empty(Object object, Boolean bl2) {
            return object == null && bl2 == null;
        }
    }
}

