/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.annotation;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import zz.com.fasterxml.jackson.annotation.JacksonAnnotation;
import zz.com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import zz.com.fasterxml.jackson.annotation.Nulls;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonSetter {
    public String value() default "";

    public Nulls nulls() default Nulls.DEFAULT;

    public Nulls contentNulls() default Nulls.DEFAULT;

    public static class Value
    implements Serializable,
    JacksonAnnotationValue<JsonSetter> {
        private static final long serialVersionUID = 1L;
        private final Nulls _nulls;
        private final Nulls _contentNulls;
        protected static final Value EMPTY = new Value(Nulls.DEFAULT, Nulls.DEFAULT);

        protected Value(Nulls nulls, Nulls nulls2) {
            this._nulls = nulls;
            this._contentNulls = nulls2;
        }

        @Override
        public Class<JsonSetter> valueFor() {
            return JsonSetter.class;
        }

        protected Object readResolve() {
            if (Value._empty(this._nulls, this._contentNulls)) {
                return EMPTY;
            }
            return this;
        }

        public static Value from(JsonSetter jsonSetter) {
            if (jsonSetter == null) {
                return EMPTY;
            }
            return Value.construct(jsonSetter.nulls(), jsonSetter.contentNulls());
        }

        public static Value construct(Nulls nulls, Nulls nulls2) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls2 == null) {
                nulls2 = Nulls.DEFAULT;
            }
            if (Value._empty(nulls, nulls2)) {
                return EMPTY;
            }
            return new Value(nulls, nulls2);
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            return value == null ? value2 : value.withOverrides(value2);
        }

        public static Value forValueNulls(Nulls nulls) {
            return Value.construct(nulls, Nulls.DEFAULT);
        }

        public static Value forValueNulls(Nulls nulls, Nulls nulls2) {
            return Value.construct(nulls, nulls2);
        }

        public static Value forContentNulls(Nulls nulls) {
            return Value.construct(Nulls.DEFAULT, nulls);
        }

        public Value withOverrides(Value value) {
            if (value == null || value == EMPTY) {
                return this;
            }
            Nulls nulls = value._nulls;
            Nulls nulls2 = value._contentNulls;
            if (nulls == Nulls.DEFAULT) {
                nulls = this._nulls;
            }
            if (nulls2 == Nulls.DEFAULT) {
                nulls2 = this._contentNulls;
            }
            if (nulls == this._nulls && nulls2 == this._contentNulls) {
                return this;
            }
            return Value.construct(nulls, nulls2);
        }

        public Value withValueNulls(Nulls nulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls == this._nulls) {
                return this;
            }
            return Value.construct(nulls, this._contentNulls);
        }

        public Value withValueNulls(Nulls nulls, Nulls nulls2) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls2 == null) {
                nulls2 = Nulls.DEFAULT;
            }
            if (nulls == this._nulls && nulls2 == this._contentNulls) {
                return this;
            }
            return Value.construct(nulls, nulls2);
        }

        public Value withContentNulls(Nulls nulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls == this._contentNulls) {
                return this;
            }
            return Value.construct(this._nulls, nulls);
        }

        public Nulls getValueNulls() {
            return this._nulls;
        }

        public Nulls getContentNulls() {
            return this._contentNulls;
        }

        public Nulls nonDefaultValueNulls() {
            return this._nulls == Nulls.DEFAULT ? null : this._nulls;
        }

        public Nulls nonDefaultContentNulls() {
            return this._contentNulls == Nulls.DEFAULT ? null : this._contentNulls;
        }

        public String toString() {
            return String.format("JsonSetter.Value(valueNulls=%s,contentNulls=%s)", new Object[]{this._nulls, this._contentNulls});
        }

        public int hashCode() {
            return this._nulls.ordinal() + (this._contentNulls.ordinal() << 2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                Value value = (Value)object;
                return value._nulls == this._nulls && value._contentNulls == this._contentNulls;
            }
            return false;
        }

        private static boolean _empty(Nulls nulls, Nulls nulls2) {
            return nulls == Nulls.DEFAULT && nulls2 == Nulls.DEFAULT;
        }
    }
}

