/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core;

import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import zz.com.fasterxml.jackson.core.FormatFeature;
import zz.com.fasterxml.jackson.core.FormatSchema;
import zz.com.fasterxml.jackson.core.JsonEncoding;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonParseException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.ObjectCodec;
import zz.com.fasterxml.jackson.core.SerializableString;
import zz.com.fasterxml.jackson.core.Version;
import zz.com.fasterxml.jackson.core.Versioned;
import zz.com.fasterxml.jackson.core.format.InputAccessor;
import zz.com.fasterxml.jackson.core.format.MatchStrength;
import zz.com.fasterxml.jackson.core.io.CharacterEscapes;
import zz.com.fasterxml.jackson.core.io.DataOutputAsStream;
import zz.com.fasterxml.jackson.core.io.IOContext;
import zz.com.fasterxml.jackson.core.io.InputDecorator;
import zz.com.fasterxml.jackson.core.io.OutputDecorator;
import zz.com.fasterxml.jackson.core.io.SerializedString;
import zz.com.fasterxml.jackson.core.io.UTF8Writer;
import zz.com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import zz.com.fasterxml.jackson.core.json.PackageVersion;
import zz.com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import zz.com.fasterxml.jackson.core.json.UTF8DataInputJsonParser;
import zz.com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import zz.com.fasterxml.jackson.core.json.WriterBasedJsonGenerator;
import zz.com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import zz.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import zz.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import zz.com.fasterxml.jackson.core.util.BufferRecycler;
import zz.com.fasterxml.jackson.core.util.BufferRecyclers;
import zz.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;

public class JsonFactory
implements Serializable,
Versioned {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_JSON = "JSON";
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    private static final SerializableString DEFAULT_ROOT_VALUE_SEPARATOR = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    protected final transient CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    protected int _factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected CharacterEscapes _characterEscapes;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected SerializableString _rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    protected JsonFactory(JsonFactory jsonFactory, ObjectCodec objectCodec) {
        this._objectCodec = null;
        this._factoryFeatures = jsonFactory._factoryFeatures;
        this._parserFeatures = jsonFactory._parserFeatures;
        this._generatorFeatures = jsonFactory._generatorFeatures;
        this._characterEscapes = jsonFactory._characterEscapes;
        this._inputDecorator = jsonFactory._inputDecorator;
        this._outputDecorator = jsonFactory._outputDecorator;
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
    }

    public JsonFactory copy() {
        this._checkInvalidCopy(JsonFactory.class);
        return new JsonFactory(this, null);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    protected Object readResolve() {
        return new JsonFactory(this, this._objectCodec);
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseCharArrays() {
        return true;
    }

    public boolean canParseAsync() {
        return this._isJSONFactory();
    }

    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return null;
    }

    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        if (formatSchema == null) {
            return false;
        }
        String string = this.getFormatName();
        return string != null && string.equals(formatSchema.getSchemaType());
    }

    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(inputAccessor);
        }
        return null;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    protected MatchStrength hasJSONFormat(InputAccessor inputAccessor) throws IOException {
        return ByteSourceJsonBootstrapper.hasJSONFormat(inputAccessor);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public final JsonFactory configure(Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public JsonFactory enable(Feature feature) {
        this._factoryFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(Feature feature) {
        this._factoryFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._factoryFeatures & feature.getMask()) != 0;
    }

    public final JsonFactory configure(JsonParser.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public JsonFactory enable(JsonParser.Feature feature) {
        this._parserFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser.Feature feature) {
        this._parserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    public JsonFactory setInputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this;
    }

    public final JsonFactory configure(JsonGenerator.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public JsonFactory enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    public JsonFactory setOutputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this;
    }

    public JsonFactory setRootValueSeparator(String string) {
        this._rootValueSeparator = string == null ? null : new SerializedString(string);
        return this;
    }

    public String getRootValueSeparator() {
        return this._rootValueSeparator == null ? null : this._rootValueSeparator.getValue();
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createParser(File file) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(file, true);
        FileInputStream fileInputStream = new FileInputStream(file);
        return this._createParser(this._decorate(fileInputStream, iOContext), iOContext);
    }

    public JsonParser createParser(URL uRL) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(uRL, true);
        InputStream inputStream = this._optimizedStreamFromURL(uRL);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    public JsonParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(inputStream, false);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    public JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(reader, false);
        return this._createParser(this._decorate(reader, iOContext), iOContext);
    }

    public JsonParser createParser(byte[] byArray) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    public JsonParser createParser(byte[] byArray, int n2, int n3) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    public JsonParser createParser(String string) throws IOException, JsonParseException {
        int n2 = string.length();
        if (this._inputDecorator != null || n2 > 32768 || !this.canUseCharArrays()) {
            return this.createParser(new StringReader(string));
        }
        IOContext iOContext = this._createContext(string, true);
        char[] cArray = iOContext.allocTokenBuffer(n2);
        string.getChars(0, n2, cArray, 0);
        return this._createParser(cArray, 0, n2, iOContext, true);
    }

    public JsonParser createParser(char[] cArray) throws IOException {
        return this.createParser(cArray, 0, cArray.length);
    }

    public JsonParser createParser(char[] cArray, int n2, int n3) throws IOException {
        if (this._inputDecorator != null) {
            return this.createParser(new CharArrayReader(cArray, n2, n3));
        }
        return this._createParser(cArray, n2, n3, this._createContext(cArray, true), false);
    }

    public JsonParser createParser(DataInput dataInput) throws IOException {
        IOContext iOContext = this._createContext(dataInput, false);
        return this._createParser(this._decorate(dataInput, iOContext), iOContext);
    }

    public JsonParser createNonBlockingByteArrayParser() throws IOException {
        this._requireJSONFactory("Non-blocking source not (yet?) support for this format (%s)");
        IOContext iOContext = this._createContext(null, false);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._byteSymbolCanonicalizer.makeChild(this._factoryFeatures);
        return new NonBlockingJsonParser(iOContext, this._parserFeatures, byteQuadsCanonicalizer);
    }

    @Deprecated
    public JsonParser createJsonParser(File file) throws IOException, JsonParseException {
        return this.createParser(file);
    }

    @Deprecated
    public JsonParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this.createParser(uRL);
    }

    @Deprecated
    public JsonParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this.createParser(inputStream);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        return this.createParser(reader);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        return this.createParser(byArray);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray, int n2, int n3) throws IOException, JsonParseException {
        return this.createParser(byArray, n2, n3);
    }

    @Deprecated
    public JsonParser createJsonParser(String string) throws IOException, JsonParseException {
        return this.createParser(string);
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return this._createUTF8Generator(this._decorate(outputStream, iOContext), iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(fileOutputStream, true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return this._createUTF8Generator(this._decorate(fileOutputStream, iOContext), iOContext);
        }
        Writer writer = this._createWriter(fileOutputStream, jsonEncoding, iOContext);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(DataOutput dataOutput, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(this._createDataOutputWrapper(dataOutput), jsonEncoding);
    }

    public JsonGenerator createGenerator(DataOutput dataOutput) throws IOException {
        return this.createGenerator(this._createDataOutputWrapper(dataOutput), JsonEncoding.UTF8);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(Writer writer) throws IOException {
        return this.createGenerator(writer);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    protected JsonParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        return new ByteSourceJsonBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    protected JsonParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild(this._factoryFeatures));
    }

    protected JsonParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) throws IOException {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, null, this._objectCodec, this._rootCharSymbols.makeChild(this._factoryFeatures), cArray, n2, n2 + n3, bl2);
    }

    protected JsonParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) throws IOException {
        return new ByteSourceJsonBootstrapper(iOContext, byArray, n2, n3).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    protected JsonParser _createParser(DataInput dataInput, IOContext iOContext) throws IOException {
        this._requireJSONFactory("InputData source not (yet?) support for this format (%s)");
        int n2 = ByteSourceJsonBootstrapper.skipUTF8BOM(dataInput);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._byteSymbolCanonicalizer.makeChild(this._factoryFeatures);
        return new UTF8DataInputJsonParser(iOContext, this._parserFeatures, dataInput, this._objectCodec, byteQuadsCanonicalizer, n2);
    }

    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        SerializableString serializableString;
        WriterBasedJsonGenerator writerBasedJsonGenerator = new WriterBasedJsonGenerator(iOContext, this._generatorFeatures, this._objectCodec, writer);
        if (this._characterEscapes != null) {
            writerBasedJsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        if ((serializableString = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            writerBasedJsonGenerator.setRootValueSeparator(serializableString);
        }
        return writerBasedJsonGenerator;
    }

    protected JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        SerializableString serializableString;
        UTF8JsonGenerator uTF8JsonGenerator = new UTF8JsonGenerator(iOContext, this._generatorFeatures, this._objectCodec, outputStream);
        if (this._characterEscapes != null) {
            uTF8JsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        if ((serializableString = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            uTF8JsonGenerator.setRootValueSeparator(serializableString);
        }
        return uTF8JsonGenerator;
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected final InputStream _decorate(InputStream inputStream, IOContext iOContext) throws IOException {
        InputStream inputStream2;
        if (this._inputDecorator != null && (inputStream2 = this._inputDecorator.decorate(iOContext, inputStream)) != null) {
            return inputStream2;
        }
        return inputStream;
    }

    protected final Reader _decorate(Reader reader, IOContext iOContext) throws IOException {
        Reader reader2;
        if (this._inputDecorator != null && (reader2 = this._inputDecorator.decorate(iOContext, reader)) != null) {
            return reader2;
        }
        return reader;
    }

    protected final DataInput _decorate(DataInput dataInput, IOContext iOContext) throws IOException {
        DataInput dataInput2;
        if (this._inputDecorator != null && (dataInput2 = this._inputDecorator.decorate(iOContext, dataInput)) != null) {
            return dataInput2;
        }
        return dataInput;
    }

    protected final OutputStream _decorate(OutputStream outputStream, IOContext iOContext) throws IOException {
        OutputStream outputStream2;
        if (this._outputDecorator != null && (outputStream2 = this._outputDecorator.decorate(iOContext, outputStream)) != null) {
            return outputStream2;
        }
        return outputStream;
    }

    protected final Writer _decorate(Writer writer, IOContext iOContext) throws IOException {
        Writer writer2;
        if (this._outputDecorator != null && (writer2 = this._outputDecorator.decorate(iOContext, writer)) != null) {
            return writer2;
        }
        return writer;
    }

    public BufferRecycler _getBufferRecycler() {
        if (Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING.enabledIn(this._factoryFeatures)) {
            return BufferRecyclers.getBufferRecycler();
        }
        return new BufferRecycler();
    }

    protected IOContext _createContext(Object object, boolean bl2) {
        return new IOContext(this._getBufferRecycler(), object, bl2);
    }

    protected OutputStream _createDataOutputWrapper(DataOutput dataOutput) {
        return new DataOutputAsStream(dataOutput);
    }

    protected InputStream _optimizedStreamFromURL(URL uRL) throws IOException {
        String string;
        String string2;
        if ("file".equals(uRL.getProtocol()) && ((string2 = uRL.getHost()) == null || string2.length() == 0) && (string = uRL.getPath()).indexOf(37) < 0) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }

    private final void _requireJSONFactory(String string) {
        if (!this._isJSONFactory()) {
            throw new UnsupportedOperationException(String.format(string, this.getFormatName()));
        }
    }

    private final boolean _isJSONFactory() {
        return this.getFormatName() == FORMAT_NAME_JSON;
    }

    public static enum Feature {
        INTERN_FIELD_NAMES(true),
        CANONICALIZE_FIELD_NAMES(true),
        FAIL_ON_SYMBOL_HASH_OVERFLOW(true),
        USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING(true);

        private final boolean _defaultState;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

