/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.core.Base64Variants;
import zz.com.fasterxml.jackson.core.FormatSchema;
import zz.com.fasterxml.jackson.core.JsonGenerationException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonStreamContext;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.ObjectCodec;
import zz.com.fasterxml.jackson.core.PrettyPrinter;
import zz.com.fasterxml.jackson.core.SerializableString;
import zz.com.fasterxml.jackson.core.TreeNode;
import zz.com.fasterxml.jackson.core.Version;
import zz.com.fasterxml.jackson.core.Versioned;
import zz.com.fasterxml.jackson.core.io.CharacterEscapes;
import zz.com.fasterxml.jackson.core.type.WritableTypeId;
import zz.com.fasterxml.jackson.core.util.VersionUtil;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Override
    public abstract Version version();

    public abstract JsonGenerator enable(Feature var1);

    public abstract JsonGenerator disable(Feature var1);

    public final JsonGenerator configure(Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public abstract boolean isEnabled(Feature var1);

    public abstract int getFeatureMask();

    @Deprecated
    public abstract JsonGenerator setFeatureMask(int var1);

    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        int n4 = this.getFeatureMask();
        int n5 = n4 & ~n3 | n2 & n3;
        return this.setFeatureMask(n5);
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        throw new IllegalArgumentException("No FormatFeatures defined for generator of type " + this.getClass().getName());
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n2) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public Object getOutputTarget() {
        return null;
    }

    public int getOutputBuffered() {
        return -1;
    }

    public Object getCurrentValue() {
        JsonStreamContext jsonStreamContext = this.getOutputContext();
        return jsonStreamContext == null ? null : jsonStreamContext.getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        JsonStreamContext jsonStreamContext = this.getOutputContext();
        if (jsonStreamContext != null) {
            jsonStreamContext.setCurrentValue(object);
        }
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteBinaryNatively() {
        return false;
    }

    public boolean canOmitFields() {
        return true;
    }

    public boolean canWriteFormattedNumbers() {
        return false;
    }

    public abstract void writeStartArray() throws IOException;

    public void writeStartArray(int n2) throws IOException {
        this.writeStartArray();
    }

    public abstract void writeEndArray() throws IOException;

    public abstract void writeStartObject() throws IOException;

    public void writeStartObject(Object object) throws IOException {
        this.writeStartObject();
        this.setCurrentValue(object);
    }

    public abstract void writeEndObject() throws IOException;

    public abstract void writeFieldName(String var1) throws IOException;

    public abstract void writeFieldName(SerializableString var1) throws IOException;

    public void writeFieldId(long l2) throws IOException {
        this.writeFieldName(Long.toString(l2));
    }

    public void writeArray(int[] nArray, int n2, int n3) throws IOException {
        if (nArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(nArray.length, n2, n3);
        this.writeStartArray();
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.writeNumber(nArray[i2]);
        }
        this.writeEndArray();
    }

    public void writeArray(long[] lArray, int n2, int n3) throws IOException {
        if (lArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(lArray.length, n2, n3);
        this.writeStartArray();
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.writeNumber(lArray[i2]);
        }
        this.writeEndArray();
    }

    public void writeArray(double[] dArray, int n2, int n3) throws IOException {
        if (dArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(dArray.length, n2, n3);
        this.writeStartArray();
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.writeNumber(dArray[i2]);
        }
        this.writeEndArray();
    }

    public abstract void writeString(String var1) throws IOException;

    public void writeString(Reader reader, int n2) throws IOException {
        this._reportUnsupportedOperation();
    }

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeString(SerializableString var1) throws IOException;

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3) throws IOException;

    public abstract void writeUTF8String(byte[] var1, int var2, int var3) throws IOException;

    public abstract void writeRaw(String var1) throws IOException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeRaw(char var1) throws IOException;

    public void writeRaw(SerializableString serializableString) throws IOException {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1) throws IOException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException;

    public void writeRawValue(SerializableString serializableString) throws IOException {
        this.writeRawValue(serializableString.getValue());
    }

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException;

    public void writeBinary(byte[] byArray, int n2, int n3) throws IOException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n2, n3);
    }

    public void writeBinary(byte[] byArray) throws IOException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public int writeBinary(InputStream inputStream, int n2) throws IOException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n2);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3) throws IOException;

    public void writeNumber(short s2) throws IOException {
        this.writeNumber((int)s2);
    }

    public abstract void writeNumber(int var1) throws IOException;

    public abstract void writeNumber(long var1) throws IOException;

    public abstract void writeNumber(BigInteger var1) throws IOException;

    public abstract void writeNumber(double var1) throws IOException;

    public abstract void writeNumber(float var1) throws IOException;

    public abstract void writeNumber(BigDecimal var1) throws IOException;

    public abstract void writeNumber(String var1) throws IOException;

    public abstract void writeBoolean(boolean var1) throws IOException;

    public abstract void writeNull() throws IOException;

    public void writeEmbeddedObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof byte[]) {
            this.writeBinary((byte[])object);
            return;
        }
        throw new JsonGenerationException("No native support for writing embedded objects of type " + object.getClass().getName(), this);
    }

    public void writeObjectId(Object object) throws IOException {
        throw new JsonGenerationException("No native support for writing Object Ids", this);
    }

    public void writeObjectRef(Object object) throws IOException {
        throw new JsonGenerationException("No native support for writing Object Ids", this);
    }

    public void writeTypeId(Object object) throws IOException {
        throw new JsonGenerationException("No native support for writing Type Ids", this);
    }

    public WritableTypeId writeTypePrefix(WritableTypeId writableTypeId) throws IOException {
        Object object = writableTypeId.id;
        JsonToken jsonToken = writableTypeId.valueShape;
        if (this.canWriteTypeId()) {
            writableTypeId.wrapperWritten = false;
            this.writeTypeId(object);
        } else {
            String string = object instanceof String ? (String)object : String.valueOf(object);
            writableTypeId.wrapperWritten = true;
            WritableTypeId.Inclusion inclusion = writableTypeId.include;
            if (jsonToken != JsonToken.START_OBJECT && inclusion.requiresObjectContext()) {
                writableTypeId.include = inclusion = WritableTypeId.Inclusion.WRAPPER_ARRAY;
            }
            switch (inclusion) {
                case PARENT_PROPERTY: {
                    break;
                }
                case PAYLOAD_PROPERTY: {
                    break;
                }
                case METADATA_PROPERTY: {
                    this.writeStartObject(writableTypeId.forValue);
                    this.writeStringField(writableTypeId.asProperty, string);
                    return writableTypeId;
                }
                case WRAPPER_OBJECT: {
                    this.writeStartObject();
                    this.writeFieldName(string);
                    break;
                }
                default: {
                    this.writeStartArray();
                    this.writeString(string);
                }
            }
        }
        if (jsonToken == JsonToken.START_OBJECT) {
            this.writeStartObject(writableTypeId.forValue);
        } else if (jsonToken == JsonToken.START_ARRAY) {
            this.writeStartArray();
        }
        return writableTypeId;
    }

    public WritableTypeId writeTypeSuffix(WritableTypeId writableTypeId) throws IOException {
        JsonToken jsonToken = writableTypeId.valueShape;
        if (jsonToken == JsonToken.START_OBJECT) {
            this.writeEndObject();
        } else if (jsonToken == JsonToken.START_ARRAY) {
            this.writeEndArray();
        }
        if (writableTypeId.wrapperWritten) {
            switch (writableTypeId.include) {
                case WRAPPER_ARRAY: {
                    this.writeEndArray();
                    break;
                }
                case PARENT_PROPERTY: {
                    Object object = writableTypeId.id;
                    String string = object instanceof String ? (String)object : String.valueOf(object);
                    this.writeStringField(writableTypeId.asProperty, string);
                    break;
                }
                case PAYLOAD_PROPERTY: 
                case METADATA_PROPERTY: {
                    break;
                }
                default: {
                    this.writeEndObject();
                }
            }
        }
        return writableTypeId;
    }

    public abstract void writeObject(Object var1) throws IOException;

    public abstract void writeTree(TreeNode var1) throws IOException;

    public void writeStringField(String string, String string2) throws IOException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeBooleanField(String string, boolean bl2) throws IOException {
        this.writeFieldName(string);
        this.writeBoolean(bl2);
    }

    public final void writeNullField(String string) throws IOException {
        this.writeFieldName(string);
        this.writeNull();
    }

    public final void writeNumberField(String string, int n2) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(n2);
    }

    public final void writeNumberField(String string, long l2) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(l2);
    }

    public final void writeNumberField(String string, double d2) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(d2);
    }

    public final void writeNumberField(String string, float f2) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(f2);
    }

    public final void writeNumberField(String string, BigDecimal bigDecimal) throws IOException {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public final void writeBinaryField(String string, byte[] byArray) throws IOException {
        this.writeFieldName(string);
        this.writeBinary(byArray);
    }

    public final void writeArrayFieldStart(String string) throws IOException {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String string) throws IOException {
        this.writeFieldName(string);
        this.writeStartObject();
    }

    public final void writeObjectField(String string, Object object) throws IOException {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public void writeOmittedField(String string) throws IOException {
    }

    public void copyCurrentEvent(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        switch (jsonToken.id()) {
            case -1: {
                this._reportError("No current event to copy");
                break;
            }
            case 1: {
                this.writeStartObject();
                break;
            }
            case 2: {
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                break;
            }
            case 4: {
                this.writeEndArray();
                break;
            }
            case 5: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case 7: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.INT) {
                    this.writeNumber(jsonParser.getIntValue());
                    break;
                }
                if (numberType == JsonParser.NumberType.BIG_INTEGER) {
                    this.writeNumber(jsonParser.getBigIntegerValue());
                    break;
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case 8: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
                    this.writeNumber(jsonParser.getDecimalValue());
                    break;
                }
                if (numberType == JsonParser.NumberType.FLOAT) {
                    this.writeNumber(jsonParser.getFloatValue());
                    break;
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case 9: {
                this.writeBoolean(true);
                break;
            }
            case 10: {
                this.writeBoolean(false);
                break;
            }
            case 11: {
                this.writeNull();
                break;
            }
            case 12: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    public void copyCurrentStructure(JsonParser jsonParser) throws IOException {
        int n2;
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        if ((n2 = jsonToken.id()) == 5) {
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
            n2 = jsonToken.id();
        }
        switch (n2) {
            case 1: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    public abstract JsonStreamContext getOutputContext();

    @Override
    public abstract void flush() throws IOException;

    public abstract boolean isClosed();

    @Override
    public abstract void close() throws IOException;

    protected void _reportError(String string) throws JsonGenerationException {
        throw new JsonGenerationException(string, this);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type " + this.getClass().getName());
    }

    protected final void _verifyOffsets(int n2, int n3, int n4) {
        if (n3 < 0 || n3 + n4 > n2) {
            throw new IllegalArgumentException(String.format("invalid argument(s) (offset=%d, length=%d) for input array of %d element", n3, n4, n2));
        }
    }

    protected void _writeSimpleObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                this.writeNumber(number.intValue());
                return;
            }
            if (number instanceof Long) {
                this.writeNumber(number.longValue());
                return;
            }
            if (number instanceof Double) {
                this.writeNumber(number.doubleValue());
                return;
            }
            if (number instanceof Float) {
                this.writeNumber(number.floatValue());
                return;
            }
            if (number instanceof Short) {
                this.writeNumber(number.shortValue());
                return;
            }
            if (number instanceof Byte) {
                this.writeNumber(number.byteValue());
                return;
            }
            if (number instanceof BigInteger) {
                this.writeNumber((BigInteger)number);
                return;
            }
            if (number instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number);
                return;
            }
            if (number instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number).get());
                return;
            }
            if (number instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }

    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        FLUSH_PASSED_TO_STREAM(true),
        QUOTE_FIELD_NAMES(true),
        QUOTE_NON_NUMERIC_NUMBERS(true),
        WRITE_NUMBERS_AS_STRINGS(false),
        WRITE_BIGDECIMAL_AS_PLAIN(false),
        ESCAPE_NON_ASCII(false),
        STRICT_DUPLICATE_DETECTION(false),
        IGNORE_UNKNOWN(false);

        private final boolean _defaultState;
        private final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n2) {
            return (n2 & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

