/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core;

import zz.com.fasterxml.jackson.core.JsonStreamContext;
import zz.com.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer {
    public static final char SEPARATOR = '/';
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String string, String string2, JsonPointer jsonPointer) {
        this._asString = string;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = JsonPointer._parseIndex(string2);
    }

    protected JsonPointer(String string, String string2, int n2, JsonPointer jsonPointer) {
        this._asString = string;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = n2;
    }

    public static JsonPointer compile(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string + "\"");
        }
        return JsonPointer._parseTail(string);
    }

    public static JsonPointer valueOf(String string) {
        return JsonPointer.compile(string);
    }

    public static JsonPointer forPath(JsonStreamContext jsonStreamContext, boolean bl2) {
        if (jsonStreamContext == null) {
            return EMPTY;
        }
        if (!(jsonStreamContext.hasPathSegment() || bl2 && jsonStreamContext.inRoot() && jsonStreamContext.hasCurrentIndex())) {
            jsonStreamContext = jsonStreamContext.getParent();
        }
        JsonPointer jsonPointer = null;
        while (jsonStreamContext != null) {
            if (jsonStreamContext.inObject()) {
                String string = jsonStreamContext.getCurrentName();
                if (string == null) {
                    string = "";
                }
                jsonPointer = new JsonPointer(JsonPointer._fullPath(jsonPointer, string), string, jsonPointer);
            } else if (jsonStreamContext.inArray() || bl2) {
                int n2 = jsonStreamContext.getCurrentIndex();
                String string = String.valueOf(n2);
                jsonPointer = new JsonPointer(JsonPointer._fullPath(jsonPointer, string), string, n2, jsonPointer);
            }
            jsonStreamContext = jsonStreamContext.getParent();
        }
        if (jsonPointer == null) {
            return EMPTY;
        }
        return jsonPointer;
    }

    private static String _fullPath(JsonPointer jsonPointer, String string) {
        if (jsonPointer == null) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
            stringBuilder.append('/');
            JsonPointer._appendEscaped(stringBuilder, string);
            return stringBuilder.toString();
        }
        String string2 = jsonPointer._asString;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 1 + string2.length());
        stringBuilder.append('/');
        JsonPointer._appendEscaped(stringBuilder, string);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static void _appendEscaped(StringBuilder stringBuilder, String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/') {
                stringBuilder.append("~1");
                continue;
            }
            if (c2 == '~') {
                stringBuilder.append("~0");
                continue;
            }
            stringBuilder.append(c2);
        }
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer jsonPointer;
        JsonPointer jsonPointer2 = this;
        if (jsonPointer2 == EMPTY) {
            return null;
        }
        while ((jsonPointer = jsonPointer2._nextSegment) != EMPTY) {
            jsonPointer2 = jsonPointer;
        }
        return jsonPointer2;
    }

    public JsonPointer append(JsonPointer jsonPointer) {
        if (this == EMPTY) {
            return jsonPointer;
        }
        if (jsonPointer == EMPTY) {
            return this;
        }
        String string = this._asString;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return JsonPointer.compile(string + jsonPointer._asString);
    }

    public boolean matchesProperty(String string) {
        return this._nextSegment != null && this._matchingPropertyName.equals(string);
    }

    public JsonPointer matchProperty(String string) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(string)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int n2) {
        return n2 == this._matchingElementIndex && n2 >= 0;
    }

    public JsonPointer matchElement(int n2) {
        if (n2 != this._matchingElementIndex || n2 < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer jsonPointer = this._head;
        if (jsonPointer == null) {
            if (this != EMPTY) {
                jsonPointer = this._constructHead();
            }
            this._head = jsonPointer;
        }
        return jsonPointer;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)object)._asString);
    }

    private static final int _parseIndex(String string) {
        long l2;
        int n2 = string.length();
        if (n2 == 0 || n2 > 10) {
            return -1;
        }
        char c2 = string.charAt(0);
        if (c2 <= '0') {
            return n2 == 1 && c2 == '0' ? 0 : -1;
        }
        if (c2 > '9') {
            return -1;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (c2 <= '9' && c2 >= '0') continue;
            return -1;
        }
        if (n2 == 10 && (l2 = NumberInput.parseLong(string)) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(string);
    }

    protected static JsonPointer _parseTail(String string) {
        int n2 = string.length();
        int n3 = 1;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '/') {
                return new JsonPointer(string, string.substring(1, n3), JsonPointer._parseTail(string.substring(n3)));
            }
            if (c2 != '~' || ++n3 >= n2) continue;
            return JsonPointer._parseQuotedTail(string, n3);
        }
        return new JsonPointer(string, string.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String string, int n2) {
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, n3));
        if (n2 > 2) {
            stringBuilder.append(string, 1, n2 - 1);
        }
        JsonPointer._appendEscape(stringBuilder, string.charAt(n2++));
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 == '/') {
                return new JsonPointer(string, stringBuilder.toString(), JsonPointer._parseTail(string.substring(n2)));
            }
            if (c2 == '~' && ++n2 < n3) {
                JsonPointer._appendEscape(stringBuilder, string.charAt(n2++));
                continue;
            }
            stringBuilder.append(c2);
        }
        return new JsonPointer(string, stringBuilder.toString(), EMPTY);
    }

    protected JsonPointer _constructHead() {
        JsonPointer jsonPointer = this.last();
        if (jsonPointer == this) {
            return EMPTY;
        }
        int n2 = jsonPointer._asString.length();
        JsonPointer jsonPointer2 = this._nextSegment;
        return new JsonPointer(this._asString.substring(0, this._asString.length() - n2), this._matchingPropertyName, this._matchingElementIndex, jsonPointer2._constructHead(n2, jsonPointer));
    }

    protected JsonPointer _constructHead(int n2, JsonPointer jsonPointer) {
        if (this == jsonPointer) {
            return EMPTY;
        }
        JsonPointer jsonPointer2 = this._nextSegment;
        String string = this._asString;
        return new JsonPointer(string.substring(0, string.length() - n2), this._matchingPropertyName, this._matchingElementIndex, jsonPointer2._constructHead(n2, jsonPointer));
    }

    private static void _appendEscape(StringBuilder stringBuilder, char c2) {
        if (c2 == '0') {
            c2 = (char)126;
        } else if (c2 == '1') {
            c2 = (char)47;
        } else {
            stringBuilder.append('~');
        }
        stringBuilder.append(c2);
    }
}

