/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core.format;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import zz.com.fasterxml.jackson.core.JsonFactory;
import zz.com.fasterxml.jackson.core.format.DataFormatMatcher;
import zz.com.fasterxml.jackson.core.format.MatchStrength;

public interface InputAccessor {
    public boolean hasMoreBytes() throws IOException;

    public byte nextByte() throws IOException;

    public void reset();

    public static class Std
    implements InputAccessor {
        protected final InputStream _in;
        protected final byte[] _buffer;
        protected final int _bufferedStart;
        protected int _bufferedEnd;
        protected int _ptr;

        public Std(InputStream inputStream, byte[] byArray) {
            this._in = inputStream;
            this._buffer = byArray;
            this._bufferedStart = 0;
            this._ptr = 0;
            this._bufferedEnd = 0;
        }

        public Std(byte[] byArray) {
            this._in = null;
            this._buffer = byArray;
            this._bufferedStart = 0;
            this._bufferedEnd = byArray.length;
        }

        public Std(byte[] byArray, int n2, int n3) {
            this._in = null;
            this._buffer = byArray;
            this._ptr = n2;
            this._bufferedStart = n2;
            this._bufferedEnd = n2 + n3;
        }

        @Override
        public boolean hasMoreBytes() throws IOException {
            if (this._ptr < this._bufferedEnd) {
                return true;
            }
            if (this._in == null) {
                return false;
            }
            int n2 = this._buffer.length - this._ptr;
            if (n2 < 1) {
                return false;
            }
            int n3 = this._in.read(this._buffer, this._ptr, n2);
            if (n3 <= 0) {
                return false;
            }
            this._bufferedEnd += n3;
            return true;
        }

        @Override
        public byte nextByte() throws IOException {
            if (this._ptr >= this._bufferedEnd && !this.hasMoreBytes()) {
                throw new EOFException("Failed auto-detect: could not read more than " + this._ptr + " bytes (max buffer size: " + this._buffer.length + ")");
            }
            return this._buffer[this._ptr++];
        }

        @Override
        public void reset() {
            this._ptr = this._bufferedStart;
        }

        public DataFormatMatcher createMatcher(JsonFactory jsonFactory, MatchStrength matchStrength) {
            return new DataFormatMatcher(this._in, this._buffer, this._bufferedStart, this._bufferedEnd - this._bufferedStart, jsonFactory, matchStrength);
        }
    }
}

