/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core.io;

import java.io.Writer;
import zz.com.fasterxml.jackson.core.util.BufferRecycler;
import zz.com.fasterxml.jackson.core.util.TextBuffer;

public final class SegmentedStringWriter
extends Writer {
    private final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler bufferRecycler) {
        this._buffer = new TextBuffer(bufferRecycler);
    }

    @Override
    public Writer append(char c2) {
        this.write(c2);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        String string = charSequence.toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) {
        String string = charSequence.subSequence(n2, n3).toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cArray) {
        this._buffer.append(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this._buffer.append(cArray, n2, n3);
    }

    @Override
    public void write(int n2) {
        this._buffer.append((char)n2);
    }

    @Override
    public void write(String string) {
        this._buffer.append(string, 0, string.length());
    }

    @Override
    public void write(String string, int n2, int n3) {
        this._buffer.append(string, n2, n3);
    }

    public String getAndClear() {
        String string = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return string;
    }
}

