/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.core.JsonLocation;
import zz.com.fasterxml.jackson.core.JsonParseException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.ObjectCodec;
import zz.com.fasterxml.jackson.core.SerializableString;
import zz.com.fasterxml.jackson.core.base.ParserBase;
import zz.com.fasterxml.jackson.core.io.CharTypes;
import zz.com.fasterxml.jackson.core.io.IOContext;
import zz.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import zz.com.fasterxml.jackson.core.util.ByteArrayBuilder;

public class UTF8StreamJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    protected ObjectCodec _objectCodec;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int _quad1;
    protected int _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    public UTF8StreamJsonParser(IOContext iOContext, int n2, InputStream inputStream, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, byte[] byArray, int n3, int n4, boolean bl2) {
        super(iOContext, n2);
        this._inputStream = inputStream;
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._inputBuffer = byArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._currInputRowStart = n3;
        this._currInputProcessed = -n3;
        this._bufferRecyclable = bl2;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 < 1) {
            return 0;
        }
        int n3 = this._inputPtr;
        outputStream.write(this._inputBuffer, n3, n2);
        return n2;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    protected final boolean _loadMore() throws IOException {
        int n2 = this._inputEnd;
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        this._nameStartOffset -= n2;
        if (this._inputStream != null) {
            int n3 = this._inputBuffer.length;
            if (n3 == 0) {
                return false;
            }
            int n4 = this._inputStream.read(this._inputBuffer, 0, n3);
            if (n4 > 0) {
                this._inputPtr = 0;
                this._inputEnd = n4;
                return true;
            }
            this._closeInput();
            if (n4 == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        byte[] byArray;
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = NO_BYTES;
            this._ioContext.releaseReadIOBuffer(byArray);
        }
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            String string = this._parsingContext.getCurrentName();
            writer.write(string);
            return string.length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            writer.write(cArray);
            return cArray.length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(n2);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return this._parsingContext.getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n5 == 34) break;
                n6 = this._decodeBase64Escape(base64Variant, n5, 0);
                if (n6 < 0) continue;
            }
            if (n2 > n3) {
                n4 += n2;
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            int n7 = n6;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n6 = base64Variant.decodeBase64Char(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n6 = this._decodeBase64Escape(base64Variant, n5, 1);
            }
            n7 = n7 << 6 | n6;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n6 = base64Variant.decodeBase64Char(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n6 != -2) {
                    if (n5 == 34 && !base64Variant.usesPadding()) {
                        byArray[n2++] = (byte)(n7 >>= 4);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 2);
                }
                if (n6 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                        throw this.reportInvalidBase64Char(base64Variant, n5, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n2++] = (byte)(n7 >>= 4);
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n6 = base64Variant.decodeBase64Char(n5 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n6 != -2) {
                    if (n5 == 34 && !base64Variant.usesPadding()) {
                        byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                        byArray[n2++] = (byte)n7;
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 3);
                }
                if (n6 == -2) {
                    byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                    byArray[n2++] = (byte)n7;
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            byArray[n2++] = (byte)(n7 >> 16);
            byArray[n2++] = (byte)(n7 >> 8);
            byArray[n2++] = (byte)n7;
        }
        this._tokenIncomplete = false;
        if (n2 > 0) {
            n4 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n4;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        int n2;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n2 == 93) {
            this._closeArrayScope();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n2 == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                return this._closeScope(n2);
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            return this._nextTokenNotInObject(n2);
        }
        this._updateNameLocation();
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipColon();
        this._updateLocation();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n2);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken _nextTokenNotInObject(int n2) throws IOException {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchTrue();
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchFalse();
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchNull();
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parsePosNumber(n2);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n2);
        return this._currToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public boolean nextFieldName(SerializableString serializableString) throws IOException {
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n4 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._binaryValue = null;
        if (n4 == 93) {
            this._closeArrayScope();
            this._currToken = JsonToken.END_ARRAY;
            return false;
        }
        if (n4 == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return false;
        }
        if (this._parsingContext.expectComma()) {
            if (n4 != 44) {
                this._reportUnexpectedChar(n4, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n4 = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n4 == 93 || n4 == 125)) {
                this._closeScope(n4);
                return false;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n4);
            return false;
        }
        this._updateNameLocation();
        if (n4 == 34 && this._inputPtr + (n3 = (byArray = serializableString.asQuotedUTF8()).length) + 4 < this._inputEnd && this._inputBuffer[n2 = this._inputPtr + n3] == 34) {
            int n5 = 0;
            int n6 = this._inputPtr;
            while (true) {
                if (n6 == n2) {
                    this._parsingContext.setCurrentName(serializableString.getValue());
                    n4 = this._skipColonFast(n6 + 1);
                    this._isNextTokenNameYes(n4);
                    return true;
                }
                if (byArray[n5] != this._inputBuffer[n6]) break;
                ++n5;
                ++n6;
            }
        }
        return this._isNextTokenNameMaybe(n4, serializableString);
    }

    @Override
    public String nextFieldName() throws IOException {
        JsonToken jsonToken;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n2 == 93) {
            this._closeArrayScope();
            this._currToken = JsonToken.END_ARRAY;
            return null;
        }
        if (n2 == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return null;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                this._closeScope(n2);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n2);
            return null;
        }
        this._updateNameLocation();
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipColon();
        this._updateLocation();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n2) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n2);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    private final int _skipColonFast(int n2) throws IOException {
        byte by2;
        if ((by2 = this._inputBuffer[n2++]) == 58) {
            if ((by2 = this._inputBuffer[n2++]) > 32) {
                if (by2 != 47 && by2 != 35) {
                    this._inputPtr = n2;
                    return by2;
                }
            } else if ((by2 == 32 || by2 == 9) && (by2 = this._inputBuffer[n2++]) > 32 && by2 != 47 && by2 != 35) {
                this._inputPtr = n2;
                return by2;
            }
            this._inputPtr = n2 - 1;
            return this._skipColon2(true);
        }
        if (by2 == 32 || by2 == 9) {
            by2 = this._inputBuffer[n2++];
        }
        if (by2 == 58) {
            if ((by2 = this._inputBuffer[n2++]) > 32) {
                if (by2 != 47 && by2 != 35) {
                    this._inputPtr = n2;
                    return by2;
                }
            } else if ((by2 == 32 || by2 == 9) && (by2 = this._inputBuffer[n2++]) > 32 && by2 != 47 && by2 != 35) {
                this._inputPtr = n2;
                return by2;
            }
            this._inputPtr = n2 - 1;
            return this._skipColon2(true);
        }
        this._inputPtr = n2 - 1;
        return this._skipColon2(false);
    }

    private final void _isNextTokenNameYes(int n2) throws IOException {
        this._currToken = JsonToken.FIELD_NAME;
        this._updateLocation();
        switch (n2) {
            case 34: {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            case 91: {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            case 123: {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            case 116: {
                this._matchTrue();
                this._nextToken = JsonToken.VALUE_TRUE;
                return;
            }
            case 102: {
                this._matchFalse();
                this._nextToken = JsonToken.VALUE_FALSE;
                return;
            }
            case 110: {
                this._matchNull();
                this._nextToken = JsonToken.VALUE_NULL;
                return;
            }
            case 45: {
                this._nextToken = this._parseNegNumber();
                return;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._nextToken = this._parsePosNumber(n2);
                return;
            }
        }
        this._nextToken = this._handleUnexpectedValue(n2);
    }

    private final boolean _isNextTokenNameMaybe(int n2, SerializableString serializableString) throws IOException {
        JsonToken jsonToken;
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        boolean bl2 = string.equals(serializableString.getValue());
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipColon();
        this._updateLocation();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return bl2;
        }
        switch (n2) {
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n2);
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return bl2;
    }

    @Override
    public String nextTextValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this._finishAndReturnString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n2) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n2;
    }

    @Override
    public long nextLongValue(long l2) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l2;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected JsonToken _parsePosNumber(int n2) throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n2 == 48) {
            n2 = this._verifyNoLeadingZeroes();
        }
        cArray[0] = (char)n2;
        int n3 = 1;
        int n4 = 1;
        int n5 = Math.min(this._inputEnd, this._inputPtr + cArray.length - 1);
        while (true) {
            if (this._inputPtr >= n5) {
                return this._parseNumber2(cArray, n4, false, n3);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
            ++n3;
            cArray[n4++] = (char)n2;
        }
        if (n2 == 46 || n2 == 101 || n2 == 69) {
            return this._parseFloat(cArray, n4, n2, false, n3);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n4);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n2);
        }
        return this.resetInt(false, n3);
    }

    protected JsonToken _parseNegNumber() throws IOException {
        int n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        cArray[n3++] = 45;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 48) {
            if (n2 != 48) {
                return this._handleInvalidNumberStart(n2, true);
            }
            n2 = this._verifyNoLeadingZeroes();
        } else if (n2 > 57) {
            return this._handleInvalidNumberStart(n2, true);
        }
        cArray[n3++] = (char)n2;
        int n4 = 1;
        int n5 = Math.min(this._inputEnd, this._inputPtr + cArray.length - n3);
        while (true) {
            if (this._inputPtr >= n5) {
                return this._parseNumber2(cArray, n3, true, n4);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
            ++n4;
            cArray[n3++] = (char)n2;
        }
        if (n2 == 46 || n2 == 101 || n2 == 69) {
            return this._parseFloat(cArray, n3, n2, true, n4);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n2);
        }
        return this.resetInt(true, n4);
    }

    private final JsonToken _parseNumber2(char[] cArray, int n2, boolean bl2, int n3) throws IOException {
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._textBuffer.setCurrentLength(n2);
                return this.resetInt(bl2, n3);
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) > 57 || n4 < 48) {
                if (n4 != 46 && n4 != 101 && n4 != 69) break;
                return this._parseFloat(cArray, n2, n4, bl2, n3);
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n4;
            ++n3;
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(this._inputBuffer[this._inputPtr++] & 0xFF);
        }
        return this.resetInt(bl2, n3);
    }

    private final int _verifyNoLeadingZeroes() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return 48;
        }
        int n2 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n2 < 48 || n2 > 57) {
            return 48;
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (n2 == 48) {
            while (this._inputPtr < this._inputEnd || this._loadMore()) {
                n2 = this._inputBuffer[this._inputPtr] & 0xFF;
                if (n2 < 48 || n2 > 57) {
                    return 48;
                }
                ++this._inputPtr;
                if (n2 == 48) continue;
                break;
            }
        }
        return n2;
    }

    private final JsonToken _parseFloat(char[] cArray, int n2, int n3, boolean bl2, int n4) throws IOException {
        int n5 = 0;
        boolean bl3 = false;
        if (n3 == 46) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n3 > 57) break;
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
            }
        }
        int n6 = 0;
        if (n3 == 101 || n3 == 69) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                }
                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (n3 >= 48 && n3 <= 57) {
                ++n6;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n6 == 0) {
                this.reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl3) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(n3);
            }
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl2, n4, n5, n6);
    }

    private final void _verifyRootSpace(int n2) throws IOException {
        ++this._inputPtr;
        switch (n2) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                this._skipCR();
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n2);
    }

    protected final String _parseName(int n2) throws IOException {
        int n3;
        if (n2 != 34) {
            return this._handleOddName(n2);
        }
        if (this._inputPtr + 13 > this._inputEnd) {
            return this.slowParseName();
        }
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] == 0) {
            if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                n3 = n3 << 8 | n2;
                if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                    n3 = n3 << 8 | n2;
                    if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                        n3 = n3 << 8 | n2;
                        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                            this._quad1 = n3;
                            return this.parseMediumName(n2);
                        }
                        if (n2 == 34) {
                            return this.findName(n3, 4);
                        }
                        return this.parseName(n3, n2, 4);
                    }
                    if (n2 == 34) {
                        return this.findName(n3, 3);
                    }
                    return this.parseName(n3, n2, 3);
                }
                if (n2 == 34) {
                    return this.findName(n3, 2);
                }
                return this.parseName(n3, n2, 2);
            }
            if (n2 == 34) {
                return this.findName(n3, 1);
            }
            return this.parseName(n3, n2, 1);
        }
        if (n3 == 34) {
            return "";
        }
        return this.parseName(0, n3, 0);
    }

    protected final String parseMediumName(int n2) throws IOException {
        int n3;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 1);
            }
            return this.parseName(this._quad1, n2, n3, 1);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 2);
            }
            return this.parseName(this._quad1, n2, n3, 2);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 3);
            }
            return this.parseName(this._quad1, n2, n3, 3);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 4);
            }
            return this.parseName(this._quad1, n2, n3, 4);
        }
        return this.parseMediumName2(n3, n2);
    }

    protected final String parseMediumName2(int n2, int n3) throws IOException {
        int n4;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 1);
            }
            return this.parseName(this._quad1, n3, n2, n4, 1);
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 2);
            }
            return this.parseName(this._quad1, n3, n2, n4, 2);
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 3);
            }
            return this.parseName(this._quad1, n3, n2, n4, 3);
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 4);
            }
            return this.parseName(this._quad1, n3, n2, n4, 4);
        }
        return this.parseLongName(n4, n3, n2);
    }

    protected final String parseLongName(int n2, int n3, int n4) throws IOException {
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n3;
        this._quadBuffer[2] = n4;
        byte[] byArray = this._inputBuffer;
        int[] nArray = _icLatin1;
        int n5 = 3;
        while (this._inputPtr + 4 <= this._inputEnd) {
            int n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 1);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 1);
            }
            n2 = n2 << 8 | n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 2);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 2);
            }
            n2 = n2 << 8 | n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 3);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 3);
            }
            n2 = n2 << 8 | n6;
            if (nArray[n6 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 4);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 4);
            }
            if (n5 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8StreamJsonParser.growArrayBy(this._quadBuffer, n5);
            }
            this._quadBuffer[n5++] = n2;
            n2 = n6;
        }
        return this.parseEscapedName(this._quadBuffer, n5, 0, n2, 0);
    }

    protected String slowParseName() throws IOException {
        int n2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name", JsonToken.FIELD_NAME);
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return "";
        }
        return this.parseEscapedName(this._quadBuffer, 0, 0, n2, 0);
    }

    private final String parseName(int n2, int n3, int n4) throws IOException {
        return this.parseEscapedName(this._quadBuffer, 0, n2, n3, n4);
    }

    private final String parseName(int n2, int n3, int n4, int n5) throws IOException {
        this._quadBuffer[0] = n2;
        return this.parseEscapedName(this._quadBuffer, 1, n3, n4, n5);
    }

    private final String parseName(int n2, int n3, int n4, int n5, int n6) throws IOException {
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        return this.parseEscapedName(this._quadBuffer, 2, n4, n5, n6);
    }

    protected final String parseEscapedName(int[] nArray, int n2, int n3, int n4, int n5) throws IOException {
        String string;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (nArray2[n4] != 0) {
                if (n4 == 34) break;
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeEscaped();
                }
                if (n4 > 127) {
                    if (n5 >= 4) {
                        if (n2 >= nArray.length) {
                            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n5 = 0;
                    }
                    if (n4 < 2048) {
                        n3 = n3 << 8 | (0xC0 | n4 >> 6);
                        ++n5;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n4 >> 12);
                        if (++n5 >= 4) {
                            if (n2 >= nArray.length) {
                                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n5 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n4 >> 6 & 0x3F);
                        ++n5;
                    }
                    n4 = 0x80 | n4 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n3 = n3 << 8 | n4;
            } else {
                if (n2 >= nArray.length) {
                    nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n2++] = n3;
                n3 = n4;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n5 > 0) {
            if (n2 >= nArray.length) {
                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n2++] = UTF8StreamJsonParser._padLastQuad(n3, n5);
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this.addName(nArray, n2, n5);
        }
        return string;
    }

    protected String _handleOddName(int n2) throws IOException {
        String string;
        int[] nArray;
        if (n2 == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseAposName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            char c2 = (char)this._decodeCharForError(n2);
            this._reportUnexpectedChar(c2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray2.length) {
                    this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                }
                nArray2[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            if (nArray[n2 = this._inputBuffer[this._inputPtr] & 0xFF] != 0) break;
            ++this._inputPtr;
        }
        if (n5 > 0) {
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
        }
        if ((string = this._symbols.findName(nArray2, n3)) == null) {
            string = this.addName(nArray2, n3, n5);
        }
        return string;
    }

    protected String _parseAposName() throws IOException {
        String string;
        int n2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for field name", JsonToken.FIELD_NAME);
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = _icLatin1;
        while (n2 != 39) {
            if (nArray2[n2] != 0 && n2 != 34) {
                if (n2 != 92) {
                    this._throwUnquotedSpace(n2, "name");
                } else {
                    n2 = this._decodeEscaped();
                }
                if (n2 > 127) {
                    if (n5 >= 4) {
                        if (n3 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n3++] = n4;
                        n4 = 0;
                        n5 = 0;
                    }
                    if (n2 < 2048) {
                        n4 = n4 << 8 | (0xC0 | n2 >> 6);
                        ++n5;
                    } else {
                        n4 = n4 << 8 | (0xE0 | n2 >> 12);
                        if (++n5 >= 4) {
                            if (n3 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n3++] = n4;
                            n4 = 0;
                            n5 = 0;
                        }
                        n4 = n4 << 8 | (0x80 | n2 >> 6 & 0x3F);
                        ++n5;
                    }
                    n2 = 0x80 | n2 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n5 > 0) {
            if (n3 >= nArray.length) {
                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n3++] = UTF8StreamJsonParser._padLastQuad(n4, n5);
        }
        if ((string = this._symbols.findName(nArray, n3)) == null) {
            string = this.addName(nArray, n3, n5);
        }
        return string;
    }

    private final String findName(int n2, int n3) throws JsonParseException {
        String string = this._symbols.findName(n2 = UTF8StreamJsonParser._padLastQuad(n2, n3));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        return this.addName(this._quadBuffer, 1, n3);
    }

    private final String findName(int n2, int n3, int n4) throws JsonParseException {
        String string = this._symbols.findName(n2, n3 = UTF8StreamJsonParser._padLastQuad(n3, n4));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        return this.addName(this._quadBuffer, 2, n4);
    }

    private final String findName(int n2, int n3, int n4, int n5) throws JsonParseException {
        String string = this._symbols.findName(n2, n3, n4 = UTF8StreamJsonParser._padLastQuad(n4, n5));
        if (string != null) {
            return string;
        }
        int[] nArray = this._quadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = UTF8StreamJsonParser._padLastQuad(n4, n5);
        return this.addName(nArray, 3, n5);
    }

    private final String findName(int[] nArray, int n2, int n3, int n4) throws JsonParseException {
        if (n2 >= nArray.length) {
            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = UTF8StreamJsonParser._padLastQuad(n3, n4);
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            return this.addName(nArray, n2, n4);
        }
        return string;
    }

    private final String addName(int[] nArray, int n2, int n3) throws JsonParseException {
        int n4;
        int n5 = (n2 << 2) - 4 + n3;
        if (n3 < 4) {
            n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n4 << (4 - n3 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n5) {
                    this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (n3 < 4) {
            nArray[n2 - 1] = n4;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    private static final int _padLastQuad(int n2, int n3) {
        return n3 == 4 ? n2 : n2 | -1 << (n3 << 3);
    }

    protected void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Override
    protected void _finishString() throws IOException {
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n2 < n4) {
            int n5 = byArray[n2] & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                this._textBuffer.setCurrentLength(n3);
                return;
            }
            ++n2;
            cArray[n3++] = (char)n5;
        }
        this._inputPtr = n2;
        this._finishString2(cArray, n3);
    }

    protected String _finishAndReturnString() throws IOException {
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n2 < n4) {
            int n5 = byArray[n2] & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                return this._textBuffer.setCurrentAndReturn(n3);
            }
            ++n2;
            cArray[n3++] = (char)n5;
        }
        this._inputPtr = n2;
        this._finishString2(cArray, n3);
        return this._textBuffer.contentsAsString();
    }

    private final void _finishString2(char[] cArray, int n2) throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n3;
            int n4;
            block15: {
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                int n5 = Math.min(this._inputEnd, n4 + (cArray.length - n2));
                while (n4 < n5) {
                    if (nArray[n3 = byArray[n4++] & 0xFF] == 0) {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    break block15;
                }
                this._inputPtr = n4;
                continue;
            }
            this._inputPtr = n4;
            if (n3 == 34) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n3 = this._decodeUtf8_3fast(n3);
                        break;
                    }
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 4: {
                    n3 = this._decodeUtf8_4(n3);
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                        break;
                    }
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n2;
            int n3;
            block10: {
                int n4;
                if ((n3 = this._inputPtr) >= (n4 = this._inputEnd)) {
                    this._loadMoreGuaranteed();
                    n3 = this._inputPtr;
                    n4 = this._inputEnd;
                }
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(n2);
                    continue block6;
                }
            }
            if (n2 < 32) {
                this._throwUnquotedSpace(n2, "string value");
                continue;
            }
            this._reportInvalidChar(n2);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n2) throws IOException {
        switch (n2) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (this.isEnabled(JsonParser.Feature.ALLOW_MISSING_VALUES)) {
                    --this._inputPtr;
                    return JsonToken.VALUE_NULL;
                }
            }
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++] & 0xFF, false);
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            this._reportInvalidToken("" + (char)n2, "('true', 'false' or 'null')");
        }
        this._reportUnexpectedChar(n2, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApos() throws IOException {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n4;
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            if ((n5 = this._inputPtr + (cArray.length - n3)) < (n4 = this._inputEnd)) {
                n4 = n5;
            }
            while (true) {
                if (this._inputPtr >= n4) continue block6;
                if ((n2 = byArray[this._inputPtr++] & 0xFF) == 39 || nArray[n2] != 0) break;
                cArray[n3++] = (char)n2;
            }
            if (n2 == 39) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n3++] = (char)(0xD800 | n2 >> 10);
                    if (n3 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n3 = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n3);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) throws IOException {
        while (n2 == 73) {
            String string;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_FLOAT);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 78) {
                string = bl2 ? "-INF" : "+INF";
            } else {
                if (n2 != 110) break;
                string = bl2 ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '%s': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow", string);
        }
        this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected final void _matchTrue() throws IOException {
        int n2;
        byte[] byArray;
        int n3 = this._inputPtr;
        if (n3 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n3++] == 114 && byArray[n3++] == 117 && byArray[n3++] == 101 && ((n2 = byArray[n3] & 0xFF) < 48 || n2 == 93 || n2 == 125)) {
            this._inputPtr = n3;
            return;
        }
        this._matchToken2("true", 1);
    }

    protected final void _matchFalse() throws IOException {
        int n2;
        byte[] byArray;
        int n3 = this._inputPtr;
        if (n3 + 4 < this._inputEnd && (byArray = this._inputBuffer)[n3++] == 97 && byArray[n3++] == 108 && byArray[n3++] == 115 && byArray[n3++] == 101 && ((n2 = byArray[n3] & 0xFF) < 48 || n2 == 93 || n2 == 125)) {
            this._inputPtr = n3;
            return;
        }
        this._matchToken2("false", 1);
    }

    protected final void _matchNull() throws IOException {
        int n2;
        byte[] byArray;
        int n3 = this._inputPtr;
        if (n3 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n3++] == 117 && byArray[n3++] == 108 && byArray[n3++] == 108 && ((n2 = byArray[n3] & 0xFF) < 48 || n2 == 93 || n2 == 125)) {
            this._inputPtr = n3;
            return;
        }
        this._matchToken2("null", 1);
    }

    protected final void _matchToken(String string, int n2) throws IOException {
        int n3 = string.length();
        if (this._inputPtr + n3 >= this._inputEnd) {
            this._matchToken2(string, n2);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        int n4 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n4 >= 48 && n4 != 93 && n4 != 125) {
            this._checkMatchEnd(string, n2, n4);
        }
    }

    private final void _matchToken2(String string, int n2) throws IOException {
        int n3 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return;
        }
        int n4 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n4 >= 48 && n4 != 93 && n4 != 125) {
            this._checkMatchEnd(string, n2, n4);
        }
    }

    private final void _checkMatchEnd(String string, int n2, int n3) throws IOException {
        char c2 = (char)this._decodeCharForError(n3);
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(string.substring(0, n2));
        }
    }

    private final int _skipWS() throws IOException {
        while (this._inputPtr < this._inputEnd) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47 || n2 == 35) {
                    --this._inputPtr;
                    return this._skipWS2();
                }
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._skipWS2();
    }

    private final int _skipWS2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47) {
                    this._skipComment();
                    continue;
                }
                if (n2 == 35 && this._skipYAMLComment()) continue;
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException {
        int n2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
            if (n2 == 47 || n2 == 35) {
                --this._inputPtr;
                return this._skipWSOrEnd2();
            }
            return n2;
        }
        if (n2 != 32) {
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (n2 == 13) {
                this._skipCR();
            } else if (n2 != 9) {
                this._throwInvalidSpace(n2);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47 || n2 == 35) {
                    --this._inputPtr;
                    return this._skipWSOrEnd2();
                }
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._skipWSOrEnd2();
    }

    private final int _skipWSOrEnd2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47) {
                    this._skipComment();
                    continue;
                }
                if (n2 == 35 && this._skipYAMLComment()) continue;
                return n2;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._eofAsNextChar();
    }

    private final int _skipColon() throws IOException {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        byte by2 = this._inputBuffer[this._inputPtr];
        if (by2 == 58) {
            if ((by2 = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by2 == 47 || by2 == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by2;
            }
            if ((by2 == 32 || by2 == 9) && (by2 = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by2 == 47 || by2 == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by2;
            }
            return this._skipColon2(true);
        }
        if (by2 == 32 || by2 == 9) {
            by2 = this._inputBuffer[++this._inputPtr];
        }
        if (by2 == 58) {
            if ((by2 = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by2 == 47 || by2 == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by2;
            }
            if ((by2 == 32 || by2 == 9) && (by2 = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by2 == 47 || by2 == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by2;
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private final int _skipColon2(boolean bl2) throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 == 47) {
                    this._skipComment();
                    continue;
                }
                if (n2 == 35 && this._skipYAMLComment()) continue;
                if (bl2) {
                    return n2;
                }
                if (n2 != 58) {
                    this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
                }
                bl2 = true;
                continue;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private final void _skipComment() throws IOException {
        int n2;
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipLine();
        } else if (n2 == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n3) {
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this._loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    break;
                }
                case 13: {
                    this._skipCR();
                    break;
                }
                case 2: {
                    this._skipUtf8_2();
                    break;
                }
                case 3: {
                    this._skipUtf8_3();
                    break;
                }
                case 4: {
                    this._skipUtf8_4(n2);
                    break;
                }
                default: {
                    this._reportInvalidChar(n2);
                }
            }
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private final boolean _skipYAMLComment() throws IOException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_YAML_COMMENTS)) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private final void _skipLine() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n3) {
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block8;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block8;
                }
                case 4: {
                    this._skipUtf8_4(n2);
                    continue block8;
                }
            }
            if (n3 >= 0) continue;
            this._reportInvalidChar(n2);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        byte by2 = this._inputBuffer[this._inputPtr++];
        switch (by2) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by2;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(by2));
            }
        }
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte by3;
            int n3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((n3 = CharTypes.charToHex(by3 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by3, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n3;
        }
        return (char)n2;
    }

    protected int _decodeCharForError(int n2) throws IOException {
        int n3 = n2 & 0xFF;
        if (n3 > 127) {
            int n4;
            if ((n3 & 0xE0) == 192) {
                n3 &= 0x1F;
                n4 = 1;
            } else if ((n3 & 0xF0) == 224) {
                n3 &= 0xF;
                n4 = 2;
            } else if ((n3 & 0xF8) == 240) {
                n3 &= 7;
                n4 = 3;
            } else {
                this._reportInvalidInitial(n3 & 0xFF);
                n4 = 1;
            }
            int n5 = this.nextByte();
            if ((n5 & 0xC0) != 128) {
                this._reportInvalidOther(n5 & 0xFF);
            }
            n3 = n3 << 6 | n5 & 0x3F;
            if (n4 > 1) {
                n5 = this.nextByte();
                if ((n5 & 0xC0) != 128) {
                    this._reportInvalidOther(n5 & 0xFF);
                }
                n3 = n3 << 6 | n5 & 0x3F;
                if (n4 > 2) {
                    n5 = this.nextByte();
                    if ((n5 & 0xC0) != 128) {
                        this._reportInvalidOther(n5 & 0xFF);
                    }
                    n3 = n3 << 6 | n5 & 0x3F;
                }
            }
        }
        return n3;
    }

    private final int _decodeUtf8_2(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | by2 & 0x3F;
    }

    private final int _decodeUtf8_3(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n2 &= 0xF;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n3 = n2 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | by2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_3fast(int n2) throws IOException {
        byte by2;
        n2 &= 0xF;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n3 = n2 << 6 | by2 & 0x3F;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | by2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_4(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n2 = (n2 & 7) << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 << 6 | by2 & 0x3F) - 65536;
    }

    private final void _skipUtf8_2() throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_3() throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_4(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidToken(String string, int n2) throws IOException {
        this._inputPtr = n2;
        this._reportInvalidToken(string, "'null', 'true', 'false' or NaN");
    }

    protected void _reportInvalidToken(String string) throws IOException {
        this._reportInvalidToken(string, "'null', 'true', 'false' or NaN");
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException {
        byte by2;
        char c2;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c2 = (char)this._decodeCharForError(by2 = this._inputBuffer[this._inputPtr++]))) {
            stringBuilder.append(c2);
            if (stringBuilder.length() < 256) continue;
            stringBuilder.append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", stringBuilder, string2);
    }

    protected void _reportInvalidChar(int n2) throws JsonParseException {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2, int n3) throws JsonParseException {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n2 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n3 = this._decodeBase64Escape(base64Variant, n2, 0);
                if (n3 < 0) continue;
            }
            int n4 = n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n3 = this._decodeBase64Escape(base64Variant, n2, 1);
            }
            n4 = n4 << 6 | n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n3 != -2) {
                    if (n2 == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n4 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 2);
                }
                if (n3 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                        throw this.reportInvalidBase64Char(base64Variant, n2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n4 >>= 4);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n3 != -2) {
                    if (n2 == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 3);
                }
                if (n3 == -2) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            long l2 = this._currInputProcessed + (long)(this._nameStartOffset - 1);
            return new JsonLocation(this._getSourceReference(), l2, -1L, this._nameStartRow, this._nameStartCol);
        }
        return new JsonLocation(this._getSourceReference(), this._tokenInputTotal - 1L, -1L, this._tokenInputRow, this._tokenInputCol);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._getSourceReference(), this._currInputProcessed + (long)this._inputPtr, -1L, this._currInputRow, n2);
    }

    private final void _updateLocation() {
        this._tokenInputRow = this._currInputRow;
        int n2 = this._inputPtr;
        this._tokenInputTotal = this._currInputProcessed + (long)n2;
        this._tokenInputCol = n2 - this._currInputRowStart;
    }

    private final void _updateNameLocation() {
        int n2;
        this._nameStartRow = this._currInputRow;
        this._nameStartOffset = n2 = this._inputPtr;
        this._nameStartCol = n2 - this._currInputRowStart;
    }

    private final JsonToken _closeScope(int n2) throws JsonParseException {
        if (n2 == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        this._closeArrayScope();
        this._currToken = JsonToken.END_ARRAY;
        return this._currToken;
    }

    private final void _closeArrayScope() throws JsonParseException {
        this._updateLocation();
        if (!this._parsingContext.inArray()) {
            this._reportMismatchedEndMarker(93, '}');
        }
        this._parsingContext = this._parsingContext.clearAndGetParent();
    }

    private final void _closeObjectScope() throws JsonParseException {
        this._updateLocation();
        if (!this._parsingContext.inObject()) {
            this._reportMismatchedEndMarker(125, ']');
        }
        this._parsingContext = this._parsingContext.clearAndGetParent();
    }
}

