/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core.json.async;

import java.io.IOException;
import java.io.OutputStream;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.async.ByteArrayFeeder;
import zz.com.fasterxml.jackson.core.io.CharTypes;
import zz.com.fasterxml.jackson.core.io.IOContext;
import zz.com.fasterxml.jackson.core.json.async.NonBlockingJsonParserBase;
import zz.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import zz.com.fasterxml.jackson.core.util.VersionUtil;

public class NonBlockingJsonParser
extends NonBlockingJsonParserBase
implements ByteArrayFeeder {
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected byte[] _inputBuffer = NO_BYTES;
    protected int _origBufferLen;

    public NonBlockingJsonParser(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n2, byteQuadsCanonicalizer);
    }

    @Override
    public ByteArrayFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    @Override
    public void feedInput(byte[] byArray, int n2, int n3) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        if (n3 < n2) {
            this._reportError("Input end (%d) may not be before start (%d)", n3, n2);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart = n2 - (this._inputEnd - this._currInputRowStart);
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._origBufferLen = n3 - n2;
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0) {
            outputStream.write(this._inputBuffer, this._inputPtr, n2);
        }
        return n2;
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        VersionUtil.throwInternal();
        return ' ';
    }

    @Override
    public JsonToken nextToken() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            if (this._closed) {
                return null;
            }
            if (this._endOfInput) {
                if (this._currToken == JsonToken.NOT_AVAILABLE) {
                    return this._finishTokenWithEOF();
                }
                return this._eofAsNextToken();
            }
            return JsonToken.NOT_AVAILABLE;
        }
        if (this._currToken == JsonToken.NOT_AVAILABLE) {
            return this._finishToken();
        }
        this._numTypesValid = 0;
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (this._majorState) {
            case 0: {
                return this._startDocument(n2);
            }
            case 1: {
                return this._startValue(n2);
            }
            case 2: {
                return this._startFieldName(n2);
            }
            case 3: {
                return this._startFieldNameAfterComma(n2);
            }
            case 4: {
                return this._startValueExpectColon(n2);
            }
            case 5: {
                return this._startValue(n2);
            }
            case 6: {
                return this._startValueExpectComma(n2);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected final JsonToken _finishToken() throws IOException {
        switch (this._minorState) {
            case 1: {
                return this._finishBOM(this._pending32);
            }
            case 4: {
                return this._startFieldName(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 5: {
                return this._startFieldNameAfterComma(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 7: {
                return this._parseEscapedName(this._quadLength, this._pending32, this._pendingBytes);
            }
            case 8: {
                return this._finishFieldWithEscape();
            }
            case 9: {
                return this._finishAposName(this._quadLength, this._pending32, this._pendingBytes);
            }
            case 10: {
                return this._finishUnquotedName(this._quadLength, this._pending32, this._pendingBytes);
            }
            case 12: {
                return this._startValue(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 15: {
                return this._startValueAfterComma(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 13: {
                return this._startValueExpectComma(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 14: {
                return this._startValueExpectColon(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 16: {
                return this._finishKeywordToken("null", this._pending32, JsonToken.VALUE_NULL);
            }
            case 17: {
                return this._finishKeywordToken("true", this._pending32, JsonToken.VALUE_TRUE);
            }
            case 18: {
                return this._finishKeywordToken("false", this._pending32, JsonToken.VALUE_FALSE);
            }
            case 19: {
                return this._finishNonStdToken(this._nonStdTokenType, this._pending32);
            }
            case 23: {
                return this._finishNumberMinus(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 24: {
                return this._finishNumberLeadingZeroes();
            }
            case 25: {
                return this._finishNumberLeadingNegZeroes();
            }
            case 26: {
                return this._finishNumberIntegralPart(this._textBuffer.getBufferWithoutReset(), this._textBuffer.getCurrentSegmentSize());
            }
            case 30: {
                return this._finishFloatFraction();
            }
            case 31: {
                return this._finishFloatExponent(true, this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 32: {
                return this._finishFloatExponent(false, this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 40: {
                return this._finishRegularString();
            }
            case 42: {
                this._textBuffer.append((char)this._decodeUTF8_2(this._pending32, this._inputBuffer[this._inputPtr++]));
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 43: {
                if (!this._decodeSplitUTF8_3(this._pending32, this._pendingBytes, this._inputBuffer[this._inputPtr++])) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 44: {
                if (!this._decodeSplitUTF8_4(this._pending32, this._pendingBytes, this._inputBuffer[this._inputPtr++])) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 41: {
                int n2 = this._decodeSplitEscaped(this._quoted32, this._quotedDigits);
                if (n2 < 0) {
                    return JsonToken.NOT_AVAILABLE;
                }
                this._textBuffer.append((char)n2);
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 45: {
                return this._finishAposString();
            }
            case 50: {
                return this._finishErrorToken();
            }
            case 51: {
                return this._startSlashComment(this._pending32);
            }
            case 52: {
                return this._finishCComment(this._pending32, true);
            }
            case 53: {
                return this._finishCComment(this._pending32, false);
            }
            case 54: {
                return this._finishCppComment(this._pending32);
            }
            case 55: {
                return this._finishHashComment(this._pending32);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected final JsonToken _finishTokenWithEOF() throws IOException {
        JsonToken jsonToken = this._currToken;
        switch (this._minorState) {
            case 3: {
                return this._eofAsNextToken();
            }
            case 12: {
                return this._eofAsNextToken();
            }
            case 16: {
                return this._finishKeywordTokenWithEOF("null", this._pending32, JsonToken.VALUE_NULL);
            }
            case 17: {
                return this._finishKeywordTokenWithEOF("true", this._pending32, JsonToken.VALUE_TRUE);
            }
            case 18: {
                return this._finishKeywordTokenWithEOF("false", this._pending32, JsonToken.VALUE_FALSE);
            }
            case 19: {
                return this._finishNonStdTokenWithEOF(this._nonStdTokenType, this._pending32);
            }
            case 50: {
                return this._finishErrorTokenWithEOF();
            }
            case 24: 
            case 25: {
                return this._valueCompleteInt(0, "0");
            }
            case 26: {
                int n2 = this._textBuffer.getCurrentSegmentSize();
                if (this._numberNegative) {
                    --n2;
                }
                this._intLength = n2;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            case 30: {
                this._expLength = 0;
            }
            case 32: {
                return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
            }
            case 31: {
                this._reportInvalidEOF(": was expecting fraction after exponent marker", JsonToken.VALUE_NUMBER_FLOAT);
            }
            case 52: 
            case 53: {
                this._reportInvalidEOF(": was expecting closing '*/' for comment", JsonToken.NOT_AVAILABLE);
            }
            case 54: 
            case 55: {
                return this._eofAsNextToken();
            }
        }
        this._reportInvalidEOF(": was expecting rest of token (internal state: " + this._minorState + ")", this._currToken);
        return jsonToken;
    }

    private final JsonToken _startDocument(int n2) throws IOException {
        if ((n2 &= 0xFF) == 239 && this._minorState != 1) {
            return this._finishBOM(1);
        }
        while (n2 <= 32) {
            if (n2 != 32) {
                if (n2 == 10) {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                } else if (n2 == 13) {
                    ++this._currInputRowAlt;
                    this._currInputRowStart = this._inputPtr;
                } else if (n2 != 9) {
                    this._throwInvalidSpace(n2);
                }
            }
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 3;
                if (this._closed) {
                    return null;
                }
                if (this._endOfInput) {
                    return this._eofAsNextToken();
                }
                return JsonToken.NOT_AVAILABLE;
            }
            n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        return this._startValue(n2);
    }

    private final JsonToken _finishBOM(int n2) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            int n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (n2) {
                case 3: {
                    this._currInputProcessed -= 3L;
                    return this._startDocument(n3);
                }
                case 2: {
                    if (n3 == 191) break;
                    this._reportError("Unexpected byte 0x%02x following 0xEF 0xBB; should get 0xBF as third byte of UTF-8 BOM", n3);
                    break;
                }
                case 1: {
                    if (n3 == 187) break;
                    this._reportError("Unexpected byte 0x%02x following 0xEF; should get 0xBB as second byte UTF-8 BOM", n3);
                }
            }
            ++n2;
        }
        this._pending32 = n2;
        this._minorState = 1;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startFieldName(int n2) throws IOException {
        String string;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 4;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 != 34) {
            if (n2 == 125) {
                return this._closeObjectScope();
            }
            return this._handleOddName(n2);
        }
        if (this._inputPtr + 13 <= this._inputEnd && (string = this._fastParseName()) != null) {
            return this._fieldComplete(string);
        }
        return this._parseEscapedName(0, 0, 0);
    }

    private final JsonToken _startFieldNameAfterComma(int n2) throws IOException {
        String string;
        int n3;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 5;
            return this._currToken;
        }
        if (n2 != 44) {
            if (n2 == 125) {
                return this._closeObjectScope();
            }
            if (n2 == 35) {
                return this._finishHashComment(5);
            }
            if (n2 == 47) {
                return this._startSlashComment(5);
            }
            this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        if ((n3 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 4;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n2 = this._inputBuffer[n3];
        this._inputPtr = n3 + 1;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 4;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 != 34) {
            if (n2 == 125 && JsonParser.Feature.ALLOW_TRAILING_COMMA.enabledIn(this._features)) {
                return this._closeObjectScope();
            }
            return this._handleOddName(n2);
        }
        if (this._inputPtr + 13 <= this._inputEnd && (string = this._fastParseName()) != null) {
            return this._fieldComplete(string);
        }
        return this._parseEscapedName(0, 0, 0);
    }

    private final JsonToken _startValue(int n2) throws IOException {
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 12;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 == 34) {
            return this._startString();
        }
        switch (n2) {
            case 35: {
                return this._finishHashComment(12);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(12);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n2);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 93: {
                return this._closeArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 125: {
                return this._closeObjectScope();
            }
        }
        return this._startUnexpectedValue(false, n2);
    }

    private final JsonToken _startValueExpectComma(int n2) throws IOException {
        int n3;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 13;
            return this._currToken;
        }
        if (n2 != 44) {
            if (n2 == 93) {
                return this._closeArrayScope();
            }
            if (n2 == 125) {
                return this._closeObjectScope();
            }
            if (n2 == 47) {
                return this._startSlashComment(13);
            }
            if (n2 == 35) {
                return this._finishHashComment(13);
            }
            this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        if ((n3 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 15;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n2 = this._inputBuffer[n3];
        this._inputPtr = n3 + 1;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 15;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 == 34) {
            return this._startString();
        }
        switch (n2) {
            case 35: {
                return this._finishHashComment(15);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(15);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n2);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 93: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_TRAILING_COMMA)) break;
                return this._closeArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 125: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_TRAILING_COMMA)) break;
                return this._closeObjectScope();
            }
        }
        return this._startUnexpectedValue(true, n2);
    }

    private final JsonToken _startValueExpectColon(int n2) throws IOException {
        int n3;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 14;
            return this._currToken;
        }
        if (n2 != 58) {
            if (n2 == 47) {
                return this._startSlashComment(14);
            }
            if (n2 == 35) {
                return this._finishHashComment(14);
            }
            this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
        }
        if ((n3 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 12;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n2 = this._inputBuffer[n3];
        this._inputPtr = n3 + 1;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 12;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 == 34) {
            return this._startString();
        }
        switch (n2) {
            case 35: {
                return this._finishHashComment(12);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(12);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n2);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
        }
        return this._startUnexpectedValue(false, n2);
    }

    private final JsonToken _startValueAfterComma(int n2) throws IOException {
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 15;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 == 34) {
            return this._startString();
        }
        switch (n2) {
            case 35: {
                return this._finishHashComment(15);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(15);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n2);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 93: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_TRAILING_COMMA)) break;
                return this._closeArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 125: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_TRAILING_COMMA)) break;
                return this._closeObjectScope();
            }
        }
        return this._startUnexpectedValue(true, n2);
    }

    protected JsonToken _startUnexpectedValue(boolean bl2, int n2) throws IOException {
        switch (n2) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (this.isEnabled(JsonParser.Feature.ALLOW_MISSING_VALUES)) {
                    --this._inputPtr;
                    return this._valueComplete(JsonToken.VALUE_NULL);
                }
            }
            case 125: {
                break;
            }
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._startAposString();
            }
            case 43: {
                return this._finishNonStdToken(2, 1);
            }
            case 78: {
                return this._finishNonStdToken(0, 1);
            }
            case 73: {
                return this._finishNonStdToken(1, 1);
            }
        }
        this._reportUnexpectedChar(n2, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    private final int _skipWS(int n2) throws IOException {
        do {
            if (n2 != 32) {
                if (n2 == 10) {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                } else if (n2 == 13) {
                    ++this._currInputRowAlt;
                    this._currInputRowStart = this._inputPtr;
                } else if (n2 != 9) {
                    this._throwInvalidSpace(n2);
                }
            }
            if (this._inputPtr < this._inputEnd) continue;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return 0;
        } while ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32);
        return n2;
    }

    private final JsonToken _startSlashComment(int n2) throws IOException {
        byte by2;
        if (!JsonParser.Feature.ALLOW_COMMENTS.enabledIn(this._features)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd) {
            this._pending32 = n2;
            this._minorState = 51;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        if ((by2 = this._inputBuffer[this._inputPtr++]) == 42) {
            return this._finishCComment(n2, false);
        }
        if (by2 == 47) {
            return this._finishCppComment(n2);
        }
        this._reportUnexpectedChar(by2 & 0xFF, "was expecting either '*' or '/' for a comment");
        return null;
    }

    private final JsonToken _finishHashComment(int n2) throws IOException {
        if (!JsonParser.Feature.ALLOW_YAML_COMMENTS.enabledIn(this._features)) {
            this._reportUnexpectedChar(35, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_YAML_COMMENTS' not enabled for parser)");
        }
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 55;
                this._pending32 = n2;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) >= 32) continue;
            if (n3 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n3 == 13) {
                ++this._currInputRowAlt;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
        return this._startAfterComment(n2);
    }

    private final JsonToken _finishCppComment(int n2) throws IOException {
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 54;
                this._pending32 = n2;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) >= 32) continue;
            if (n3 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n3 == 13) {
                ++this._currInputRowAlt;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
        return this._startAfterComment(n2);
    }

    private final JsonToken _finishCComment(int n2, boolean bl2) throws IOException {
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = bl2 ? 52 : 53;
                this._pending32 = n2;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) < 32) {
                if (n3 == 10) {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                } else if (n3 == 13) {
                    ++this._currInputRowAlt;
                    this._currInputRowStart = this._inputPtr;
                } else if (n3 != 9) {
                    this._throwInvalidSpace(n3);
                }
            } else {
                if (n3 == 42) {
                    bl2 = true;
                    continue;
                }
                if (n3 == 47 && bl2) break;
            }
            bl2 = false;
        }
        return this._startAfterComment(n2);
    }

    private final JsonToken _startAfterComment(int n2) throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = n2;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (n2) {
            case 4: {
                return this._startFieldName(n3);
            }
            case 5: {
                return this._startFieldNameAfterComma(n3);
            }
            case 12: {
                return this._startValue(n3);
            }
            case 13: {
                return this._startValueExpectComma(n3);
            }
            case 14: {
                return this._startValueExpectColon(n3);
            }
            case 15: {
                return this._startValueAfterComma(n3);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected JsonToken _startFalseToken() throws IOException {
        int n2;
        byte[] byArray;
        int n3 = this._inputPtr;
        if (n3 + 4 < this._inputEnd && (byArray = this._inputBuffer)[n3++] == 97 && byArray[n3++] == 108 && byArray[n3++] == 115 && byArray[n3++] == 101 && ((n2 = byArray[n3] & 0xFF) < 48 || n2 == 93 || n2 == 125)) {
            this._inputPtr = n3;
            return this._valueComplete(JsonToken.VALUE_FALSE);
        }
        this._minorState = 18;
        return this._finishKeywordToken("false", 1, JsonToken.VALUE_FALSE);
    }

    protected JsonToken _startTrueToken() throws IOException {
        int n2;
        byte[] byArray;
        int n3 = this._inputPtr;
        if (n3 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n3++] == 114 && byArray[n3++] == 117 && byArray[n3++] == 101 && ((n2 = byArray[n3] & 0xFF) < 48 || n2 == 93 || n2 == 125)) {
            this._inputPtr = n3;
            return this._valueComplete(JsonToken.VALUE_TRUE);
        }
        this._minorState = 17;
        return this._finishKeywordToken("true", 1, JsonToken.VALUE_TRUE);
    }

    protected JsonToken _startNullToken() throws IOException {
        int n2;
        byte[] byArray;
        int n3 = this._inputPtr;
        if (n3 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n3++] == 117 && byArray[n3++] == 108 && byArray[n3++] == 108 && ((n2 = byArray[n3] & 0xFF) < 48 || n2 == 93 || n2 == 125)) {
            this._inputPtr = n3;
            return this._valueComplete(JsonToken.VALUE_NULL);
        }
        this._minorState = 16;
        return this._finishKeywordToken("null", 1, JsonToken.VALUE_NULL);
    }

    protected JsonToken _finishKeywordToken(String string, int n2, JsonToken jsonToken) throws IOException {
        int n3 = string.length();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._pending32 = n2;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            byte by2 = this._inputBuffer[this._inputPtr];
            if (n2 == n3) {
                if (by2 >= 48 && by2 != 93 && by2 != 125) break;
                return this._valueComplete(jsonToken);
            }
            if (by2 != string.charAt(n2)) break;
            ++n2;
            ++this._inputPtr;
        }
        this._minorState = 50;
        this._textBuffer.resetWithCopy(string, 0, n2);
        return this._finishErrorToken();
    }

    protected JsonToken _finishKeywordTokenWithEOF(String string, int n2, JsonToken jsonToken) throws IOException {
        if (n2 == string.length()) {
            this._currToken = jsonToken;
            return this._currToken;
        }
        this._textBuffer.resetWithCopy(string, 0, n2);
        return this._finishErrorTokenWithEOF();
    }

    protected JsonToken _finishNonStdToken(int n2, int n3) throws IOException {
        String string = this._nonStdToken(n2);
        int n4 = string.length();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._nonStdTokenType = n2;
                this._pending32 = n3;
                this._minorState = 19;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            byte by2 = this._inputBuffer[this._inputPtr];
            if (n3 == n4) {
                if (by2 >= 48 && by2 != 93 && by2 != 125) break;
                return this._valueNonStdNumberComplete(n2);
            }
            if (by2 != string.charAt(n3)) break;
            ++n3;
            ++this._inputPtr;
        }
        this._minorState = 50;
        this._textBuffer.resetWithCopy(string, 0, n3);
        return this._finishErrorToken();
    }

    protected JsonToken _finishNonStdTokenWithEOF(int n2, int n3) throws IOException {
        String string = this._nonStdToken(n2);
        if (n3 == string.length()) {
            return this._valueNonStdNumberComplete(n2);
        }
        this._textBuffer.resetWithCopy(string, 0, n3);
        return this._finishErrorTokenWithEOF();
    }

    protected JsonToken _finishErrorToken() throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte by2;
            char c2;
            if (Character.isJavaIdentifierPart(c2 = (char)(by2 = this._inputBuffer[this._inputPtr++]))) {
                this._textBuffer.append(c2);
                if (this._textBuffer.size() < 256) continue;
            }
            return this._reportErrorToken(this._textBuffer.contentsAsString());
        }
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    protected JsonToken _finishErrorTokenWithEOF() throws IOException {
        return this._reportErrorToken(this._textBuffer.contentsAsString());
    }

    protected JsonToken _reportErrorToken(String string) throws IOException {
        this._reportError("Unrecognized token '%s': was expecting %s", this._textBuffer.contentsAsString(), "'null', 'true' or 'false'");
        return JsonToken.NOT_AVAILABLE;
    }

    protected JsonToken _startPositiveNumber(int n2) throws IOException {
        this._numberNegative = false;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = (char)n2;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(1);
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = 1;
        n2 = this._inputBuffer[this._inputPtr] & 0xFF;
        while (true) {
            if (n2 < 48) {
                if (n2 != 46) break;
                this._intLength = n3;
                ++this._inputPtr;
                return this._startFloat(cArray, n3, n2);
            }
            if (n2 > 57) {
                if (n2 != 101 && n2 != 69) break;
                this._intLength = n3;
                ++this._inputPtr;
                return this._startFloat(cArray, n3, n2);
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n3++] = (char)n2;
            if (++this._inputPtr >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n3);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            n2 = this._inputBuffer[this._inputPtr] & 0xFF;
        }
        this._intLength = n3;
        this._textBuffer.setCurrentLength(n3);
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    protected JsonToken _startNegativeNumber() throws IOException {
        int n2;
        this._numberNegative = true;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 23;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 48) {
            if (n2 == 48) {
                return this._finishNumberLeadingNegZeroes();
            }
            this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        } else if (n2 > 57) {
            if (n2 == 73) {
                return this._finishNonStdToken(3, 2);
            }
            this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = 45;
        cArray[1] = (char)n2;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(2);
            this._intLength = 1;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n2 = this._inputBuffer[this._inputPtr];
        int n3 = 2;
        while (true) {
            if (n2 < 48) {
                if (n2 != 46) break;
                this._intLength = n3 - 1;
                ++this._inputPtr;
                return this._startFloat(cArray, n3, n2);
            }
            if (n2 > 57) {
                if (n2 != 101 && n2 != 69) break;
                this._intLength = n3 - 1;
                ++this._inputPtr;
                return this._startFloat(cArray, n3, n2);
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n3++] = (char)n2;
            if (++this._inputPtr >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n3);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            n2 = this._inputBuffer[this._inputPtr] & 0xFF;
        }
        this._intLength = n3 - 1;
        this._textBuffer.setCurrentLength(n3);
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    protected JsonToken _startNumberLeadingZero() throws IOException {
        int n2;
        int n3 = this._inputPtr;
        if (n3 >= this._inputEnd) {
            this._minorState = 24;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        if ((n2 = this._inputBuffer[n3++] & 0xFF) < 48) {
            if (n2 == 46) {
                this._inputPtr = n3;
                this._intLength = 1;
                char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                cArray[0] = 48;
                return this._startFloat(cArray, 1, n2);
            }
        } else if (n2 > 57) {
            if (n2 == 101 || n2 == 69) {
                this._inputPtr = n3;
                this._intLength = 1;
                char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                cArray[0] = 48;
                return this._startFloat(cArray, 1, n2);
            }
            if (n2 != 93 && n2 != 125) {
                this.reportUnexpectedNumberChar(n2, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
            }
        } else {
            return this._finishNumberLeadingZeroes();
        }
        return this._valueCompleteInt(0, "0");
    }

    protected JsonToken _finishNumberMinus(int n2) throws IOException {
        if (n2 <= 48) {
            if (n2 == 48) {
                return this._finishNumberLeadingNegZeroes();
            }
            this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        } else if (n2 > 57) {
            if (n2 == 73) {
                return this._finishNonStdToken(3, 2);
            }
            this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = 45;
        cArray[1] = (char)n2;
        this._intLength = 1;
        return this._finishNumberIntegralPart(cArray, 2);
    }

    protected JsonToken _finishNumberLeadingZeroes() throws IOException {
        block7: {
            int n2;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 24;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48) {
                    if (n2 == 46) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 1, n2);
                    }
                    break block7;
                }
                if (n2 > 57) {
                    if (n2 == 101 || n2 == 69) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 1, n2);
                    }
                    if (n2 != 93 && n2 != 125) {
                        this.reportUnexpectedNumberChar(n2, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                    }
                    break block7;
                }
                if (this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) continue;
                this.reportInvalidNumber("Leading zeroes not allowed");
            } while (n2 == 48);
            char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
            cArray[0] = (char)n2;
            this._intLength = 1;
            return this._finishNumberIntegralPart(cArray, 1);
        }
        --this._inputPtr;
        return this._valueCompleteInt(0, "0");
    }

    protected JsonToken _finishNumberLeadingNegZeroes() throws IOException {
        block7: {
            int n2;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 25;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48) {
                    if (n2 == 46) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 45;
                        cArray[1] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 2, n2);
                    }
                    break block7;
                }
                if (n2 > 57) {
                    if (n2 == 101 || n2 == 69) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 45;
                        cArray[1] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 2, n2);
                    }
                    if (n2 != 93 && n2 != 125) {
                        this.reportUnexpectedNumberChar(n2, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                    }
                    break block7;
                }
                if (this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) continue;
                this.reportInvalidNumber("Leading zeroes not allowed");
            } while (n2 == 48);
            char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
            cArray[0] = 45;
            cArray[1] = (char)n2;
            this._intLength = 1;
            return this._finishNumberIntegralPart(cArray, 2);
        }
        --this._inputPtr;
        return this._valueCompleteInt(0, "0");
    }

    protected JsonToken _finishNumberIntegralPart(char[] cArray, int n2) throws IOException {
        int n3;
        int n4 = n3 = this._numberNegative ? -1 : 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n5 = this._inputBuffer[this._inputPtr] & 0xFF;
            if (n5 < 48) {
                if (n5 != 46) break;
                this._intLength = n2 + n3;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n5);
            }
            if (n5 > 57) {
                if (n5 != 101 && n5 != 69) break;
                this._intLength = n2 + n3;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n5);
            }
            ++this._inputPtr;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = (char)n5;
        }
        this._intLength = n2 + n3;
        this._textBuffer.setCurrentLength(n2);
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    protected JsonToken _startFloat(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 0;
        if (n3 == 46) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = 46;
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n2);
                    this._minorState = 30;
                    this._fractLength = n4;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((n3 = this._inputBuffer[this._inputPtr++]) < 48 || n3 > 57) {
                    n3 &= 0xFF;
                    if (n4 != 0) break;
                    this.reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
                    break;
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n2++] = (char)n3;
                ++n4;
            }
        }
        this._fractLength = n4;
        int n5 = 0;
        if (n3 == 101 || n3 == 69) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = (char)n3;
            if (this._inputPtr >= this._inputEnd) {
                this._textBuffer.setCurrentLength(n2);
                this._minorState = 31;
                this._expLength = 0;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n3 = this._inputBuffer[this._inputPtr++]) == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n2);
                    this._minorState = 32;
                    this._expLength = 0;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                n3 = this._inputBuffer[this._inputPtr++];
            }
            while (n3 >= 48 && n3 <= 57) {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n2);
                    this._minorState = 32;
                    this._expLength = n5;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                n3 = this._inputBuffer[this._inputPtr++];
            }
            n3 &= 0xFF;
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        this._expLength = n5;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected JsonToken _finishFloatFraction() throws IOException {
        byte by2;
        int n2 = this._fractLength;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        while ((by2 = this._inputBuffer[this._inputPtr++]) >= 48 && by2 <= 57) {
            ++n2;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n3++] = (char)by2;
            if (this._inputPtr < this._inputEnd) continue;
            this._textBuffer.setCurrentLength(n3);
            this._fractLength = n2;
            return JsonToken.NOT_AVAILABLE;
        }
        if (n2 == 0) {
            this.reportUnexpectedNumberChar(by2, "Decimal point not followed by a digit");
        }
        this._fractLength = n2;
        this._textBuffer.setCurrentLength(n3);
        if (by2 == 101 || by2 == 69) {
            this._textBuffer.append((char)by2);
            this._expLength = 0;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 31;
                return JsonToken.NOT_AVAILABLE;
            }
            this._minorState = 32;
            return this._finishFloatExponent(true, this._inputBuffer[this._inputPtr++] & 0xFF);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        this._expLength = 0;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected JsonToken _finishFloatExponent(boolean bl2, int n2) throws IOException {
        if (bl2) {
            this._minorState = 32;
            if (n2 == 45 || n2 == 43) {
                this._textBuffer.append((char)n2);
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 32;
                    this._expLength = 0;
                    return JsonToken.NOT_AVAILABLE;
                }
                n2 = this._inputBuffer[this._inputPtr++];
            }
        }
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        int n4 = this._expLength;
        while (n2 >= 48 && n2 <= 57) {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n3++] = (char)n2;
            if (this._inputPtr >= this._inputEnd) {
                this._textBuffer.setCurrentLength(n3);
                this._expLength = n4;
                return JsonToken.NOT_AVAILABLE;
            }
            n2 = this._inputBuffer[this._inputPtr++];
        }
        n2 &= 0xFF;
        if (n4 == 0) {
            this.reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        this._expLength = n4;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    private final String _fastParseName() throws IOException {
        int n2;
        byte[] byArray = this._inputBuffer;
        int[] nArray = _icLatin1;
        int n3 = this._inputPtr;
        if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
            int n4;
            if (nArray[n4 = byArray[n3++] & 0xFF] == 0) {
                int n5 = n2 << 8 | n4;
                if (nArray[n4 = byArray[n3++] & 0xFF] == 0) {
                    n5 = n5 << 8 | n4;
                    if (nArray[n4 = byArray[n3++] & 0xFF] == 0) {
                        n5 = n5 << 8 | n4;
                        if (nArray[n4 = byArray[n3++] & 0xFF] == 0) {
                            this._quad1 = n5;
                            return this._parseMediumName(n3, n4);
                        }
                        if (n4 == 34) {
                            this._inputPtr = n3;
                            return this._findName(n5, 4);
                        }
                        return null;
                    }
                    if (n4 == 34) {
                        this._inputPtr = n3;
                        return this._findName(n5, 3);
                    }
                    return null;
                }
                if (n4 == 34) {
                    this._inputPtr = n3;
                    return this._findName(n5, 2);
                }
                return null;
            }
            if (n4 == 34) {
                this._inputPtr = n3;
                return this._findName(n2, 1);
            }
            return null;
        }
        if (n2 == 34) {
            this._inputPtr = n3;
            return "";
        }
        return null;
    }

    private final String _parseMediumName(int n2, int n3) throws IOException {
        int n4;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n4 = byArray[n2++] & 0xFF] == 0) {
            n3 = n3 << 8 | n4;
            if (nArray[n4 = byArray[n2++] & 0xFF] == 0) {
                n3 = n3 << 8 | n4;
                if (nArray[n4 = byArray[n2++] & 0xFF] == 0) {
                    n3 = n3 << 8 | n4;
                    if (nArray[n4 = byArray[n2++] & 0xFF] == 0) {
                        return this._parseMediumName2(n2, n4, n3);
                    }
                    if (n4 == 34) {
                        this._inputPtr = n2;
                        return this._findName(this._quad1, n3, 4);
                    }
                    return null;
                }
                if (n4 == 34) {
                    this._inputPtr = n2;
                    return this._findName(this._quad1, n3, 3);
                }
                return null;
            }
            if (n4 == 34) {
                this._inputPtr = n2;
                return this._findName(this._quad1, n3, 2);
            }
            return null;
        }
        if (n4 == 34) {
            this._inputPtr = n2;
            return this._findName(this._quad1, n3, 1);
        }
        return null;
    }

    private final String _parseMediumName2(int n2, int n3, int n4) throws IOException {
        int n5;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n5 = byArray[n2++] & 0xFF] != 0) {
            if (n5 == 34) {
                this._inputPtr = n2;
                return this._findName(this._quad1, n4, n3, 1);
            }
            return null;
        }
        n3 = n3 << 8 | n5;
        if (nArray[n5 = byArray[n2++] & 0xFF] != 0) {
            if (n5 == 34) {
                this._inputPtr = n2;
                return this._findName(this._quad1, n4, n3, 2);
            }
            return null;
        }
        n3 = n3 << 8 | n5;
        if (nArray[n5 = byArray[n2++] & 0xFF] != 0) {
            if (n5 == 34) {
                this._inputPtr = n2;
                return this._findName(this._quad1, n4, n3, 3);
            }
            return null;
        }
        n3 = n3 << 8 | n5;
        if ((n5 = byArray[n2++] & 0xFF) == 34) {
            this._inputPtr = n2;
            return this._findName(this._quad1, n4, n3, 4);
        }
        return null;
    }

    private final JsonToken _parseEscapedName(int n2, int n3, int n4) throws IOException {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = _icLatin1;
        while (true) {
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n2;
                this._pending32 = n3;
                this._pendingBytes = n4;
                this._minorState = 7;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (nArray2[n5 = this._inputBuffer[this._inputPtr++] & 0xFF] == 0) {
                if (n4 < 4) {
                    ++n4;
                    n3 = n3 << 8 | n5;
                    continue;
                }
                if (n2 >= nArray.length) {
                    this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n2++] = n3;
                n3 = n5;
                n4 = 1;
                continue;
            }
            if (n5 == 34) break;
            if (n5 != 92) {
                this._throwUnquotedSpace(n5, "name");
            } else {
                n5 = this._decodeCharEscape();
                if (n5 < 0) {
                    this._minorState = 8;
                    this._minorStateAfterSplit = 7;
                    this._quadLength = n2;
                    this._pending32 = n3;
                    this._pendingBytes = n4;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
            }
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            if (n5 > 127) {
                if (n4 >= 4) {
                    nArray[n2++] = n3;
                    n3 = 0;
                    n4 = 0;
                }
                if (n5 < 2048) {
                    n3 = n3 << 8 | (0xC0 | n5 >> 6);
                    ++n4;
                } else {
                    n3 = n3 << 8 | (0xE0 | n5 >> 12);
                    if (++n4 >= 4) {
                        nArray[n2++] = n3;
                        n3 = 0;
                        n4 = 0;
                    }
                    n3 = n3 << 8 | (0x80 | n5 >> 6 & 0x3F);
                    ++n4;
                }
                n5 = 0x80 | n5 & 0x3F;
            }
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n5;
                continue;
            }
            nArray[n2++] = n3;
            n3 = n5;
            n4 = 1;
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = NonBlockingJsonParser._padLastQuad(n3, n4);
        } else if (n2 == 0) {
            return this._fieldComplete("");
        }
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            string = this._addName(nArray, n2, n4);
        }
        return this._fieldComplete(string);
    }

    private JsonToken _handleOddName(int n2) throws IOException {
        int[] nArray;
        switch (n2) {
            case 35: {
                if (!JsonParser.Feature.ALLOW_YAML_COMMENTS.enabledIn(this._features)) break;
                return this._finishHashComment(4);
            }
            case 47: {
                return this._startSlashComment(4);
            }
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._finishAposName(0, 0, 0);
            }
            case 93: {
                return this._closeArrayScope();
            }
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            char c2 = (char)n2;
            this._reportUnexpectedChar(c2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        return this._finishUnquotedName(0, n2, 1);
    }

    private JsonToken _finishUnquotedName(int n2, int n3, int n4) throws IOException {
        String string;
        int[] nArray = this._quadBuffer;
        int[] nArray2 = CharTypes.getInputCodeUtf8JsNames();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n2;
                this._pending32 = n3;
                this._pendingBytes = n4;
                this._minorState = 10;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n5 = this._inputBuffer[this._inputPtr] & 0xFF;
            if (nArray2[n5] != 0) break;
            ++this._inputPtr;
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n5;
                continue;
            }
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = n3;
            n3 = n5;
            n4 = 1;
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = n3;
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this._addName(nArray, n2, n4);
        }
        return this._fieldComplete(string);
    }

    private JsonToken _finishAposName(int n2, int n3, int n4) throws IOException {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = _icLatin1;
        while (true) {
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n2;
                this._pending32 = n3;
                this._pendingBytes = n4;
                this._minorState = 9;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n5 = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) break;
            if (n5 != 34 && nArray2[n5] != 0) {
                if (n5 != 92) {
                    this._throwUnquotedSpace(n5, "name");
                } else {
                    n5 = this._decodeCharEscape();
                    if (n5 < 0) {
                        this._minorState = 8;
                        this._minorStateAfterSplit = 9;
                        this._quadLength = n2;
                        this._pending32 = n3;
                        this._pendingBytes = n4;
                        this._currToken = JsonToken.NOT_AVAILABLE;
                        return this._currToken;
                    }
                }
                if (n5 > 127) {
                    if (n4 >= 4) {
                        if (n2 >= nArray.length) {
                            this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n4 = 0;
                    }
                    if (n5 < 2048) {
                        n3 = n3 << 8 | (0xC0 | n5 >> 6);
                        ++n4;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n5 >> 12);
                        if (++n4 >= 4) {
                            if (n2 >= nArray.length) {
                                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n4 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n5 >> 6 & 0x3F);
                        ++n4;
                    }
                    n5 = 0x80 | n5 & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n5;
                continue;
            }
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = n3;
            n3 = n5;
            n4 = 1;
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = NonBlockingJsonParser._padLastQuad(n3, n4);
        } else if (n2 == 0) {
            return this._fieldComplete("");
        }
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            string = this._addName(nArray, n2, n4);
        }
        return this._fieldComplete(string);
    }

    protected final JsonToken _finishFieldWithEscape() throws IOException {
        int n2 = this._decodeSplitEscaped(this._quoted32, this._quotedDigits);
        if (n2 < 0) {
            this._minorState = 8;
            return JsonToken.NOT_AVAILABLE;
        }
        if (this._quadLength >= this._quadBuffer.length) {
            this._quadBuffer = NonBlockingJsonParser.growArrayBy(this._quadBuffer, 32);
        }
        int n3 = this._pending32;
        int n4 = this._pendingBytes;
        if (n2 > 127) {
            if (n4 >= 4) {
                this._quadBuffer[this._quadLength++] = n3;
                n3 = 0;
                n4 = 0;
            }
            if (n2 < 2048) {
                n3 = n3 << 8 | (0xC0 | n2 >> 6);
                ++n4;
            } else {
                n3 = n3 << 8 | (0xE0 | n2 >> 12);
                if (++n4 >= 4) {
                    this._quadBuffer[this._quadLength++] = n3;
                    n3 = 0;
                    n4 = 0;
                }
                n3 = n3 << 8 | (0x80 | n2 >> 6 & 0x3F);
                ++n4;
            }
            n2 = 0x80 | n2 & 0x3F;
        }
        if (n4 < 4) {
            ++n4;
            n3 = n3 << 8 | n2;
        } else {
            this._quadBuffer[this._quadLength++] = n3;
            n3 = n2;
            n4 = 1;
        }
        if (this._minorStateAfterSplit == 9) {
            return this._finishAposName(this._quadLength, n3, n4);
        }
        return this._parseEscapedName(this._quadLength, n3, n4);
    }

    private int _decodeSplitEscaped(int n2, int n3) throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._quoted32 = n2;
            this._quotedDigits = n3;
            return -1;
        }
        int n4 = this._inputBuffer[this._inputPtr++];
        if (n3 == -1) {
            switch (n4) {
                case 98: {
                    return 8;
                }
                case 116: {
                    return 9;
                }
                case 110: {
                    return 10;
                }
                case 102: {
                    return 12;
                }
                case 114: {
                    return 13;
                }
                case 34: 
                case 47: 
                case 92: {
                    return n4;
                }
                case 117: {
                    break;
                }
                default: {
                    char c2 = (char)n4;
                    return this._handleUnrecognizedCharacterEscape(c2);
                }
            }
            if (this._inputPtr >= this._inputEnd) {
                this._quotedDigits = 0;
                this._quoted32 = 0;
                return -1;
            }
            n4 = this._inputBuffer[this._inputPtr++];
            n3 = 0;
        }
        n4 &= 0xFF;
        while (true) {
            int n5;
            if ((n5 = CharTypes.charToHex(n4)) < 0) {
                this._reportUnexpectedChar(n4, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n5;
            if (++n3 == 4) {
                return n2;
            }
            if (this._inputPtr >= this._inputEnd) {
                this._quotedDigits = n3;
                this._quoted32 = n2;
                return -1;
            }
            n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
    }

    protected JsonToken _startString() throws IOException {
        int n2;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        for (n2 = this._inputPtr; n2 < n4; ++n2) {
            int n5 = byArray[n2] & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                this._textBuffer.setCurrentLength(n3);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            cArray[n3++] = (char)n5;
        }
        this._textBuffer.setCurrentLength(n3);
        this._inputPtr = n2;
        return this._finishRegularString();
    }

    private final JsonToken _finishRegularString() throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int n3 = this._inputPtr;
        int n4 = this._inputEnd - 5;
        block6: while (true) {
            int n5;
            if (n3 >= this._inputEnd) {
                this._inputPtr = n3;
                this._minorState = 40;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n6 = Math.min(this._inputEnd, n3 + (cArray.length - n2));
            while (true) {
                if (n3 >= n6) continue block6;
                if (nArray[n5 = byArray[n3++] & 0xFF] != 0) break;
                cArray[n2++] = (char)n5;
            }
            if (n5 == 34) {
                this._inputPtr = n3;
                this._textBuffer.setCurrentLength(n2);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            if (n3 >= n4) {
                this._inputPtr = n3;
                this._textBuffer.setCurrentLength(n2);
                if (!this._decodeSplitMultiByte(n5, nArray[n5], n3 < this._inputEnd)) {
                    this._minorStateAfterSplit = 40;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                cArray = this._textBuffer.getBufferWithoutReset();
                n2 = this._textBuffer.getCurrentSegmentSize();
                n3 = this._inputPtr;
                continue;
            }
            switch (nArray[n5]) {
                case 1: {
                    this._inputPtr = n3;
                    n5 = this._decodeFastCharEscape();
                    n3 = this._inputPtr;
                    break;
                }
                case 2: {
                    n5 = this._decodeUTF8_2(n5, this._inputBuffer[n3++]);
                    break;
                }
                case 3: {
                    n5 = this._decodeUTF8_3(n5, this._inputBuffer[n3++], this._inputBuffer[n3++]);
                    break;
                }
                case 4: {
                    n5 = this._decodeUTF8_4(n5, this._inputBuffer[n3++], this._inputBuffer[n3++], this._inputBuffer[n3++]);
                    cArray[n2++] = (char)(0xD800 | n5 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n5 = 0xDC00 | n5 & 0x3FF;
                    break;
                }
                default: {
                    if (n5 < 32) {
                        this._throwUnquotedSpace(n5, "string value");
                        break;
                    }
                    this._reportInvalidChar(n5);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n5;
        }
    }

    protected JsonToken _startAposString() throws IOException {
        int n2;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        for (n2 = this._inputPtr; n2 < n4; ++n2) {
            int n5 = byArray[n2] & 0xFF;
            if (n5 == 39) {
                this._inputPtr = n2 + 1;
                this._textBuffer.setCurrentLength(n3);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            if (nArray[n5] != 0) break;
            cArray[n3++] = (char)n5;
        }
        this._textBuffer.setCurrentLength(n3);
        this._inputPtr = n2;
        return this._finishAposString();
    }

    private final JsonToken _finishAposString() throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int n3 = this._inputPtr;
        int n4 = this._inputEnd - 5;
        block6: while (true) {
            int n5;
            if (n3 >= this._inputEnd) {
                this._inputPtr = n3;
                this._minorState = 45;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n6 = Math.min(this._inputEnd, n3 + (cArray.length - n2));
            while (true) {
                if (n3 >= n6) continue block6;
                if (nArray[n5 = byArray[n3++] & 0xFF] != 0 && n5 != 34) break;
                if (n5 == 39) {
                    this._inputPtr = n3;
                    this._textBuffer.setCurrentLength(n2);
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                cArray[n2++] = (char)n5;
            }
            if (n3 >= n4) {
                this._inputPtr = n3;
                this._textBuffer.setCurrentLength(n2);
                if (!this._decodeSplitMultiByte(n5, nArray[n5], n3 < this._inputEnd)) {
                    this._minorStateAfterSplit = 45;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                cArray = this._textBuffer.getBufferWithoutReset();
                n2 = this._textBuffer.getCurrentSegmentSize();
                n3 = this._inputPtr;
                continue;
            }
            switch (nArray[n5]) {
                case 1: {
                    this._inputPtr = n3;
                    n5 = this._decodeFastCharEscape();
                    n3 = this._inputPtr;
                    break;
                }
                case 2: {
                    n5 = this._decodeUTF8_2(n5, this._inputBuffer[n3++]);
                    break;
                }
                case 3: {
                    n5 = this._decodeUTF8_3(n5, this._inputBuffer[n3++], this._inputBuffer[n3++]);
                    break;
                }
                case 4: {
                    n5 = this._decodeUTF8_4(n5, this._inputBuffer[n3++], this._inputBuffer[n3++], this._inputBuffer[n3++]);
                    cArray[n2++] = (char)(0xD800 | n5 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n5 = 0xDC00 | n5 & 0x3FF;
                    break;
                }
                default: {
                    if (n5 < 32) {
                        this._throwUnquotedSpace(n5, "string value");
                        break;
                    }
                    this._reportInvalidChar(n5);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n5;
        }
    }

    private final boolean _decodeSplitMultiByte(int n2, int n3, boolean bl2) throws IOException {
        switch (n3) {
            case 1: {
                n2 = this._decodeSplitEscaped(0, -1);
                if (n2 < 0) {
                    this._minorState = 41;
                    return false;
                }
                this._textBuffer.append((char)n2);
                return true;
            }
            case 2: {
                if (bl2) {
                    n2 = this._decodeUTF8_2(n2, this._inputBuffer[this._inputPtr++]);
                    this._textBuffer.append((char)n2);
                    return true;
                }
                this._minorState = 42;
                this._pending32 = n2;
                return false;
            }
            case 3: {
                n2 &= 0xF;
                if (bl2) {
                    return this._decodeSplitUTF8_3(n2, 1, this._inputBuffer[this._inputPtr++]);
                }
                this._minorState = 43;
                this._pending32 = n2;
                this._pendingBytes = 1;
                return false;
            }
            case 4: {
                n2 &= 7;
                if (bl2) {
                    return this._decodeSplitUTF8_4(n2, 1, this._inputBuffer[this._inputPtr++]);
                }
                this._pending32 = n2;
                this._pendingBytes = 1;
                this._minorState = 44;
                return false;
            }
        }
        if (n2 < 32) {
            this._throwUnquotedSpace(n2, "string value");
        } else {
            this._reportInvalidChar(n2);
        }
        this._textBuffer.append((char)n2);
        return true;
    }

    private final boolean _decodeSplitUTF8_3(int n2, int n3, int n4) throws IOException {
        if (n3 == 1) {
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 43;
                this._pending32 = n2;
                this._pendingBytes = 2;
                return false;
            }
            n4 = this._inputBuffer[this._inputPtr++];
        }
        if ((n4 & 0xC0) != 128) {
            this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
        }
        this._textBuffer.append((char)(n2 << 6 | n4 & 0x3F));
        return true;
    }

    private final boolean _decodeSplitUTF8_4(int n2, int n3, int n4) throws IOException {
        if (n3 == 1) {
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 44;
                this._pending32 = n2;
                this._pendingBytes = 2;
                return false;
            }
            n3 = 2;
            n4 = this._inputBuffer[this._inputPtr++];
        }
        if (n3 == 2) {
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 44;
                this._pending32 = n2;
                this._pendingBytes = 3;
                return false;
            }
            n4 = this._inputBuffer[this._inputPtr++];
        }
        if ((n4 & 0xC0) != 128) {
            this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
        }
        int n5 = (n2 << 6 | n4 & 0x3F) - 65536;
        this._textBuffer.append((char)(0xD800 | n5 >> 10));
        n5 = 0xDC00 | n5 & 0x3FF;
        this._textBuffer.append((char)n5);
        return true;
    }

    private final int _decodeCharEscape() throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 < 5) {
            return this._decodeSplitEscaped(0, -1);
        }
        return this._decodeFastCharEscape();
    }

    private final int _decodeFastCharEscape() throws IOException {
        int n2;
        byte by2 = this._inputBuffer[this._inputPtr++];
        switch (by2) {
            case 98: {
                return 8;
            }
            case 116: {
                return 9;
            }
            case 110: {
                return 10;
            }
            case 102: {
                return 12;
            }
            case 114: {
                return 13;
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by2;
            }
            case 117: {
                break;
            }
            default: {
                char c2 = (char)by2;
                return this._handleUnrecognizedCharacterEscape(c2);
            }
        }
        byte by3 = this._inputBuffer[this._inputPtr++];
        int n3 = n2 = CharTypes.charToHex(by3);
        if (n2 >= 0 && (n2 = CharTypes.charToHex(by3 = this._inputBuffer[this._inputPtr++])) >= 0) {
            n3 = n3 << 4 | n2;
            if ((n2 = CharTypes.charToHex(by3 = this._inputBuffer[this._inputPtr++])) >= 0) {
                n3 = n3 << 4 | n2;
                if ((n2 = CharTypes.charToHex(by3 = this._inputBuffer[this._inputPtr++])) >= 0) {
                    return n3 << 4 | n2;
                }
            }
        }
        this._reportUnexpectedChar(by3 & 0xFF, "expected a hex-digit for character escape sequence");
        return -1;
    }

    private final int _decodeUTF8_2(int n2, int n3) throws IOException {
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | n3 & 0x3F;
    }

    private final int _decodeUTF8_3(int n2, int n3, int n4) throws IOException {
        n2 &= 0xF;
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        if ((n4 & 0xC0) != 128) {
            this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
        }
        return n2 << 6 | n4 & 0x3F;
    }

    private final int _decodeUTF8_4(int n2, int n3, int n4, int n5) throws IOException {
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        n2 = (n2 & 7) << 6 | n3 & 0x3F;
        if ((n4 & 0xC0) != 128) {
            this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | n4 & 0x3F;
        if ((n5 & 0xC0) != 128) {
            this._reportInvalidOther(n5 & 0xFF, this._inputPtr);
        }
        return (n2 << 6 | n5 & 0x3F) - 65536;
    }
}

