/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core.sym;

import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;
import zz.com.fasterxml.jackson.core.JsonFactory;
import zz.com.fasterxml.jackson.core.util.InternCache;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 100;
    private final CharsToNameCanonicalizer _parent;
    private final AtomicReference<TableInfo> _tableInfo;
    private final int _seed;
    private final int _flags;
    private boolean _canonicalize;
    private String[] _symbols;
    private Bucket[] _buckets;
    private int _size;
    private int _sizeThreshold;
    private int _indexMask;
    private int _longestCollisionList;
    private boolean _hashShared;
    private BitSet _overflows;

    private CharsToNameCanonicalizer(int n2) {
        this._parent = null;
        this._seed = n2;
        this._canonicalize = true;
        this._flags = -1;
        this._hashShared = false;
        this._longestCollisionList = 0;
        this._tableInfo = new AtomicReference<TableInfo>(TableInfo.createInitial(64));
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, int n2, int n3, TableInfo tableInfo) {
        this._parent = charsToNameCanonicalizer;
        this._seed = n3;
        this._tableInfo = null;
        this._flags = n2;
        this._canonicalize = JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        this._symbols = tableInfo.symbols;
        this._buckets = tableInfo.buckets;
        this._size = tableInfo.size;
        this._longestCollisionList = tableInfo.longestCollisionList;
        int n4 = this._symbols.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        this._indexMask = n4 - 1;
        this._hashShared = true;
    }

    private static int _thresholdSize(int n2) {
        return n2 - (n2 >> 2);
    }

    public static CharsToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        int n2 = (int)l2 + (int)(l2 >>> 32) | 1;
        return CharsToNameCanonicalizer.createRoot(n2);
    }

    protected static CharsToNameCanonicalizer createRoot(int n2) {
        return new CharsToNameCanonicalizer(n2);
    }

    public CharsToNameCanonicalizer makeChild(int n2) {
        return new CharsToNameCanonicalizer(this, n2, this._seed, this._tableInfo.get());
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(new TableInfo(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(TableInfo tableInfo) {
        int n2 = tableInfo.size;
        TableInfo tableInfo2 = this._tableInfo.get();
        if (n2 == tableInfo2.size) {
            return;
        }
        if (n2 > 12000) {
            tableInfo = TableInfo.createInitial(64);
        }
        this._tableInfo.compareAndSet(tableInfo2, tableInfo);
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().size;
        }
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return !this._hashShared;
    }

    public int hashSeed() {
        return this._seed;
    }

    public int collisionCount() {
        int n2 = 0;
        for (Bucket bucket : this._buckets) {
            if (bucket == null) continue;
            n2 += bucket.length;
        }
        return n2;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public String findSymbol(char[] cArray, int n2, int n3, int n4) {
        if (n3 < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string = this._symbols[n5];
        if (string != null) {
            Bucket bucket;
            if (string.length() == n3) {
                int n6 = 0;
                while (string.charAt(n6) == cArray[n2 + n6]) {
                    if (++n6 != n3) continue;
                    return string;
                }
            }
            if ((bucket = this._buckets[n5 >> 1]) != null) {
                string = bucket.has(cArray, n2, n3);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n2, n3, bucket.next);
                if (string != null) {
                    return string;
                }
            }
        }
        return this._addSymbol(cArray, n2, n3, n4, n5);
    }

    private String _findSymbol2(char[] cArray, int n2, int n3, Bucket bucket) {
        while (bucket != null) {
            String string = bucket.has(cArray, n2, n3);
            if (string != null) {
                return string;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private String _addSymbol(char[] cArray, int n2, int n3, int n4, int n5) {
        if (this._hashShared) {
            this.copyArrays();
            this._hashShared = false;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n5 = this._hashToIndex(this.calcHash(cArray, n2, n3));
        }
        String string = new String(cArray, n2, n3);
        if (JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            string = InternCache.instance.intern(string);
        }
        ++this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = string;
        } else {
            int n6 = n5 >> 1;
            Bucket bucket = new Bucket(string, this._buckets[n6]);
            int n7 = bucket.length;
            if (n7 > 100) {
                this._handleSpillOverflow(n6, bucket);
            } else {
                this._buckets[n6] = bucket;
                this._longestCollisionList = Math.max(n7, this._longestCollisionList);
            }
        }
        return string;
    }

    private void _handleSpillOverflow(int n2, Bucket bucket) {
        if (this._overflows == null) {
            this._overflows = new BitSet();
            this._overflows.set(n2);
        } else if (this._overflows.get(n2)) {
            if (JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this.reportTooManyCollisions(100);
            }
            this._canonicalize = false;
        } else {
            this._overflows.set(n2);
        }
        this._symbols[n2 + n2] = bucket.symbol;
        this._buckets[n2] = null;
        this._size -= bucket.length;
        this._longestCollisionList = -1;
    }

    public int _hashToIndex(int n2) {
        n2 += n2 >>> 15;
        n2 ^= n2 << 7;
        n2 += n2 >>> 3;
        return n2 & this._indexMask;
    }

    public int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._seed;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            n4 = n4 * 33 + cArray[i2];
        }
        return n4 == 0 ? 1 : n4;
    }

    public int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._seed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        return n3 == 0 ? 1 : n3;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        this._symbols = Arrays.copyOf(stringArray, stringArray.length);
        Bucket[] bucketArray = this._buckets;
        this._buckets = Arrays.copyOf(bucketArray, bucketArray.length);
    }

    private void rehash() {
        int n2;
        Object object;
        int n3;
        int n4 = this._symbols.length;
        int n5 = n4 + n4;
        if (n5 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new Bucket[32];
            this._indexMask = 63;
            this._hashShared = false;
            return;
        }
        String[] stringArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new String[n5];
        this._buckets = new Bucket[n5 >> 1];
        this._indexMask = n5 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            Bucket bucket;
            object = stringArray[n3];
            if (object == null) continue;
            ++n6;
            int n8 = this._hashToIndex(this.calcHash((String)object));
            if (this._symbols[n8] == null) {
                this._symbols[n8] = object;
                continue;
            }
            n2 = n8 >> 1;
            this._buckets[n2] = bucket = new Bucket((String)object, this._buckets[n2]);
            n7 = Math.max(n7, bucket.length);
        }
        n4 >>= 1;
        for (n3 = 0; n3 < n4; ++n3) {
            object = bucketArray[n3];
            while (object != null) {
                ++n6;
                String string = ((Bucket)object).symbol;
                n2 = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n2] == null) {
                    this._symbols[n2] = string;
                } else {
                    Bucket bucket;
                    int n9 = n2 >> 1;
                    this._buckets[n9] = bucket = new Bucket(string, this._buckets[n9]);
                    n7 = Math.max(n7, bucket.length);
                }
                object = ((Bucket)object).next;
            }
        }
        this._longestCollisionList = n7;
        this._overflows = null;
        if (n6 != this._size) {
            throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", this._size, n6));
        }
    }

    protected void reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    private static final class TableInfo {
        final int size;
        final int longestCollisionList;
        final String[] symbols;
        final Bucket[] buckets;

        public TableInfo(int n2, int n3, String[] stringArray, Bucket[] bucketArray) {
            this.size = n2;
            this.longestCollisionList = n3;
            this.symbols = stringArray;
            this.buckets = bucketArray;
        }

        public TableInfo(CharsToNameCanonicalizer charsToNameCanonicalizer) {
            this.size = charsToNameCanonicalizer._size;
            this.longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
            this.symbols = charsToNameCanonicalizer._symbols;
            this.buckets = charsToNameCanonicalizer._buckets;
        }

        public static TableInfo createInitial(int n2) {
            return new TableInfo(0, 0, new String[n2], new Bucket[n2 >> 1]);
        }
    }

    static final class Bucket {
        public final String symbol;
        public final Bucket next;
        public final int length;

        public Bucket(String string, Bucket bucket) {
            this.symbol = string;
            this.next = bucket;
            this.length = bucket == null ? 1 : bucket.length + 1;
        }

        public String has(char[] cArray, int n2, int n3) {
            if (this.symbol.length() != n3) {
                return null;
            }
            int n4 = 0;
            do {
                if (this.symbol.charAt(n4) == cArray[n2 + n4]) continue;
                return null;
            } while (++n4 < n3);
            return this.symbol;
        }
    }
}

