/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.core.util;

import java.lang.ref.SoftReference;
import zz.com.fasterxml.jackson.core.io.JsonStringEncoder;
import zz.com.fasterxml.jackson.core.util.BufferRecycler;

public class BufferRecyclers {
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _encoderRef = new ThreadLocal();

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler bufferRecycler;
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        BufferRecycler bufferRecycler2 = bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        }
        return bufferRecycler;
    }

    public static JsonStringEncoder getJsonStringEncoder() {
        JsonStringEncoder jsonStringEncoder;
        SoftReference<JsonStringEncoder> softReference = _encoderRef.get();
        JsonStringEncoder jsonStringEncoder2 = jsonStringEncoder = softReference == null ? null : softReference.get();
        if (jsonStringEncoder == null) {
            jsonStringEncoder = new JsonStringEncoder();
            _encoderRef.set(new SoftReference<JsonStringEncoder>(jsonStringEncoder));
        }
        return jsonStringEncoder;
    }

    public static byte[] encodeAsUTF8(String string) {
        return BufferRecyclers.getJsonStringEncoder().encodeAsUTF8(string);
    }

    public static char[] quoteAsJsonText(String string) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsString(string);
    }

    public static void quoteAsJsonText(CharSequence charSequence, StringBuilder stringBuilder) {
        BufferRecyclers.getJsonStringEncoder().quoteAsString(charSequence, stringBuilder);
    }

    public static byte[] quoteAsJsonUTF8(String string) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsUTF8(string);
    }
}

