/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import zz.com.fasterxml.jackson.annotation.ObjectIdResolver;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.Annotated;
import zz.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.Converter;

public abstract class DatabindContext {
    private static final int MAX_ERROR_STR_LEN = 500;

    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public abstract boolean isEnabled(MapperFeature var1);

    public abstract boolean canOverrideAccessModifiers();

    public abstract Class<?> getActiveView();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        if (type == null) {
            return null;
        }
        return this.getTypeFactory().constructType(type);
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (javaType.getRawClass() == clazz) {
            return javaType;
        }
        return this.getConfig().constructSpecializedType(javaType, clazz);
    }

    public JavaType resolveSubType(JavaType javaType, String string) throws JsonMappingException {
        if (string.indexOf(60) > 0) {
            JavaType javaType2 = this.getTypeFactory().constructFromCanonical(string);
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
        } else {
            Class<?> clazz;
            try {
                clazz = this.getTypeFactory().findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (Exception exception) {
                throw this.invalidTypeIdException(javaType, string, String.format("problem: (%s) %s", exception.getClass().getName(), exception.getMessage()));
            }
            if (javaType.isTypeOrSuperTypeOf(clazz)) {
                return this.getTypeFactory().constructSpecializedType(javaType, clazz);
            }
        }
        throw this.invalidTypeIdException(javaType, string, "Not a subtype");
    }

    protected abstract JsonMappingException invalidTypeIdException(JavaType var1, String var2, String var3);

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) throws JsonMappingException {
        ObjectIdGenerator<?> objectIdGenerator;
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator2 = objectIdGenerator = handlerInstantiator == null ? null : handlerInstantiator.objectIdGeneratorInstance(mapperConfig, annotated, clazz);
        if (objectIdGenerator == null) {
            objectIdGenerator = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    public ObjectIdResolver objectIdResolverInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        ObjectIdResolver objectIdResolver;
        Class<? extends ObjectIdResolver> clazz = objectIdInfo.getResolverType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        ObjectIdResolver objectIdResolver2 = objectIdResolver = handlerInstantiator == null ? null : handlerInstantiator.resolverIdGeneratorInstance(mapperConfig, annotated, clazz);
        if (objectIdResolver == null) {
            objectIdResolver = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdResolver;
    }

    public Converter<Object, Object> converterInstance(Annotated annotated, Object object) throws JsonMappingException {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz = (Class)object;
        if (clazz == Converter.None.class || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(mapperConfig, annotated, clazz);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return converter;
    }

    public abstract <T> T reportBadDefinition(JavaType var1, String var2) throws JsonMappingException;

    public <T> T reportBadDefinition(Class<?> clazz, String string) throws JsonMappingException {
        return this.reportBadDefinition(this.constructType(clazz), string);
    }

    protected final String _format(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            return String.format(string, objectArray);
        }
        return string;
    }

    protected final String _truncate(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 500) {
            return string;
        }
        return string.substring(0, 500) + "]...[" + string.substring(string.length() - 500);
    }

    protected String _quotedString(String string) {
        if (string == null) {
            return "[N/A]";
        }
        return String.format("\"%s\"", this._truncate(string));
    }

    protected String _colonConcat(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        return string + ": " + string2;
    }

    protected String _desc(String string) {
        if (string == null) {
            return "[N/A]";
        }
        return this._truncate(string);
    }
}

