/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.Serializable;
import java.util.Collection;
import zz.com.fasterxml.jackson.core.FormatFeature;
import zz.com.fasterxml.jackson.core.JsonFactory;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.cfg.BaseSettings;
import zz.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import zz.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import zz.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import zz.com.fasterxml.jackson.databind.jsontype.NamedType;
import zz.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import zz.com.fasterxml.jackson.databind.util.LinkedNode;
import zz.com.fasterxml.jackson.databind.util.RootNameLookup;

public final class DeserializationConfig
extends MapperConfigBase<DeserializationFeature, DeserializationConfig>
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected final LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected final JsonNodeFactory _nodeFactory;
    protected final int _deserFeatures;
    protected final int _parserFeatures;
    protected final int _parserFeaturesToChange;
    protected final int _formatReadFeatures;
    protected final int _formatReadFeaturesToChange;

    public DeserializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._deserFeatures = DeserializationConfig.collectFeatureDefaults(DeserializationFeature.class);
        this._nodeFactory = JsonNodeFactory.instance;
        this._problemHandlers = null;
        this._parserFeatures = 0;
        this._parserFeaturesToChange = 0;
        this._formatReadFeatures = 0;
        this._formatReadFeaturesToChange = 0;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(deserializationConfig, simpleMixInResolver, rootNameLookup, configOverrides);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(deserializationConfig, n2);
        this._deserFeatures = n3;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._parserFeatures = n4;
        this._parserFeaturesToChange = n5;
        this._formatReadFeatures = n6;
        this._formatReadFeaturesToChange = n7;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver) {
        super(deserializationConfig, subtypeResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, BaseSettings baseSettings) {
        super(deserializationConfig, baseSettings);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, JsonNodeFactory jsonNodeFactory) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = jsonNodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, LinkedNode<DeserializationProblemHandler> linkedNode) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = linkedNode;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, PropertyName propertyName) {
        super(deserializationConfig, propertyName);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, Class<?> clazz) {
        super(deserializationConfig, clazz);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, ContextAttributes contextAttributes) {
        super(deserializationConfig, contextAttributes);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(deserializationConfig, simpleMixInResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected BaseSettings getBaseSettings() {
        return this._base;
    }

    @Override
    protected final DeserializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new DeserializationConfig(this, baseSettings);
    }

    @Override
    protected final DeserializationConfig _withMapperFeatures(int n2) {
        return new DeserializationConfig(this, n2, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    @Override
    public DeserializationConfig with(SubtypeResolver subtypeResolver) {
        return this._subtypeResolver == subtypeResolver ? this : new DeserializationConfig(this, subtypeResolver);
    }

    @Override
    public DeserializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new DeserializationConfig(this, propertyName);
    }

    @Override
    public DeserializationConfig withView(Class<?> clazz) {
        return this._view == clazz ? this : new DeserializationConfig(this, clazz);
    }

    @Override
    public DeserializationConfig with(ContextAttributes contextAttributes) {
        return contextAttributes == this._attributes ? this : new DeserializationConfig(this, contextAttributes);
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature) {
        int n2 = this._deserFeatures | deserializationFeature.getMask();
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures | deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n2 |= deserializationFeature2.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n2 |= deserializationFeature.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature) {
        int n2 = this._deserFeatures & ~deserializationFeature.getMask();
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures & ~deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n2 &= ~deserializationFeature2.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n2 &= ~deserializationFeature.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig with(JsonParser.Feature feature) {
        int n2 = this._parserFeatures | feature.getMask();
        int n3 = this._parserFeaturesToChange | feature.getMask();
        return this._parserFeatures == n2 && this._parserFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withFeatures(JsonParser.Feature ... featureArray) {
        int n2 = this._parserFeatures;
        int n3 = this._parserFeaturesToChange;
        for (JsonParser.Feature feature : featureArray) {
            int n4 = feature.getMask();
            n2 |= n4;
            n3 |= n4;
        }
        return this._parserFeatures == n2 && this._parserFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig without(JsonParser.Feature feature) {
        int n2 = this._parserFeatures & ~feature.getMask();
        int n3 = this._parserFeaturesToChange | feature.getMask();
        return this._parserFeatures == n2 && this._parserFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withoutFeatures(JsonParser.Feature ... featureArray) {
        int n2 = this._parserFeatures;
        int n3 = this._parserFeaturesToChange;
        for (JsonParser.Feature feature : featureArray) {
            int n4 = feature.getMask();
            n2 &= ~n4;
            n3 |= n4;
        }
        return this._parserFeatures == n2 && this._parserFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n2, n3, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig with(FormatFeature formatFeature) {
        int n2 = this._formatReadFeatures | formatFeature.getMask();
        int n3 = this._formatReadFeaturesToChange | formatFeature.getMask();
        return this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public DeserializationConfig withFeatures(FormatFeature ... formatFeatureArray) {
        int n2 = this._formatReadFeatures;
        int n3 = this._formatReadFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n4 = formatFeature.getMask();
            n2 |= n4;
            n3 |= n4;
        }
        return this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public DeserializationConfig without(FormatFeature formatFeature) {
        int n2 = this._formatReadFeatures & ~formatFeature.getMask();
        int n3 = this._formatReadFeaturesToChange | formatFeature.getMask();
        return this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public DeserializationConfig withoutFeatures(FormatFeature ... formatFeatureArray) {
        int n2 = this._formatReadFeatures;
        int n3 = this._formatReadFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n4 = formatFeature.getMask();
            n2 &= ~n4;
            n3 |= n4;
        }
        return this._formatReadFeatures == n2 && this._formatReadFeaturesToChange == n3 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n2, n3);
    }

    public DeserializationConfig with(JsonNodeFactory jsonNodeFactory) {
        if (this._nodeFactory == jsonNodeFactory) {
            return this;
        }
        return new DeserializationConfig(this, jsonNodeFactory);
    }

    public DeserializationConfig withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        if (LinkedNode.contains(this._problemHandlers, deserializationProblemHandler)) {
            return this;
        }
        return new DeserializationConfig(this, new LinkedNode<DeserializationProblemHandler>(deserializationProblemHandler, this._problemHandlers));
    }

    public DeserializationConfig withNoProblemHandlers() {
        if (this._problemHandlers == null) {
            return this;
        }
        return new DeserializationConfig(this, (LinkedNode<DeserializationProblemHandler>)null);
    }

    public void initialize(JsonParser jsonParser) {
        if (this._parserFeaturesToChange != 0) {
            jsonParser.overrideStdFeatures(this._parserFeatures, this._parserFeaturesToChange);
        }
        if (this._formatReadFeaturesToChange != 0) {
            jsonParser.overrideFormatFeatures(this._formatReadFeatures, this._formatReadFeaturesToChange);
        }
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._deserFeatures & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonParser.Feature feature, JsonFactory jsonFactory) {
        int n2 = feature.getMask();
        if ((this._parserFeaturesToChange & n2) != 0) {
            return (this._parserFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasDeserializationFeatures(int n2) {
        return (this._deserFeatures & n2) == n2;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._deserFeatures & n2) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._deserFeatures;
    }

    public final boolean requiresFullValue() {
        return DeserializationFeature.FAIL_ON_TRAILING_TOKENS.enabledIn(this._deserFeatures);
    }

    public LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public <T extends BeanDescription> T introspect(JavaType javaType) {
        return (T)this.getClassIntrospector().forDeserialization(this, javaType, this);
    }

    public <T extends BeanDescription> T introspectForCreation(JavaType javaType) {
        return (T)this.getClassIntrospector().forCreation(this, javaType, this);
    }

    public <T extends BeanDescription> T introspectForBuilder(JavaType javaType) {
        return (T)this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this);
    }

    public TypeDeserializer findTypeDeserializer(JavaType javaType) throws JsonMappingException {
        BeanDescription beanDescription = this.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = this.getAnnotationIntrospector().findTypeResolver(this, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = this.getSubtypeResolver().collectAndResolveSubtypesByTypeId(this, annotatedClass);
        }
        return typeResolverBuilder.buildTypeDeserializer(this, javaType, collection);
    }
}

