/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import zz.com.fasterxml.jackson.annotation.ObjectIdResolver;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DatabindContext;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.InjectableValues;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.KeyDeserializer;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import zz.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import zz.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import zz.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import zz.com.fasterxml.jackson.databind.deser.DeserializerCache;
import zz.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import zz.com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import zz.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import zz.com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import zz.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import zz.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import zz.com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import zz.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import zz.com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import zz.com.fasterxml.jackson.databind.introspect.Annotated;
import zz.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import zz.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ArrayBuilders;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.LinkedNode;
import zz.com.fasterxml.jackson.databind.util.ObjectBuffer;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;

    protected DeserializationContext(DeserializerFactory deserializerFactory) {
        this(deserializerFactory, null);
    }

    protected DeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        if (deserializerFactory == null) {
            throw new IllegalArgumentException("Cannot pass null DeserializerFactory");
        }
        this._factory = deserializerFactory;
        if (deserializerCache == null) {
            deserializerCache = new DeserializerCache();
        }
        this._cache = deserializerCache;
        this._featureFlags = 0;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory) {
        this._cache = deserializationContext._cache;
        this._factory = deserializerFactory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = deserializationContext._attributes;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = deserializationConfig.getActiveView();
        this._parser = jsonParser;
        this._injectableValues = injectableValues;
        this._attributes = deserializationConfig.getAttributes();
    }

    protected DeserializationContext(DeserializationContext deserializationContext) {
        this._cache = new DeserializerCache();
        this._factory = deserializationContext._factory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._view = deserializationContext._view;
        this._injectableValues = null;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._config.getDefaultPropertyFormat(clazz);
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public DeserializationContext setAttribute(Object object, Object object2) {
        this._attributes = this._attributes.withPerCallAttribute(object, object2);
        return this;
    }

    public JavaType getContextualType() {
        return this._currentType == null ? null : this._currentType.value();
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._featureFlags & deserializationFeature.getMask()) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasDeserializationFeatures(int n2) {
        return (this._featureFlags & n2) == n2;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._featureFlags & n2) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object object, BeanProperty beanProperty, Object object2) throws JsonMappingException {
        if (this._injectableValues == null) {
            this.reportBadDefinition(ClassUtil.classOf(object), String.format("No 'injectableValues' configured, cannot inject value with id [%s]", object));
        }
        return this._injectableValues.findInjectableValue(object, this, beanProperty, object2);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public boolean hasValueDeserializerFor(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        try {
            return this._cache.hasValueDeserializerFor(this, this._factory, javaType);
        }
        catch (JsonMappingException jsonMappingException) {
            if (atomicReference != null) {
                atomicReference.set(jsonMappingException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (atomicReference == null) {
                throw runtimeException;
            }
            atomicReference.set(runtimeException);
        }
        return false;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer != null) {
            jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        return jsonDeserializer;
    }

    public final JsonDeserializer<Object> findNonContextualValueDeserializer(JavaType javaType) throws JsonMappingException {
        return this._cache.findValueDeserializer(this, this._factory, javaType);
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer == null) {
            return null;
        }
        jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, null, javaType);
        TypeDeserializer typeDeserializer = this._factory.findTypeDeserializer(this._config, javaType);
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(null);
            return new TypeWrappedDeserializer(typeDeserializer, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        KeyDeserializer keyDeserializer = this._cache.findKeyDeserializer(this, this._factory, javaType);
        if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(this, beanProperty);
        }
        return keyDeserializer;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public abstract void checkUnresolvedObjectId() throws UnresolvedForwardReference;

    public final JavaType constructType(Class<?> clazz) {
        return clazz == null ? null : this._config.constructType(clazz);
    }

    public Class<?> findClass(String string) throws ClassNotFoundException {
        return this.getTypeFactory().findClass(string);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer objectBuffer = this._objectBuffer;
        if (objectBuffer == null) {
            objectBuffer = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return objectBuffer;
    }

    public final void returnObjectBuffer(ObjectBuffer objectBuffer) {
        if (this._objectBuffer == null || objectBuffer.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = objectBuffer;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) throws JsonMappingException {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
            }
            finally {
                this._currentType = this._currentType.next();
            }
        }
        return jsonDeserializer;
    }

    public Date parseDate(String string) throws IllegalArgumentException {
        try {
            DateFormat dateFormat = this.getDateFormat();
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", string, parseException.getMessage()));
        }
    }

    public Calendar constructCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.readValue(jsonParser, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            this.reportBadDefinition(javaType, "Could not find JsonDeserializer for type " + javaType);
        }
        return (T)jsonDeserializer.deserialize(jsonParser, this);
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, Class<T> clazz) throws IOException {
        return this.readPropertyValue(jsonParser, beanProperty, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, JavaType javaType) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this.findContextualValueDeserializer(javaType, beanProperty);
        if (jsonDeserializer == null) {
            return this.reportBadDefinition(javaType, String.format("Could not find JsonDeserializer for type %s (via property %s)", javaType, ClassUtil.nameOf(beanProperty)));
        }
        return (T)jsonDeserializer.deserialize(jsonParser, this);
    }

    public boolean handleUnknownProperty(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Object object, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            if (!linkedNode.value().handleUnknownProperty(this, jsonParser, jsonDeserializer, object, string)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            jsonParser.skipChildren();
            return true;
        }
        Collection<Object> collection = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object, string, collection);
    }

    public Object handleWeirdKey(Class<?> clazz, String string, String string2, Object ... objectArray) throws IOException {
        string2 = this._format(string2, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdKey(this, clazz, string, string2);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object == null || clazz.isInstance(object)) {
                return object;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.weirdKeyException(clazz, string, string2);
    }

    public Object handleWeirdStringValue(Class<?> clazz, String string, String string2, Object ... objectArray) throws IOException {
        string2 = this._format(string2, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdStringValue(this, clazz, string, string2);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            throw this.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.weirdStringException(string, clazz, string2);
    }

    public Object handleWeirdNumberValue(Class<?> clazz, Number number, String string, Object ... objectArray) throws IOException {
        string = this._format(string, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleWeirdNumberValue(this, clazz, number, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            throw this.weirdNumberException(number, clazz, this._format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", clazz, object.getClass()));
        }
        throw this.weirdNumberException(number, clazz, string);
    }

    public Object handleWeirdNativeValue(JavaType javaType, Object object, JsonParser jsonParser) throws IOException {
        Class<?> clazz = javaType.getRawClass();
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleWeirdNativeValue(this, javaType, object, jsonParser);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 == null || clazz.isInstance(object2)) {
                return object2;
            }
            throw JsonMappingException.from(jsonParser, this._format("DeserializationProblemHandler.handleWeirdNativeValue() for type %s returned value of type %s", javaType, object2.getClass()));
        }
        throw this.weirdNativeValueException(object, clazz);
    }

    public Object handleMissingInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        if (jsonParser == null) {
            jsonParser = this.getParser();
        }
        string = this._format(string, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleMissingInstantiator(this, clazz, valueInstantiator, jsonParser, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            this.reportBadDefinition(this.constructType(clazz), String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", clazz, ClassUtil.classNameOf(object)));
        }
        if (valueInstantiator != null && !valueInstantiator.canInstantiate()) {
            string = String.format("Cannot construct instance of %s (no Creators, like default construct, exist): %s", ClassUtil.nameOf(clazz), string);
            return this.reportBadDefinition(this.constructType(clazz), string);
        }
        string = String.format("Cannot construct instance of %s (although at least one Creator exists): %s", ClassUtil.nameOf(clazz), string);
        return this.reportInputMismatch(clazz, string, new Object[0]);
    }

    public Object handleInstantiationProblem(Class<?> clazz, Object object, Throwable throwable) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleInstantiationProblem(this, clazz, object, throwable);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            this.reportBadDefinition(this.constructType(clazz), String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", clazz, ClassUtil.classNameOf(object2)));
        }
        ClassUtil.throwIfIOE(throwable);
        throw this.instantiationException(clazz, throwable);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonParser jsonParser) throws IOException {
        return this.handleUnexpectedToken(clazz, jsonParser.getCurrentToken(), jsonParser, null, new Object[0]);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... objectArray) throws IOException {
        string = this._format(string, objectArray);
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object = linkedNode.value().handleUnexpectedToken(this, clazz, jsonToken, jsonParser, string);
            if (object == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object)) {
                return object;
            }
            this.reportBadDefinition(this.constructType(clazz), String.format("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", ClassUtil.nameOf(clazz), ClassUtil.classNameOf(object)));
        }
        if (string == null) {
            string = jsonToken == null ? String.format("Unexpected end-of-input when binding data into %s", ClassUtil.nameOf(clazz)) : String.format("Cannot deserialize instance of %s out of %s token", new Object[]{ClassUtil.nameOf(clazz), jsonToken});
        }
        this.reportInputMismatch(clazz, string, new Object[0]);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType javaType, String string, TypeIdResolver typeIdResolver, String string2) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleUnknownTypeId(this, javaType, string, typeIdResolver, string2);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, string, "problem handler tried to resolve into non-subtype: " + javaType2);
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.invalidTypeIdException(javaType, string, string2);
    }

    public JavaType handleMissingTypeId(JavaType javaType, TypeIdResolver typeIdResolver, String string) throws IOException {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleMissingTypeId(this, javaType, typeIdResolver, string);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, null, "problem handler tried to resolve into non-subtype: " + javaType2);
        }
        throw this.missingTypeIdException(javaType, string);
    }

    protected boolean _isCompatible(Class<?> clazz, Object object) {
        if (object == null || clazz.isInstance(object)) {
            return true;
        }
        return clazz.isPrimitive() && ClassUtil.wrapperType(clazz).isInstance(object);
    }

    public void reportWrongTokenException(JsonDeserializer<?> jsonDeserializer, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(this.getParser(), jsonDeserializer.handledType(), jsonToken, string);
    }

    public void reportWrongTokenException(JavaType javaType, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(this.getParser(), javaType, jsonToken, string);
    }

    public void reportWrongTokenException(Class<?> clazz, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(this.getParser(), clazz, jsonToken, string);
    }

    public <T> T reportUnresolvedObjectId(ObjectIdReader objectIdReader, Object object) throws JsonMappingException {
        String string = String.format("No Object Id found for an instance of %s, to assign to property '%s'", ClassUtil.classNameOf(object), objectIdReader.propertyName);
        return this.reportInputMismatch(objectIdReader.idProperty, string, new Object[0]);
    }

    public <T> T reportInputMismatch(BeanProperty beanProperty, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        JavaType javaType = beanProperty == null ? null : beanProperty.getType();
        throw MismatchedInputException.from(this.getParser(), javaType, string);
    }

    public <T> T reportInputMismatch(JsonDeserializer<?> jsonDeserializer, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), jsonDeserializer.handledType(), string);
    }

    public <T> T reportInputMismatch(Class<?> clazz, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), clazz, string);
    }

    public <T> T reportInputMismatch(JavaType javaType, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw MismatchedInputException.from(this.getParser(), javaType, string);
    }

    public <T> T reportTrailingTokens(Class<?> clazz, JsonParser jsonParser, JsonToken jsonToken) throws JsonMappingException {
        throw MismatchedInputException.from(jsonParser, clazz, String.format("Trailing token (of type %s) found after value (bound as %s): not allowed as per `DeserializationFeature.FAIL_ON_TRAILING_TOKENS`", new Object[]{jsonToken, ClassUtil.nameOf(clazz)}));
    }

    @Deprecated
    public void reportWrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        throw this.wrongTokenException(jsonParser, jsonToken, string);
    }

    @Deprecated
    public void reportUnknownProperty(Object object, String string, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            Collection<Object> collection = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
            throw UnrecognizedPropertyException.from(this._parser, object, string, collection);
        }
    }

    @Deprecated
    public void reportMissingContent(String string, Object ... objectArray) throws JsonMappingException {
        throw MismatchedInputException.from(this.getParser(), (JavaType)null, "No content to map due to end-of-input");
    }

    public <T> T reportBadTypeDefinition(BeanDescription beanDescription, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        String string2 = ClassUtil.nameOf(beanDescription.getBeanClass());
        string = String.format("Invalid type definition for type %s: %s", string2, string);
        throw InvalidDefinitionException.from(this._parser, string, beanDescription, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, String string, Object ... objectArray) throws JsonMappingException {
        string = this._format(string, objectArray);
        String string2 = ClassUtil.nameOf(beanPropertyDefinition);
        String string3 = ClassUtil.nameOf(beanDescription.getBeanClass());
        string = String.format("Invalid definition for property %s (of type %s): %s", string2, string3, string);
        throw InvalidDefinitionException.from(this._parser, string, beanDescription, beanPropertyDefinition);
    }

    @Override
    public <T> T reportBadDefinition(JavaType javaType, String string) throws JsonMappingException {
        throw InvalidDefinitionException.from(this._parser, string, javaType);
    }

    public <T> T reportBadMerge(JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (this.isEnabled(MapperFeature.IGNORE_MERGE_FOR_UNMERGEABLE)) {
            return null;
        }
        JavaType javaType = this.constructType(jsonDeserializer.handledType());
        String string = String.format("Invalid configuration: values of type %s cannot be merged", javaType);
        throw InvalidDefinitionException.from(this.getParser(), string, javaType);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JavaType javaType, JsonToken jsonToken, String string) {
        String string2 = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.getCurrentToken(), jsonToken});
        string2 = this._colonConcat(string2, string);
        return MismatchedInputException.from(jsonParser, javaType, string2);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, Class<?> clazz, JsonToken jsonToken, String string) {
        String string2 = String.format("Unexpected token (%s), expected %s", new Object[]{jsonParser.getCurrentToken(), jsonToken});
        string2 = this._colonConcat(string2, string);
        return MismatchedInputException.from(jsonParser, clazz, string2);
    }

    @Deprecated
    public JsonMappingException wrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string) {
        return this.wrongTokenException(jsonParser, (JavaType)null, jsonToken, string);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize Map key of type %s from String %s: %s", ClassUtil.nameOf(clazz), this._quotedString(string), string2), string, clazz);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from String %s: %s", ClassUtil.nameOf(clazz), this._quotedString(string), string2), string, clazz);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from number %s: %s", ClassUtil.nameOf(clazz), String.valueOf(number), string), number, clazz);
    }

    public JsonMappingException weirdNativeValueException(Object object, Class<?> clazz) {
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize value of type %s from native value (`JsonToken.VALUE_EMBEDDED_OBJECT`) of type %s: incompatible types", ClassUtil.nameOf(clazz), ClassUtil.classNameOf(object)), object, clazz);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        JavaType javaType = this.constructType(clazz);
        String string = String.format("Cannot construct instance of %s, problem: %s", ClassUtil.nameOf(clazz), throwable.getMessage());
        InvalidDefinitionException invalidDefinitionException = InvalidDefinitionException.from(this._parser, string, javaType);
        invalidDefinitionException.initCause(throwable);
        return invalidDefinitionException;
    }

    public JsonMappingException instantiationException(Class<?> clazz, String string) {
        JavaType javaType = this.constructType(clazz);
        String string2 = String.format("Cannot construct instance of %s: %s", ClassUtil.nameOf(clazz), string);
        return InvalidDefinitionException.from(this._parser, string2, javaType);
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' as a subtype of %s", string, javaType);
        return InvalidTypeIdException.from(this._parser, this._colonConcat(string3, string2), javaType, string);
    }

    public JsonMappingException missingTypeIdException(JavaType javaType, String string) {
        String string2 = String.format("Missing type id when trying to resolve subtype of %s", javaType);
        return InvalidTypeIdException.from(this._parser, this._colonConcat(string2, string), javaType, null);
    }

    @Deprecated
    public JsonMappingException unknownTypeException(JavaType javaType, String string, String string2) {
        String string3 = String.format("Could not resolve type id '%s' into a subtype of %s", string, javaType);
        string3 = this._colonConcat(string3, string2);
        return MismatchedInputException.from(this._parser, javaType, string3);
    }

    @Deprecated
    public JsonMappingException endOfInputException(Class<?> clazz) {
        return MismatchedInputException.from(this._parser, clazz, "Unexpected end-of-input when trying to deserialize a " + clazz.getName());
    }

    @Deprecated
    public void reportMappingException(String string, Object ... objectArray) throws JsonMappingException {
        throw JsonMappingException.from(this.getParser(), this._format(string, objectArray));
    }

    @Deprecated
    public JsonMappingException mappingException(String string) {
        return JsonMappingException.from(this.getParser(), string);
    }

    @Deprecated
    public JsonMappingException mappingException(String string, Object ... objectArray) {
        return JsonMappingException.from(this.getParser(), this._format(string, objectArray));
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> clazz) {
        return this.mappingException(clazz, this._parser.getCurrentToken());
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> clazz, JsonToken jsonToken) {
        return JsonMappingException.from(this._parser, String.format("Cannot deserialize instance of %s out of %s token", new Object[]{ClassUtil.nameOf(clazz), jsonToken}));
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }
}

