/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class InjectableValues {
    public abstract Object findInjectableValue(Object var1, DeserializationContext var2, BeanProperty var3, Object var4) throws JsonMappingException;

    public static class Std
    extends InjectableValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Map<String, Object> _values;

        public Std() {
            this(new HashMap<String, Object>());
        }

        public Std(Map<String, Object> map) {
            this._values = map;
        }

        public Std addValue(String string, Object object) {
            this._values.put(string, object);
            return this;
        }

        public Std addValue(Class<?> clazz, Object object) {
            this._values.put(clazz.getName(), object);
            return this;
        }

        @Override
        public Object findInjectableValue(Object object, DeserializationContext deserializationContext, BeanProperty beanProperty, Object object2) throws JsonMappingException {
            String string;
            Object object3;
            if (!(object instanceof String)) {
                deserializationContext.reportBadDefinition(ClassUtil.classOf(object), String.format("Unrecognized inject value id type (%s), expecting String", ClassUtil.classNameOf(object)));
            }
            if ((object3 = this._values.get(string = (String)object)) == null && !this._values.containsKey(string)) {
                throw new IllegalArgumentException("No injectable id with value '" + string + "' found (for property '" + beanProperty.getName() + "')");
            }
            return object3;
        }
    }
}

