/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.IOException;
import java.util.Collection;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.deser.NullValueProvider;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.util.AccessPattern;
import zz.com.fasterxml.jackson.databind.util.NameTransformer;

public abstract class JsonDeserializer<T>
implements NullValueProvider {
    public abstract T deserialize(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, T t2) throws IOException {
        if (deserializationContext.isEnabled(MapperFeature.IGNORE_MERGE_FOR_UNMERGEABLE)) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        throw new UnsupportedOperationException("Cannot update object of type " + t2.getClass().getName() + " (by deserializer of type " + this.getClass().getName() + ")");
    }

    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    public JsonDeserializer<T> unwrappingDeserializer(NameTransformer nameTransformer) {
        return this;
    }

    public JsonDeserializer<?> replaceDelegatee(JsonDeserializer<?> jsonDeserializer) {
        throw new UnsupportedOperationException();
    }

    public Class<?> handledType() {
        return null;
    }

    public boolean isCachable() {
        return false;
    }

    public JsonDeserializer<?> getDelegatee() {
        return null;
    }

    public Collection<Object> getKnownPropertyNames() {
        return null;
    }

    public T getNullValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this.getNullValue();
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this.getNullValue(deserializationContext);
    }

    public ObjectIdReader getObjectIdReader() {
        return null;
    }

    public SettableBeanProperty findBackReference(String string) {
        throw new IllegalArgumentException("Cannot handle managed/back reference '" + string + "': type: value deserializer of type " + this.getClass().getName() + " does not support them");
    }

    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Deprecated
    public T getNullValue() {
        return null;
    }

    @Deprecated
    public Object getEmptyValue() {
        return this.getNullValue();
    }

    public static abstract class None
    extends JsonDeserializer<Object> {
        private None() {
        }
    }
}

