/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import zz.com.fasterxml.jackson.annotation.JsonAutoDetect;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonSetter;
import zz.com.fasterxml.jackson.annotation.JsonTypeInfo;
import zz.com.fasterxml.jackson.annotation.PropertyAccessor;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.core.Base64Variants;
import zz.com.fasterxml.jackson.core.FormatSchema;
import zz.com.fasterxml.jackson.core.JsonEncoding;
import zz.com.fasterxml.jackson.core.JsonFactory;
import zz.com.fasterxml.jackson.core.JsonGenerationException;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonParseException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.ObjectCodec;
import zz.com.fasterxml.jackson.core.PrettyPrinter;
import zz.com.fasterxml.jackson.core.TreeNode;
import zz.com.fasterxml.jackson.core.Version;
import zz.com.fasterxml.jackson.core.Versioned;
import zz.com.fasterxml.jackson.core.io.CharacterEscapes;
import zz.com.fasterxml.jackson.core.io.SegmentedStringWriter;
import zz.com.fasterxml.jackson.core.type.ResolvedType;
import zz.com.fasterxml.jackson.core.type.TypeReference;
import zz.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import zz.com.fasterxml.jackson.databind.AbstractTypeResolver;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.InjectableValues;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.MappingIterator;
import zz.com.fasterxml.jackson.databind.MappingJsonFactory;
import zz.com.fasterxml.jackson.databind.Module;
import zz.com.fasterxml.jackson.databind.ObjectReader;
import zz.com.fasterxml.jackson.databind.ObjectWriter;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.SerializationFeature;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.cfg.BaseSettings;
import zz.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import zz.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import zz.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import zz.com.fasterxml.jackson.databind.cfg.MutableConfigOverride;
import zz.com.fasterxml.jackson.databind.cfg.PackageVersion;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import zz.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import zz.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import zz.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import zz.com.fasterxml.jackson.databind.deser.Deserializers;
import zz.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import zz.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import zz.com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import zz.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import zz.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import zz.com.fasterxml.jackson.databind.jsontype.NamedType;
import zz.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import zz.com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import zz.com.fasterxml.jackson.databind.node.NullNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.databind.node.POJONode;
import zz.com.fasterxml.jackson.databind.node.TreeTraversingParser;
import zz.com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import zz.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import zz.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.FilterProvider;
import zz.com.fasterxml.jackson.databind.ser.SerializerFactory;
import zz.com.fasterxml.jackson.databind.ser.Serializers;
import zz.com.fasterxml.jackson.databind.type.SimpleType;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.type.TypeModifier;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.RootNameLookup;
import zz.com.fasterxml.jackson.databind.util.StdDateFormat;
import zz.com.fasterxml.jackson.databind.util.TokenBuffer;

public class ObjectMapper
extends ObjectCodec
implements Serializable,
Versioned {
    private static final long serialVersionUID = 2L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(null, DEFAULT_ANNOTATION_INTROSPECTOR, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), null, Base64Variants.getDefaultVariant());
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final ConfigOverrides _configOverrides;
    protected SimpleMixInResolver _mixIns;
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected Set<Object> _registeredModuleTypes;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    protected ObjectMapper(ObjectMapper objectMapper) {
        this._jsonFactory = objectMapper._jsonFactory.copy();
        this._jsonFactory.setCodec(this);
        this._subtypeResolver = objectMapper._subtypeResolver;
        this._typeFactory = objectMapper._typeFactory;
        this._injectableValues = objectMapper._injectableValues;
        this._configOverrides = objectMapper._configOverrides.copy();
        this._mixIns = objectMapper._mixIns.copy();
        RootNameLookup rootNameLookup = new RootNameLookup();
        this._serializationConfig = new SerializationConfig(objectMapper._serializationConfig, this._mixIns, rootNameLookup, this._configOverrides);
        this._deserializationConfig = new DeserializationConfig(objectMapper._deserializationConfig, this._mixIns, rootNameLookup, this._configOverrides);
        this._serializerProvider = objectMapper._serializerProvider.copy();
        this._deserializationContext = objectMapper._deserializationContext.copy();
        this._serializerFactory = objectMapper._serializerFactory;
        Set<Object> set = objectMapper._registeredModuleTypes;
        this._registeredModuleTypes = set == null ? null : new LinkedHashSet<Object>(set);
    }

    public ObjectMapper(JsonFactory jsonFactory, DefaultSerializerProvider defaultSerializerProvider, DefaultDeserializationContext defaultDeserializationContext) {
        SimpleMixInResolver simpleMixInResolver;
        if (jsonFactory == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = jsonFactory;
            if (jsonFactory.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        RootNameLookup rootNameLookup = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        this._mixIns = simpleMixInResolver = new SimpleMixInResolver(null);
        BaseSettings baseSettings = DEFAULT_BASE.withClassIntrospector(this.defaultClassIntrospector());
        this._configOverrides = new ConfigOverrides();
        this._serializationConfig = new SerializationConfig(baseSettings, this._subtypeResolver, simpleMixInResolver, rootNameLookup, this._configOverrides);
        this._deserializationConfig = new DeserializationConfig(baseSettings, this._subtypeResolver, simpleMixInResolver, rootNameLookup, this._configOverrides);
        boolean bl2 = this._jsonFactory.requiresPropertyOrdering();
        if (bl2 ^ this._serializationConfig.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)) {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, bl2);
        }
        this._serializerProvider = defaultSerializerProvider == null ? new DefaultSerializerProvider.Impl() : defaultSerializerProvider;
        this._deserializationContext = defaultDeserializationContext == null ? new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance) : defaultDeserializationContext;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    protected ClassIntrospector defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    protected ObjectReader _newReader(DeserializationConfig deserializationConfig) {
        return new ObjectReader(this, deserializationConfig);
    }

    protected ObjectReader _newReader(DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        return new ObjectReader(this, deserializationConfig, javaType, object, formatSchema, injectableValues);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig) {
        return new ObjectWriter(this, serializationConfig);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig, FormatSchema formatSchema) {
        return new ObjectWriter(this, serializationConfig, formatSchema);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        return new ObjectWriter(this, serializationConfig, javaType, prettyPrinter);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectMapper registerModule(Module module) {
        Object object;
        if (this.isEnabled(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS) && (object = module.getTypeId()) != null) {
            if (this._registeredModuleTypes == null) {
                this._registeredModuleTypes = new LinkedHashSet<Object>();
            }
            if (!this._registeredModuleTypes.add(object)) {
                return this;
            }
        }
        if ((object = module.getModuleName()) == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        Version version = module.version();
        if (version == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        module.setupModule(new Module.SetupContext(){

            @Override
            public Version getMapperVersion() {
                return ObjectMapper.this.version();
            }

            @Override
            public <C extends ObjectCodec> C getOwner() {
                return (C)ObjectMapper.this;
            }

            @Override
            public TypeFactory getTypeFactory() {
                return ObjectMapper.this._typeFactory;
            }

            @Override
            public boolean isEnabled(MapperFeature mapperFeature) {
                return ObjectMapper.this.isEnabled(mapperFeature);
            }

            @Override
            public boolean isEnabled(DeserializationFeature deserializationFeature) {
                return ObjectMapper.this.isEnabled(deserializationFeature);
            }

            @Override
            public boolean isEnabled(SerializationFeature serializationFeature) {
                return ObjectMapper.this.isEnabled(serializationFeature);
            }

            @Override
            public boolean isEnabled(JsonFactory.Feature feature) {
                return ObjectMapper.this.isEnabled(feature);
            }

            @Override
            public boolean isEnabled(JsonParser.Feature feature) {
                return ObjectMapper.this.isEnabled(feature);
            }

            @Override
            public boolean isEnabled(JsonGenerator.Feature feature) {
                return ObjectMapper.this.isEnabled(feature);
            }

            @Override
            public MutableConfigOverride configOverride(Class<?> clazz) {
                return ObjectMapper.this.configOverride(clazz);
            }

            @Override
            public void addDeserializers(Deserializers deserializers) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withAdditionalDeserializers(deserializers);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addKeyDeserializers(KeyDeserializers keyDeserializers) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withAdditionalKeyDeserializers(keyDeserializers);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addBeanDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withDeserializerModifier(beanDeserializerModifier);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addSerializers(Serializers serializers) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withAdditionalSerializers(serializers);
            }

            @Override
            public void addKeySerializers(Serializers serializers) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withAdditionalKeySerializers(serializers);
            }

            @Override
            public void addBeanSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withSerializerModifier(beanSerializerModifier);
            }

            @Override
            public void addAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withAbstractTypeResolver(abstractTypeResolver);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addTypeModifier(TypeModifier typeModifier) {
                TypeFactory typeFactory = ObjectMapper.this._typeFactory;
                typeFactory = typeFactory.withModifier(typeModifier);
                ObjectMapper.this.setTypeFactory(typeFactory);
            }

            @Override
            public void addValueInstantiators(ValueInstantiators valueInstantiators) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withValueInstantiators(valueInstantiators);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void setClassIntrospector(ClassIntrospector classIntrospector) {
                ObjectMapper.this._deserializationConfig = (DeserializationConfig)ObjectMapper.this._deserializationConfig.with(classIntrospector);
                ObjectMapper.this._serializationConfig = (SerializationConfig)ObjectMapper.this._serializationConfig.with(classIntrospector);
            }

            @Override
            public void insertAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
                ObjectMapper.this._deserializationConfig = (DeserializationConfig)ObjectMapper.this._deserializationConfig.withInsertedAnnotationIntrospector(annotationIntrospector);
                ObjectMapper.this._serializationConfig = (SerializationConfig)ObjectMapper.this._serializationConfig.withInsertedAnnotationIntrospector(annotationIntrospector);
            }

            @Override
            public void appendAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
                ObjectMapper.this._deserializationConfig = (DeserializationConfig)ObjectMapper.this._deserializationConfig.withAppendedAnnotationIntrospector(annotationIntrospector);
                ObjectMapper.this._serializationConfig = (SerializationConfig)ObjectMapper.this._serializationConfig.withAppendedAnnotationIntrospector(annotationIntrospector);
            }

            @Override
            public void registerSubtypes(Class<?> ... classArray) {
                ObjectMapper.this.registerSubtypes(classArray);
            }

            @Override
            public void registerSubtypes(NamedType ... namedTypeArray) {
                ObjectMapper.this.registerSubtypes(namedTypeArray);
            }

            @Override
            public void registerSubtypes(Collection<Class<?>> collection) {
                ObjectMapper.this.registerSubtypes(collection);
            }

            @Override
            public void setMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
                ObjectMapper.this.addMixIn(clazz, clazz2);
            }

            @Override
            public void addDeserializationProblemHandler(DeserializationProblemHandler deserializationProblemHandler) {
                ObjectMapper.this.addHandler(deserializationProblemHandler);
            }

            @Override
            public void setNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
                ObjectMapper.this.setPropertyNamingStrategy(propertyNamingStrategy);
            }
        });
        return this;
    }

    public ObjectMapper registerModules(Module ... moduleArray) {
        for (Module module : moduleArray) {
            this.registerModule(module);
        }
        return this;
    }

    public ObjectMapper registerModules(Iterable<? extends Module> iterable) {
        for (Module module : iterable) {
            this.registerModule(module);
        }
        return this;
    }

    public static List<Module> findModules() {
        return ObjectMapper.findModules(null);
    }

    public static List<Module> findModules(ClassLoader classLoader) {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ServiceLoader<Module> serviceLoader = ObjectMapper.secureGetServiceLoader(Module.class, classLoader);
        for (Module module : serviceLoader) {
            arrayList.add(module);
        }
        return arrayList;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(final Class<T> clazz, final ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<T>>(){

            @Override
            public ServiceLoader<T> run() {
                return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
            }
        });
    }

    public ObjectMapper findAndRegisterModules() {
        return this.registerModules(ObjectMapper.findModules());
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public DeserializationContext getDeserializationContext() {
        return this._deserializationContext;
    }

    public ObjectMapper setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        return this;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    public ObjectMapper setSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        this._serializerProvider = defaultSerializerProvider;
        return this;
    }

    public SerializerProvider getSerializerProvider() {
        return this._serializerProvider;
    }

    public SerializerProvider getSerializerProviderInstance() {
        return this._serializerProvider(this._serializationConfig);
    }

    public ObjectMapper setMixIns(Map<Class<?>, Class<?>> map) {
        this._mixIns.setLocalDefinitions(map);
        return this;
    }

    public ObjectMapper addMixIn(Class<?> clazz, Class<?> clazz2) {
        this._mixIns.addLocalDefinition(clazz, clazz2);
        return this;
    }

    public ObjectMapper setMixInResolver(ClassIntrospector.MixInResolver mixInResolver) {
        SimpleMixInResolver simpleMixInResolver = this._mixIns.withOverrides(mixInResolver);
        if (simpleMixInResolver != this._mixIns) {
            this._mixIns = simpleMixInResolver;
            this._deserializationConfig = new DeserializationConfig(this._deserializationConfig, simpleMixInResolver);
            this._serializationConfig = new SerializationConfig(this._serializationConfig, simpleMixInResolver);
        }
        return this;
    }

    public Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixIns.findMixInClassFor(clazz);
    }

    public int mixInCount() {
        return this._mixIns.localSize();
    }

    @Deprecated
    public void setMixInAnnotations(Map<Class<?>, Class<?>> map) {
        this.setMixIns(map);
    }

    @Deprecated
    public final void addMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
        this.addMixIn(clazz, clazz2);
    }

    public VisibilityChecker<?> getVisibilityChecker() {
        return this._serializationConfig.getDefaultVisibilityChecker();
    }

    public ObjectMapper setVisibility(VisibilityChecker<?> visibilityChecker) {
        this._configOverrides.setDefaultVisibility(visibilityChecker);
        return this;
    }

    public ObjectMapper setVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        VisibilityChecker<?> visibilityChecker = this._configOverrides.getDefaultVisibility();
        visibilityChecker = visibilityChecker.withVisibility(propertyAccessor, visibility);
        this._configOverrides.setDefaultVisibility(visibilityChecker);
        return this;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setSubtypeResolver(SubtypeResolver subtypeResolver) {
        this._subtypeResolver = subtypeResolver;
        this._deserializationConfig = this._deserializationConfig.with(subtypeResolver);
        this._serializationConfig = this._serializationConfig.with(subtypeResolver);
        return this;
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(annotationIntrospector);
        return this;
    }

    public ObjectMapper setAnnotationIntrospectors(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(annotationIntrospector2);
        return this;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(propertyNamingStrategy);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(propertyNamingStrategy);
        return this;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._serializationConfig.getPropertyNamingStrategy();
    }

    public ObjectMapper setDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._serializationConfig = this._serializationConfig.withDefaultPrettyPrinter(prettyPrinter);
        return this;
    }

    @Deprecated
    public void setVisibilityChecker(VisibilityChecker<?> visibilityChecker) {
        this.setVisibility(visibilityChecker);
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include include) {
        this.setPropertyInclusion(JsonInclude.Value.construct(include, include));
        return this;
    }

    @Deprecated
    public ObjectMapper setPropertyInclusion(JsonInclude.Value value) {
        return this.setDefaultPropertyInclusion(value);
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Value value) {
        this._configOverrides.setDefaultInclusion(value);
        return this;
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Include include) {
        this._configOverrides.setDefaultInclusion(JsonInclude.Value.construct(include, include));
        return this;
    }

    public ObjectMapper setDefaultSetterInfo(JsonSetter.Value value) {
        this._configOverrides.setDefaultSetterInfo(value);
        return this;
    }

    public ObjectMapper setDefaultVisibility(JsonAutoDetect.Value value) {
        this._configOverrides.setDefaultVisibility(VisibilityChecker.Std.construct(value));
        return this;
    }

    public ObjectMapper setDefaultMergeable(Boolean bl2) {
        this._configOverrides.setDefaultMergeable(bl2);
        return this;
    }

    public ObjectMapper enableDefaultTyping() {
        return this.enableDefaultTyping(DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public ObjectMapper enableDefaultTyping(DefaultTyping defaultTyping) {
        return this.enableDefaultTyping(defaultTyping, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    public ObjectMapper enableDefaultTyping(DefaultTyping defaultTyping, JsonTypeInfo.As as2) {
        if (as2 == JsonTypeInfo.As.EXTERNAL_PROPERTY) {
            throw new IllegalArgumentException("Cannot use includeAs of " + (Object)((Object)as2));
        }
        DefaultTypeResolverBuilder defaultTypeResolverBuilder = new DefaultTypeResolverBuilder(defaultTyping);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.init(JsonTypeInfo.Id.CLASS, null);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.inclusion(as2);
        return this.setDefaultTyping(defaultTypeResolverBuilder);
    }

    public ObjectMapper enableDefaultTypingAsProperty(DefaultTyping defaultTyping, String string) {
        DefaultTypeResolverBuilder defaultTypeResolverBuilder = new DefaultTypeResolverBuilder(defaultTyping);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.init(JsonTypeInfo.Id.CLASS, null);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.inclusion(JsonTypeInfo.As.PROPERTY);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.typeProperty(string);
        return this.setDefaultTyping(defaultTypeResolverBuilder);
    }

    public ObjectMapper disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public ObjectMapper setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(typeResolverBuilder);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(typeResolverBuilder);
        return this;
    }

    public void registerSubtypes(Class<?> ... classArray) {
        this.getSubtypeResolver().registerSubtypes(classArray);
    }

    public void registerSubtypes(NamedType ... namedTypeArray) {
        this.getSubtypeResolver().registerSubtypes(namedTypeArray);
    }

    public void registerSubtypes(Collection<Class<?>> collection) {
        this.getSubtypeResolver().registerSubtypes(collection);
    }

    public MutableConfigOverride configOverride(Class<?> clazz) {
        return this._configOverrides.findOrCreateOverride(clazz);
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public ObjectMapper setTypeFactory(TypeFactory typeFactory) {
        this._typeFactory = typeFactory;
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(typeFactory);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(typeFactory);
        return this;
    }

    public JavaType constructType(Type type) {
        return this._typeFactory.constructType(type);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    public ObjectMapper setNodeFactory(JsonNodeFactory jsonNodeFactory) {
        this._deserializationConfig = this._deserializationConfig.with(jsonNodeFactory);
        return this;
    }

    public ObjectMapper addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        this._deserializationConfig = this._deserializationConfig.withHandler(deserializationProblemHandler);
        return this;
    }

    public ObjectMapper clearProblemHandlers() {
        this._deserializationConfig = this._deserializationConfig.withNoProblemHandlers();
        return this;
    }

    public ObjectMapper setConfig(DeserializationConfig deserializationConfig) {
        this._deserializationConfig = deserializationConfig;
        return this;
    }

    @Deprecated
    public void setFilters(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
    }

    public ObjectMapper setFilterProvider(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
        return this;
    }

    public ObjectMapper setBase64Variant(Base64Variant base64Variant) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(base64Variant);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(base64Variant);
        return this;
    }

    public ObjectMapper setConfig(SerializationConfig serializationConfig) {
        this._serializationConfig = serializationConfig;
        return this;
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    @Override
    @Deprecated
    public JsonFactory getJsonFactory() {
        return this.getFactory();
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(dateFormat);
        this._serializationConfig = this._serializationConfig.with(dateFormat);
        return this;
    }

    public DateFormat getDateFormat() {
        return this._serializationConfig.getDateFormat();
    }

    public Object setHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(handlerInstantiator);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(handlerInstantiator);
        return this;
    }

    public ObjectMapper setInjectableValues(InjectableValues injectableValues) {
        this._injectableValues = injectableValues;
        return this;
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public ObjectMapper setLocale(Locale locale) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(locale);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(locale);
        return this;
    }

    public ObjectMapper setTimeZone(TimeZone timeZone) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(timeZone);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(timeZone);
        return this;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    public ObjectMapper configure(MapperFeature mapperFeature, boolean bl2) {
        this._serializationConfig = bl2 ? (SerializationConfig)this._serializationConfig.with(new MapperFeature[]{mapperFeature}) : (SerializationConfig)this._serializationConfig.without(new MapperFeature[]{mapperFeature});
        this._deserializationConfig = bl2 ? (DeserializationConfig)this._deserializationConfig.with(new MapperFeature[]{mapperFeature}) : (DeserializationConfig)this._deserializationConfig.without(new MapperFeature[]{mapperFeature});
        return this;
    }

    public ObjectMapper enable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(mapperFeatureArray);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(mapperFeatureArray);
        return this;
    }

    public ObjectMapper disable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.without(mapperFeatureArray);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.without(mapperFeatureArray);
        return this;
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._serializationConfig.isEnabled(serializationFeature);
    }

    public ObjectMapper configure(SerializationFeature serializationFeature, boolean bl2) {
        this._serializationConfig = bl2 ? this._serializationConfig.with(serializationFeature) : this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature, serializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature, serializationFeatureArray);
        return this;
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._deserializationConfig.isEnabled(deserializationFeature);
    }

    public ObjectMapper configure(DeserializationFeature deserializationFeature, boolean bl2) {
        this._deserializationConfig = bl2 ? this._deserializationConfig.with(deserializationFeature) : this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._deserializationConfig.isEnabled(feature, this._jsonFactory);
    }

    public ObjectMapper configure(JsonParser.Feature feature, boolean bl2) {
        this._jsonFactory.configure(feature, bl2);
        return this;
    }

    public ObjectMapper enable(JsonParser.Feature ... featureArray) {
        for (JsonParser.Feature feature : featureArray) {
            this._jsonFactory.enable(feature);
        }
        return this;
    }

    public ObjectMapper disable(JsonParser.Feature ... featureArray) {
        for (JsonParser.Feature feature : featureArray) {
            this._jsonFactory.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this._serializationConfig.isEnabled(feature, this._jsonFactory);
    }

    public ObjectMapper configure(JsonGenerator.Feature feature, boolean bl2) {
        this._jsonFactory.configure(feature, bl2);
        return this;
    }

    public ObjectMapper enable(JsonGenerator.Feature ... featureArray) {
        for (JsonGenerator.Feature feature : featureArray) {
            this._jsonFactory.enable(feature);
        }
        return this;
    }

    public ObjectMapper disable(JsonGenerator.Feature ... featureArray) {
        for (JsonGenerator.Feature feature : featureArray) {
            this._jsonFactory.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(JsonFactory.Feature feature) {
        return this._jsonFactory.isEnabled(feature);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(typeReference));
    }

    @Override
    public final <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, (JavaType)resolvedType);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, javaType);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException, JsonProcessingException {
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            return null;
        }
        JsonNode jsonNode = (JsonNode)this._readValue(deserializationConfig, jsonParser, JSON_NODE_TYPE);
        if (jsonNode == null) {
            jsonNode = this.getNodeFactory().nullNode();
        }
        JsonNode jsonNode2 = jsonNode;
        return (T)jsonNode2;
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, JavaType javaType) throws IOException, JsonProcessingException {
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
        return new MappingIterator(javaType, jsonParser, defaultDeserializationContext, jsonDeserializer, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, Class<T> clazz) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, this._typeFactory.constructType(clazz));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, this._typeFactory.constructType(typeReference));
    }

    public JsonNode readTree(InputStream inputStream) throws IOException {
        return this._readTreeAndClose(this._jsonFactory.createParser(inputStream));
    }

    public JsonNode readTree(Reader reader) throws IOException {
        return this._readTreeAndClose(this._jsonFactory.createParser(reader));
    }

    public JsonNode readTree(String string) throws IOException {
        return this._readTreeAndClose(this._jsonFactory.createParser(string));
    }

    public JsonNode readTree(byte[] byArray) throws IOException {
        return this._readTreeAndClose(this._jsonFactory.createParser(byArray));
    }

    public JsonNode readTree(File file) throws IOException, JsonProcessingException {
        return this._readTreeAndClose(this._jsonFactory.createParser(file));
    }

    public JsonNode readTree(URL uRL) throws IOException {
        return this._readTreeAndClose(this._jsonFactory.createParser(uRL));
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT) && jsonGenerator.getPrettyPrinter() == null) {
            jsonGenerator.setPrettyPrinter(serializationConfig.constructDefaultPrettyPrinter());
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, serializationConfig);
        } else {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws IOException, JsonProcessingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, treeNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeTree(JsonGenerator jsonGenerator, JsonNode jsonNode) throws IOException, JsonProcessingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, jsonNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    @Override
    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws JsonProcessingException {
        try {
            Object object;
            if (clazz != Object.class && clazz.isAssignableFrom(treeNode.getClass())) {
                return (T)treeNode;
            }
            if (treeNode.asToken() == JsonToken.VALUE_EMBEDDED_OBJECT && treeNode instanceof POJONode && ((object = ((POJONode)treeNode).getPojo()) == null || clazz.isInstance(object))) {
                return (T)object;
            }
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T extends JsonNode> T valueToTree(Object object) throws IllegalArgumentException {
        JsonNode jsonNode;
        if (object == null) {
            return null;
        }
        TokenBuffer tokenBuffer = new TokenBuffer(this, false);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            tokenBuffer = tokenBuffer.forceUseOfBigDecimal(true);
        }
        try {
            this.writeValue(tokenBuffer, object);
            JsonParser jsonParser = tokenBuffer.asParser();
            jsonNode = (JsonNode)this.readTree(jsonParser);
            jsonParser.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        return (T)jsonNode;
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz, atomicReference);
    }

    public boolean canDeserialize(JavaType javaType) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType, null);
    }

    public boolean canDeserialize(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType, atomicReference);
    }

    public <T> T readValue(File file, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(File file, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(File file, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), javaType);
    }

    public <T> T readValue(URL uRL, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(URL uRL, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(URL uRL, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), javaType);
    }

    public <T> T readValue(String string, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(String string, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(String string, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), javaType);
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(Reader reader, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(Reader reader, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), javaType);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(InputStream inputStream, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(InputStream inputStream, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), javaType);
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n2, n3), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n2, n3), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), javaType);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n2, n3), javaType);
    }

    public <T> T readValue(DataInput dataInput, Class<T> clazz) throws IOException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(dataInput), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(DataInput dataInput, JavaType javaType) throws IOException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(dataInput), javaType);
    }

    public void writeValue(File file, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) throws IOException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(dataOutput, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(segmentedStringWriter), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) throws JsonProcessingException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public ObjectWriter writer() {
        return this._newWriter(this.getSerializationConfig());
    }

    public ObjectWriter writer(SerializationFeature serializationFeature) {
        return this._newWriter(this.getSerializationConfig().with(serializationFeature));
    }

    public ObjectWriter writer(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        return this._newWriter(this.getSerializationConfig().with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter writer(DateFormat dateFormat) {
        return this._newWriter(this.getSerializationConfig().with(dateFormat));
    }

    public ObjectWriter writerWithView(Class<?> clazz) {
        return this._newWriter((SerializationConfig)this.getSerializationConfig().withView((Class)clazz));
    }

    public ObjectWriter writerFor(Class<?> clazz) {
        return this._newWriter(this.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    public ObjectWriter writerFor(TypeReference<?> typeReference) {
        return this._newWriter(this.getSerializationConfig(), typeReference == null ? null : this._typeFactory.constructType(typeReference), null);
    }

    public ObjectWriter writerFor(JavaType javaType) {
        return this._newWriter(this.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writer(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == null) {
            prettyPrinter = ObjectWriter.NULL_PRETTY_PRINTER;
        }
        return this._newWriter(this.getSerializationConfig(), null, prettyPrinter);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        return this._newWriter(serializationConfig, null, serializationConfig.getDefaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        return this._newWriter(this.getSerializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        return this._newWriter(this.getSerializationConfig(), formatSchema);
    }

    public ObjectWriter writer(Base64Variant base64Variant) {
        return this._newWriter((SerializationConfig)this.getSerializationConfig().with(base64Variant));
    }

    public ObjectWriter writer(CharacterEscapes characterEscapes) {
        return this._newWriter(this.getSerializationConfig()).with(characterEscapes);
    }

    public ObjectWriter writer(ContextAttributes contextAttributes) {
        return this._newWriter(this.getSerializationConfig().with(contextAttributes));
    }

    @Deprecated
    public ObjectWriter writerWithType(Class<?> clazz) {
        return this._newWriter(this.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    @Deprecated
    public ObjectWriter writerWithType(TypeReference<?> typeReference) {
        return this._newWriter(this.getSerializationConfig(), typeReference == null ? null : this._typeFactory.constructType(typeReference), null);
    }

    @Deprecated
    public ObjectWriter writerWithType(JavaType javaType) {
        return this._newWriter(this.getSerializationConfig(), javaType, null);
    }

    public ObjectReader reader() {
        return this._newReader(this.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature) {
        return this._newReader(this.getDeserializationConfig().with(deserializationFeature));
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._newReader(this.getDeserializationConfig().with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader readerForUpdating(Object object) {
        JavaType javaType = this._typeFactory.constructType(object.getClass());
        return this._newReader(this.getDeserializationConfig(), javaType, object, null, this._injectableValues);
    }

    public ObjectReader readerFor(JavaType javaType) {
        return this._newReader(this.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    public ObjectReader readerFor(Class<?> clazz) {
        return this._newReader(this.getDeserializationConfig(), this._typeFactory.constructType(clazz), null, null, this._injectableValues);
    }

    public ObjectReader readerFor(TypeReference<?> typeReference) {
        return this._newReader(this.getDeserializationConfig(), this._typeFactory.constructType(typeReference), null, null, this._injectableValues);
    }

    public ObjectReader reader(JsonNodeFactory jsonNodeFactory) {
        return this._newReader(this.getDeserializationConfig()).with(jsonNodeFactory);
    }

    public ObjectReader reader(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        return this._newReader(this.getDeserializationConfig(), null, null, formatSchema, this._injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        return this._newReader(this.getDeserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> clazz) {
        return this._newReader((DeserializationConfig)this.getDeserializationConfig().withView((Class)clazz));
    }

    public ObjectReader reader(Base64Variant base64Variant) {
        return this._newReader((DeserializationConfig)this.getDeserializationConfig().with(base64Variant));
    }

    public ObjectReader reader(ContextAttributes contextAttributes) {
        return this._newReader(this.getDeserializationConfig().with(contextAttributes));
    }

    @Deprecated
    public ObjectReader reader(JavaType javaType) {
        return this._newReader(this.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    @Deprecated
    public ObjectReader reader(Class<?> clazz) {
        return this._newReader(this.getDeserializationConfig(), this._typeFactory.constructType(clazz), null, null, this._injectableValues);
    }

    @Deprecated
    public ObjectReader reader(TypeReference<?> typeReference) {
        return this._newReader(this.getDeserializationConfig(), this._typeFactory.constructType(typeReference), null, null, this._injectableValues);
    }

    public <T> T convertValue(Object object, Class<T> clazz) throws IllegalArgumentException {
        return (T)this._convert(object, this._typeFactory.constructType(clazz));
    }

    public <T> T convertValue(Object object, TypeReference<?> typeReference) throws IllegalArgumentException {
        return (T)this._convert(object, this._typeFactory.constructType(typeReference));
    }

    public <T> T convertValue(Object object, JavaType javaType) throws IllegalArgumentException {
        return (T)this._convert(object, javaType);
    }

    protected Object _convert(Object object, JavaType javaType) throws IllegalArgumentException {
        Object object2;
        if (object != null && (object2 = javaType.getRawClass()) != Object.class && !javaType.hasGenericTypes() && ((Class)object2).isAssignableFrom(object.getClass())) {
            return object;
        }
        object2 = new TokenBuffer(this, false);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            object2 = ((TokenBuffer)object2).forceUseOfBigDecimal(true);
        }
        try {
            Object object3;
            SerializationConfig serializationConfig = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
            this._serializerProvider(serializationConfig).serializeValue((JsonGenerator)object2, object);
            JsonParser jsonParser = ((TokenBuffer)object2).asParser();
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            JsonToken jsonToken = this._initForReading(jsonParser, javaType);
            if (jsonToken == JsonToken.VALUE_NULL) {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                object3 = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext);
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object3 = null;
            } else {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
                object3 = jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            }
            jsonParser.close();
            return object3;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T> T updateValue(T t2, Object object) throws JsonMappingException {
        T t3 = t2;
        if (t2 != null && object != null) {
            TokenBuffer tokenBuffer = new TokenBuffer(this, false);
            if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                tokenBuffer = tokenBuffer.forceUseOfBigDecimal(true);
            }
            try {
                SerializationConfig serializationConfig = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
                this._serializerProvider(serializationConfig).serializeValue(tokenBuffer, object);
                JsonParser jsonParser = tokenBuffer.asParser();
                t3 = this.readerForUpdating(t2).readValue(jsonParser);
                jsonParser.close();
            }
            catch (IOException iOException) {
                if (iOException instanceof JsonMappingException) {
                    throw (JsonMappingException)iOException;
                }
                throw JsonMappingException.fromUnexpectedIOE(iOException);
            }
        }
        return t3;
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        return this._serializerProvider(this.getSerializationConfig()).generateJsonSchema(clazz);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider(this.getSerializationConfig()).acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        serializationConfig.initialize(jsonGenerator);
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, serializationConfig);
            return;
        }
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _configAndWriteCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception);
            return;
        }
        closeable.close();
    }

    protected Object _readValue(DeserializationConfig deserializationConfig, JsonParser jsonParser, JavaType javaType) throws IOException {
        Object object;
        JsonToken jsonToken = this._initForReading(jsonParser, javaType);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        if (jsonToken == JsonToken.VALUE_NULL) {
            object = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext);
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object = null;
        } else {
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
            object = deserializationConfig.useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, deserializationConfig, javaType, jsonDeserializer) : jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
        }
        jsonParser.clearCurrentToken();
        if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, javaType);
        }
        return object;
    }

    protected Object _readMapAndClose(JsonParser jsonParser, JavaType javaType) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            Object object;
            Object object2;
            JsonToken jsonToken = this._initForReading(jsonParser2, javaType);
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2, deserializationConfig);
            if (jsonToken == JsonToken.VALUE_NULL) {
                object2 = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext);
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object2 = null;
            } else {
                object = this._findRootDeserializer(defaultDeserializationContext, javaType);
                object2 = deserializationConfig.useRootWrapping() ? this._unwrapAndDeserialize(jsonParser2, defaultDeserializationContext, deserializationConfig, javaType, (JsonDeserializer<Object>)object) : ((JsonDeserializer)object).deserialize(jsonParser2, defaultDeserializationContext);
                ((DeserializationContext)defaultDeserializationContext).checkUnresolvedObjectId();
            }
            if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(jsonParser2, defaultDeserializationContext, javaType);
            }
            object = object2;
            return object;
        }
    }

    protected JsonNode _readTreeAndClose(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            Object object;
            JavaType javaType = JSON_NODE_TYPE;
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            deserializationConfig.initialize(jsonParser2);
            JsonToken jsonToken = jsonParser2.getCurrentToken();
            if (jsonToken == null && (jsonToken = jsonParser2.nextToken()) == null) {
                JsonNode jsonNode = null;
                return jsonNode;
            }
            if (jsonToken == JsonToken.VALUE_NULL) {
                NullNode nullNode = deserializationConfig.getNodeFactory().nullNode();
                return nullNode;
            }
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2, deserializationConfig);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
            if (deserializationConfig.useRootWrapping()) {
                object = this._unwrapAndDeserialize(jsonParser2, defaultDeserializationContext, deserializationConfig, javaType, jsonDeserializer);
            } else {
                object = jsonDeserializer.deserialize(jsonParser2, defaultDeserializationContext);
                if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    this._verifyNoTrailingTokens(jsonParser2, defaultDeserializationContext, javaType);
                }
            }
            JsonNode jsonNode = (JsonNode)object;
            return jsonNode;
        }
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) throws IOException {
        String string;
        PropertyName propertyName = deserializationConfig.findRootName(javaType);
        String string2 = propertyName.getSimpleName();
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            deserializationContext.reportWrongTokenException(javaType, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", new Object[]{string2, jsonParser.getCurrentToken()});
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            deserializationContext.reportWrongTokenException(javaType, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", new Object[]{string2, jsonParser.getCurrentToken()});
        }
        if (!string2.equals(string = jsonParser.getCurrentName())) {
            deserializationContext.reportInputMismatch(javaType, "Root name '%s' does not match expected ('%s') for type %s", string, string2, javaType);
        }
        jsonParser.nextToken();
        Object object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            deserializationContext.reportWrongTokenException(javaType, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", new Object[]{string2, jsonParser.getCurrentToken()});
        }
        if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, deserializationContext, javaType);
        }
        return object;
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._deserializationContext.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected JsonToken _initForReading(JsonParser jsonParser, JavaType javaType) throws IOException {
        this._deserializationConfig.initialize(jsonParser);
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw MismatchedInputException.from(jsonParser, javaType, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    @Deprecated
    protected JsonToken _initForReading(JsonParser jsonParser) throws IOException {
        return this._initForReading(jsonParser, null);
    }

    protected final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            Class<?> clazz = ClassUtil.rawClass(javaType);
            deserializationContext.reportTrailingTokens(clazz, jsonParser, jsonToken);
        }
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._jsonFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._jsonFactory.getFormatName());
        }
    }

    public static class DefaultTypeResolverBuilder
    extends StdTypeResolverBuilder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final DefaultTyping _appliesFor;

        public DefaultTypeResolverBuilder(DefaultTyping defaultTyping) {
            this._appliesFor = defaultTyping;
        }

        @Override
        public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> collection) {
            return this.useForType(javaType) ? super.buildTypeDeserializer(deserializationConfig, javaType, collection) : null;
        }

        @Override
        public TypeSerializer buildTypeSerializer(SerializationConfig serializationConfig, JavaType javaType, Collection<NamedType> collection) {
            return this.useForType(javaType) ? super.buildTypeSerializer(serializationConfig, javaType, collection) : null;
        }

        public boolean useForType(JavaType javaType) {
            if (javaType.isPrimitive()) {
                return false;
            }
            switch (this._appliesFor) {
                case NON_CONCRETE_AND_ARRAYS: {
                    while (javaType.isArrayType()) {
                        javaType = javaType.getContentType();
                    }
                }
                case OBJECT_AND_NON_CONCRETE: {
                    while (javaType.isReferenceType()) {
                        javaType = javaType.getReferencedType();
                    }
                    return javaType.isJavaLangObject() || !javaType.isConcrete() && !TreeNode.class.isAssignableFrom(javaType.getRawClass());
                }
                case NON_FINAL: {
                    while (javaType.isArrayType()) {
                        javaType = javaType.getContentType();
                    }
                    while (javaType.isReferenceType()) {
                        javaType = javaType.getReferencedType();
                    }
                    return !javaType.isFinal() && !TreeNode.class.isAssignableFrom(javaType.getRawClass());
                }
            }
            return javaType.isJavaLangObject();
        }
    }

    public static enum DefaultTyping {
        JAVA_LANG_OBJECT,
        OBJECT_AND_NON_CONCRETE,
        NON_CONCRETE_AND_ARRAYS,
        NON_FINAL;

    }
}

