/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.Serializable;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;

public class PropertyNamingStrategy
implements Serializable {
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new PropertyNamingStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES = SNAKE_CASE;
    @Deprecated
    public static final PropertyNamingStrategy PASCAL_CASE_TO_CAMEL_CASE = UPPER_CAMEL_CASE;

    public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
        return string;
    }

    public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
        return string;
    }

    @Deprecated
    public static class PascalCaseStrategy
    extends UpperCamelCaseStrategy {
    }

    @Deprecated
    public static class LowerCaseWithUnderscoresStrategy
    extends SnakeCaseStrategy {
    }

    public static class KebabCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            if (n2 == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(n2 + (n2 >> 1));
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                char c3 = Character.toLowerCase(c2);
                if (c3 == c2) {
                    if (n3 > 1) {
                        stringBuilder.insert(stringBuilder.length() - 1, '-');
                    }
                    n3 = 0;
                } else {
                    if (n3 == 0 && i2 > 0) {
                        stringBuilder.append('-');
                    }
                    ++n3;
                }
                stringBuilder.append(c3);
            }
            return stringBuilder.toString();
        }
    }

    public static class LowerCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            return string.toLowerCase();
        }
    }

    public static class UpperCamelCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            char c2;
            if (string == null || string.length() == 0) {
                return string;
            }
            char c3 = string.charAt(0);
            if (c3 == (c2 = Character.toUpperCase(c3))) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, c2);
            return stringBuilder.toString();
        }
    }

    public static class SnakeCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2 * 2);
            int n3 = 0;
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (i2 <= 0 && c2 == '_') continue;
                if (Character.isUpperCase(c2)) {
                    if (!bl2 && n3 > 0 && stringBuilder.charAt(n3 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n3;
                    }
                    c2 = Character.toLowerCase(c2);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                stringBuilder.append(c2);
                ++n3;
            }
            return n3 > 0 ? stringBuilder.toString() : string;
        }
    }

    public static abstract class PropertyNamingStrategyBase
    extends PropertyNamingStrategy {
        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);
    }
}

