/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind;

import java.io.Serializable;
import java.text.DateFormat;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.core.FormatFeature;
import zz.com.fasterxml.jackson.core.JsonFactory;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.PrettyPrinter;
import zz.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import zz.com.fasterxml.jackson.core.util.Instantiatable;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.SerializationFeature;
import zz.com.fasterxml.jackson.databind.cfg.BaseSettings;
import zz.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import zz.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import zz.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import zz.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import zz.com.fasterxml.jackson.databind.ser.FilterProvider;
import zz.com.fasterxml.jackson.databind.util.RootNameLookup;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _serFeatures;
    protected final int _generatorFeatures;
    protected final int _generatorFeaturesToChange;
    protected final int _formatWriteFeatures;
    protected final int _formatWriteFeaturesToChange;

    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = SerializationConfig.collectFeatureDefaults(SerializationFeature.class);
        this._filterProvider = null;
        this._defaultPrettyPrinter = DEFAULT_PRETTY_PRINTER;
        this._generatorFeatures = 0;
        this._generatorFeaturesToChange = 0;
        this._formatWriteFeatures = 0;
        this._formatWriteFeaturesToChange = 0;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(serializationConfig, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver) {
        super(serializationConfig, subtypeResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(serializationConfig, n2);
        this._serFeatures = n3;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = n4;
        this._generatorFeaturesToChange = n5;
        this._formatWriteFeatures = n6;
        this._formatWriteFeaturesToChange = n7;
    }

    private SerializationConfig(SerializationConfig serializationConfig, BaseSettings baseSettings) {
        super(serializationConfig, baseSettings);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, FilterProvider filterProvider) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, Class<?> clazz) {
        super(serializationConfig, clazz);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, PropertyName propertyName) {
        super(serializationConfig, propertyName);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, ContextAttributes contextAttributes) {
        super(serializationConfig, contextAttributes);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(serializationConfig, simpleMixInResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, PrettyPrinter prettyPrinter) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = prettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    @Override
    protected final SerializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new SerializationConfig(this, baseSettings);
    }

    @Override
    protected final SerializationConfig _withMapperFeatures(int n2) {
        return new SerializationConfig(this, n2, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    @Override
    public SerializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new SerializationConfig(this, propertyName);
    }

    @Override
    public SerializationConfig with(SubtypeResolver subtypeResolver) {
        return subtypeResolver == this._subtypeResolver ? this : new SerializationConfig(this, subtypeResolver);
    }

    @Override
    public SerializationConfig withView(Class<?> clazz) {
        return this._view == clazz ? this : new SerializationConfig(this, clazz);
    }

    @Override
    public SerializationConfig with(ContextAttributes contextAttributes) {
        return contextAttributes == this._attributes ? this : new SerializationConfig(this, contextAttributes);
    }

    @Override
    public SerializationConfig with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = (SerializationConfig)super.with(dateFormat);
        if (dateFormat == null) {
            return serializationConfig.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return serializationConfig.without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public SerializationConfig with(SerializationFeature serializationFeature) {
        int n2 = this._serFeatures | serializationFeature.getMask();
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures | serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n2 |= serializationFeature2.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withFeatures(SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n2 |= serializationFeature.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature) {
        int n2 = this._serFeatures & ~serializationFeature.getMask();
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures & ~serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n2 &= ~serializationFeature2.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n2 &= ~serializationFeature.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(JsonGenerator.Feature feature) {
        int n2 = this._generatorFeatures | feature.getMask();
        int n3 = this._generatorFeaturesToChange | feature.getMask();
        return this._generatorFeatures == n2 && this._generatorFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n2, n3, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withFeatures(JsonGenerator.Feature ... featureArray) {
        int n2 = this._generatorFeatures;
        int n3 = this._generatorFeaturesToChange;
        for (JsonGenerator.Feature feature : featureArray) {
            int n4 = feature.getMask();
            n2 |= n4;
            n3 |= n4;
        }
        return this._generatorFeatures == n2 && this._generatorFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n2, n3, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(JsonGenerator.Feature feature) {
        int n2 = this._generatorFeatures & ~feature.getMask();
        int n3 = this._generatorFeaturesToChange | feature.getMask();
        return this._generatorFeatures == n2 && this._generatorFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n2, n3, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withoutFeatures(JsonGenerator.Feature ... featureArray) {
        int n2 = this._generatorFeatures;
        int n3 = this._generatorFeaturesToChange;
        for (JsonGenerator.Feature feature : featureArray) {
            int n4 = feature.getMask();
            n2 &= ~n4;
            n3 |= n4;
        }
        return this._generatorFeatures == n2 && this._generatorFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n2, n3, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(FormatFeature formatFeature) {
        int n2 = this._formatWriteFeatures | formatFeature.getMask();
        int n3 = this._formatWriteFeaturesToChange | formatFeature.getMask();
        return this._formatWriteFeatures == n2 && this._formatWriteFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n2, n3);
    }

    public SerializationConfig withFeatures(FormatFeature ... formatFeatureArray) {
        int n2 = this._formatWriteFeatures;
        int n3 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n4 = formatFeature.getMask();
            n2 |= n4;
            n3 |= n4;
        }
        return this._formatWriteFeatures == n2 && this._formatWriteFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n2, n3);
    }

    public SerializationConfig without(FormatFeature formatFeature) {
        int n2 = this._formatWriteFeatures & ~formatFeature.getMask();
        int n3 = this._formatWriteFeaturesToChange | formatFeature.getMask();
        return this._formatWriteFeatures == n2 && this._formatWriteFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n2, n3);
    }

    public SerializationConfig withoutFeatures(FormatFeature ... formatFeatureArray) {
        int n2 = this._formatWriteFeatures;
        int n3 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n4 = formatFeature.getMask();
            n2 &= ~n4;
            n3 |= n4;
        }
        return this._formatWriteFeatures == n2 && this._formatWriteFeaturesToChange == n3 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n2, n3);
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        return filterProvider == this._filterProvider ? this : new SerializationConfig(this, filterProvider);
    }

    @Deprecated
    public SerializationConfig withPropertyInclusion(JsonInclude.Value value) {
        this._configOverrides.setDefaultInclusion(value);
        return this;
    }

    public SerializationConfig withDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this._defaultPrettyPrinter == prettyPrinter ? this : new SerializationConfig(this, prettyPrinter);
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        PrettyPrinter prettyPrinter = this._defaultPrettyPrinter;
        if (prettyPrinter instanceof Instantiatable) {
            prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
        }
        return prettyPrinter;
    }

    public void initialize(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter;
        if (SerializationFeature.INDENT_OUTPUT.enabledIn(this._serFeatures) && jsonGenerator.getPrettyPrinter() == null && (prettyPrinter = this.constructDefaultPrettyPrinter()) != null) {
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        }
        boolean bl2 = SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._serFeatures);
        int n2 = this._generatorFeaturesToChange;
        if (n2 != 0 || bl2) {
            int n3 = this._generatorFeatures;
            if (bl2) {
                int n4 = JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.getMask();
                n3 |= n4;
                n2 |= n4;
            }
            jsonGenerator.overrideStdFeatures(n3, n2);
        }
        if (this._formatWriteFeaturesToChange != 0) {
            jsonGenerator.overrideFormatFeatures(this._formatWriteFeatures, this._formatWriteFeaturesToChange);
        }
    }

    @Deprecated
    public JsonInclude.Include getSerializationInclusion() {
        JsonInclude.Include include = this.getDefaultPropertyInclusion().getValueInclusion();
        return include == JsonInclude.Include.USE_DEFAULTS ? JsonInclude.Include.ALWAYS : include;
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return (this._serFeatures & serializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature, JsonFactory jsonFactory) {
        int n2 = feature.getMask();
        if ((this._generatorFeaturesToChange & n2) != 0) {
            return (this._generatorFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int n2) {
        return (this._serFeatures & n2) == n2;
    }

    public final int getSerializationFeatures() {
        return this._serFeatures;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter getDefaultPrettyPrinter() {
        return this._defaultPrettyPrinter;
    }

    public <T extends BeanDescription> T introspect(JavaType javaType) {
        return (T)this.getClassIntrospector().forSerialization(this, javaType, this);
    }
}

