/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonSetter;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.core.SerializableString;
import zz.com.fasterxml.jackson.core.io.SerializedString;
import zz.com.fasterxml.jackson.core.type.TypeReference;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import zz.com.fasterxml.jackson.databind.cfg.BaseSettings;
import zz.com.fasterxml.jackson.databind.cfg.ConfigFeature;
import zz.com.fasterxml.jackson.databind.cfg.ConfigOverride;
import zz.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import zz.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import zz.com.fasterxml.jackson.databind.introspect.Annotated;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import zz.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import zz.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import zz.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class MapperConfig<T extends MapperConfig<T>>
implements Serializable,
ClassIntrospector.MixInResolver {
    private static final long serialVersionUID = 2L;
    protected static final JsonInclude.Value EMPTY_INCLUDE = JsonInclude.Value.empty();
    protected static final JsonFormat.Value EMPTY_FORMAT = JsonFormat.Value.empty();
    protected final int _mapperFeatures;
    protected final BaseSettings _base;

    protected MapperConfig(BaseSettings baseSettings, int n2) {
        this._base = baseSettings;
        this._mapperFeatures = n2;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig, int n2) {
        this._base = mapperConfig._base;
        this._mapperFeatures = n2;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig, BaseSettings baseSettings) {
        this._base = baseSettings;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig) {
        this._base = mapperConfig._base;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> clazz) {
        int n2 = 0;
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (!((ConfigFeature)((Object)enum_)).enabledByDefault()) continue;
            n2 |= ((ConfigFeature)((Object)enum_)).getMask();
        }
        return n2;
    }

    public abstract T with(MapperFeature ... var1);

    public abstract T without(MapperFeature ... var1);

    public abstract T with(MapperFeature var1, boolean var2);

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return (this._mapperFeatures & mapperFeature.getMask()) != 0;
    }

    public final boolean hasMapperFeatures(int n2) {
        return (this._mapperFeatures & n2) == n2;
    }

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public final boolean shouldSortPropertiesAlphabetically() {
        return this.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
    }

    public abstract boolean useRootWrapping();

    public SerializableString compileString(String string) {
        return new SerializedString(string);
    }

    public ClassIntrospector getClassIntrospector() {
        return this._base.getClassIntrospector();
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return this._base.getAnnotationIntrospector();
        }
        return NopAnnotationIntrospector.instance;
    }

    public final PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._base.getPropertyNamingStrategy();
    }

    public final HandlerInstantiator getHandlerInstantiator() {
        return this._base.getHandlerInstantiator();
    }

    public final TypeResolverBuilder<?> getDefaultTyper(JavaType javaType) {
        return this._base.getTypeResolverBuilder();
    }

    public abstract SubtypeResolver getSubtypeResolver();

    public final TypeFactory getTypeFactory() {
        return this._base.getTypeFactory();
    }

    public final JavaType constructType(Class<?> clazz) {
        return this.getTypeFactory().constructType(clazz);
    }

    public final JavaType constructType(TypeReference<?> typeReference) {
        return this.getTypeFactory().constructType(typeReference.getType());
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this.getTypeFactory().constructSpecializedType(javaType, clazz);
    }

    public BeanDescription introspectClassAnnotations(Class<?> clazz) {
        return this.introspectClassAnnotations(this.constructType(clazz));
    }

    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    public BeanDescription introspectDirectClassAnnotations(Class<?> clazz) {
        return this.introspectDirectClassAnnotations(this.constructType(clazz));
    }

    public final BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    public abstract ConfigOverride findConfigOverride(Class<?> var1);

    public abstract ConfigOverride getConfigOverride(Class<?> var1);

    public abstract JsonInclude.Value getDefaultPropertyInclusion();

    public abstract JsonInclude.Value getDefaultPropertyInclusion(Class<?> var1);

    public JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz, JsonInclude.Value value) {
        JsonInclude.Value value2 = this.getConfigOverride(clazz).getInclude();
        if (value2 != null) {
            return value2;
        }
        return value;
    }

    public abstract JsonInclude.Value getDefaultInclusion(Class<?> var1, Class<?> var2);

    public JsonInclude.Value getDefaultInclusion(Class<?> clazz, Class<?> clazz2, JsonInclude.Value value) {
        JsonInclude.Value value2 = this.getConfigOverride(clazz).getInclude();
        JsonInclude.Value value3 = this.getConfigOverride(clazz2).getIncludeAsProperty();
        JsonInclude.Value value4 = JsonInclude.Value.mergeAll(value, value2, value3);
        return value4;
    }

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> var1);

    public abstract JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> var1, AnnotatedClass var2);

    public abstract VisibilityChecker<?> getDefaultVisibilityChecker();

    public abstract VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> var1, AnnotatedClass var2);

    public abstract JsonSetter.Value getDefaultSetterInfo();

    public abstract Boolean getDefaultMergeable();

    public abstract Boolean getDefaultMergeable(Class<?> var1);

    public final DateFormat getDateFormat() {
        return this._base.getDateFormat();
    }

    public final Locale getLocale() {
        return this._base.getLocale();
    }

    public final TimeZone getTimeZone() {
        return this._base.getTimeZone();
    }

    public abstract Class<?> getActiveView();

    public Base64Variant getBase64Variant() {
        return this._base.getBase64Variant();
    }

    public abstract ContextAttributes getAttributes();

    public abstract PropertyName findRootName(JavaType var1);

    public abstract PropertyName findRootName(Class<?> var1);

    public TypeResolverBuilder<?> typeResolverBuilderInstance(Annotated annotated, Class<? extends TypeResolverBuilder<?>> clazz) {
        TypeResolverBuilder<?> typeResolverBuilder;
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (typeResolverBuilder = handlerInstantiator.typeResolverBuilderInstance(this, annotated, clazz)) != null) {
            return typeResolverBuilder;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }

    public TypeIdResolver typeIdResolverInstance(Annotated annotated, Class<? extends TypeIdResolver> clazz) {
        TypeIdResolver typeIdResolver;
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (typeIdResolver = handlerInstantiator.typeIdResolverInstance(this, annotated, clazz)) != null) {
            return typeIdResolver;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }
}

