/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import zz.com.fasterxml.jackson.annotation.JsonAutoDetect;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonSetter;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import zz.com.fasterxml.jackson.databind.cfg.BaseSettings;
import zz.com.fasterxml.jackson.databind.cfg.ConfigFeature;
import zz.com.fasterxml.jackson.databind.cfg.ConfigOverride;
import zz.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import zz.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import zz.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import zz.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import zz.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import zz.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.RootNameLookup;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    protected static final ConfigOverride EMPTY_OVERRIDE = ConfigOverride.empty();
    private static final int DEFAULT_MAPPER_FEATURES = MapperConfigBase.collectFeatureDefaults(MapperFeature.class);
    private static final int AUTO_DETECT_MASK = MapperFeature.AUTO_DETECT_FIELDS.getMask() | MapperFeature.AUTO_DETECT_GETTERS.getMask() | MapperFeature.AUTO_DETECT_IS_GETTERS.getMask() | MapperFeature.AUTO_DETECT_SETTERS.getMask() | MapperFeature.AUTO_DETECT_CREATORS.getMask();
    protected final SimpleMixInResolver _mixIns;
    protected final SubtypeResolver _subtypeResolver;
    protected final PropertyName _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;
    protected final RootNameLookup _rootNames;
    protected final ConfigOverrides _configOverrides;

    protected MapperConfigBase(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, DEFAULT_MAPPER_FEATURES);
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = subtypeResolver;
        this._rootNames = rootNameLookup;
        this._rootName = null;
        this._view = null;
        this._attributes = ContextAttributes.getEmpty();
        this._configOverrides = configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(mapperConfigBase);
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = rootNameLookup;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, BaseSettings baseSettings) {
        super(mapperConfigBase, baseSettings);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, int n2) {
        super(mapperConfigBase, n2);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, SubtypeResolver subtypeResolver) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, PropertyName propertyName) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = propertyName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, Class<?> clazz) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = clazz;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, SimpleMixInResolver simpleMixInResolver) {
        super(mapperConfigBase);
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, ContextAttributes contextAttributes) {
        super(mapperConfigBase);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = contextAttributes;
        this._configOverrides = mapperConfigBase._configOverrides;
    }

    protected abstract T _withBase(BaseSettings var1);

    protected abstract T _withMapperFeatures(int var1);

    @Override
    public final T with(MapperFeature ... mapperFeatureArray) {
        int n2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n2 |= mapperFeature.getMask();
        }
        if (n2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(n2);
    }

    @Override
    public final T without(MapperFeature ... mapperFeatureArray) {
        int n2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n2 &= ~mapperFeature.getMask();
        }
        if (n2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(n2);
    }

    @Override
    public final T with(MapperFeature mapperFeature, boolean bl2) {
        int n2 = bl2 ? this._mapperFeatures | mapperFeature.getMask() : this._mapperFeatures & ~mapperFeature.getMask();
        if (n2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(n2);
    }

    public final T with(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAnnotationIntrospector(annotationIntrospector));
    }

    public final T withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAppendedAnnotationIntrospector(annotationIntrospector));
    }

    public final T withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withInsertedAnnotationIntrospector(annotationIntrospector));
    }

    public final T with(ClassIntrospector classIntrospector) {
        return this._withBase(this._base.withClassIntrospector(classIntrospector));
    }

    public abstract T with(ContextAttributes var1);

    public T withAttributes(Map<?, ?> map) {
        return this.with(this.getAttributes().withSharedAttributes(map));
    }

    public T withAttribute(Object object, Object object2) {
        return this.with(this.getAttributes().withSharedAttribute(object, object2));
    }

    public T withoutAttribute(Object object) {
        return this.with(this.getAttributes().withoutSharedAttribute(object));
    }

    public final T with(TypeFactory typeFactory) {
        return this._withBase(this._base.withTypeFactory(typeFactory));
    }

    public final T with(TypeResolverBuilder<?> typeResolverBuilder) {
        return this._withBase(this._base.withTypeResolverBuilder(typeResolverBuilder));
    }

    public final T with(PropertyNamingStrategy propertyNamingStrategy) {
        return this._withBase(this._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    public final T with(HandlerInstantiator handlerInstantiator) {
        return this._withBase(this._base.withHandlerInstantiator(handlerInstantiator));
    }

    public final T with(Base64Variant base64Variant) {
        return this._withBase(this._base.with(base64Variant));
    }

    public T with(DateFormat dateFormat) {
        return this._withBase(this._base.withDateFormat(dateFormat));
    }

    public final T with(Locale locale) {
        return this._withBase(this._base.with(locale));
    }

    public final T with(TimeZone timeZone) {
        return this._withBase(this._base.with(timeZone));
    }

    public abstract T withRootName(PropertyName var1);

    public T withRootName(String string) {
        if (string == null) {
            return this.withRootName((PropertyName)null);
        }
        return this.withRootName(PropertyName.construct(string));
    }

    public abstract T with(SubtypeResolver var1);

    public abstract T withView(Class<?> var1);

    @Override
    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    @Deprecated
    public final String getRootName() {
        return this._rootName == null ? null : this._rootName.getSimpleName();
    }

    public final PropertyName getFullRootName() {
        return this._rootName;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final ConfigOverride getConfigOverride(Class<?> clazz) {
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        return configOverride == null ? EMPTY_OVERRIDE : configOverride;
    }

    @Override
    public final ConfigOverride findConfigOverride(Class<?> clazz) {
        return this._configOverrides.findOverride(clazz);
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion() {
        return this._configOverrides.getDefaultInclusion();
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz) {
        JsonInclude.Value value = this.getConfigOverride(clazz).getInclude();
        JsonInclude.Value value2 = this.getDefaultPropertyInclusion();
        if (value2 == null) {
            return value;
        }
        return value2.withOverrides(value);
    }

    @Override
    public final JsonInclude.Value getDefaultInclusion(Class<?> clazz, Class<?> clazz2) {
        JsonInclude.Value value = this.getConfigOverride(clazz2).getIncludeAsProperty();
        JsonInclude.Value value2 = this.getDefaultPropertyInclusion(clazz);
        if (value2 == null) {
            return value;
        }
        return value2.withOverrides(value);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        JsonFormat.Value value;
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        if (configOverride != null && (value = configOverride.getFormat()) != null) {
            return value;
        }
        return EMPTY_FORMAT;
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> clazz) {
        JsonIgnoreProperties.Value value;
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        if (configOverride != null && (value = configOverride.getIgnorals()) != null) {
            return value;
        }
        return null;
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> clazz, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = this.getAnnotationIntrospector();
        JsonIgnoreProperties.Value value = annotationIntrospector == null ? null : annotationIntrospector.findPropertyIgnorals(annotatedClass);
        JsonIgnoreProperties.Value value2 = this.getDefaultPropertyIgnorals(clazz);
        return JsonIgnoreProperties.Value.merge(value, value2);
    }

    @Override
    public final VisibilityChecker<?> getDefaultVisibilityChecker() {
        VisibilityChecker<?> visibilityChecker = this._configOverrides.getDefaultVisibility();
        if ((this._mapperFeatures & AUTO_DETECT_MASK) != 0) {
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
                visibilityChecker = visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_GETTERS)) {
                visibilityChecker = visibilityChecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_IS_GETTERS)) {
                visibilityChecker = visibilityChecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_SETTERS)) {
                visibilityChecker = visibilityChecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_CREATORS)) {
                visibilityChecker = visibilityChecker.withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
            }
        }
        return visibilityChecker;
    }

    @Override
    public final VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> clazz, AnnotatedClass annotatedClass) {
        ConfigOverride configOverride;
        VisibilityChecker<?> visibilityChecker = this.getDefaultVisibilityChecker();
        AnnotationIntrospector annotationIntrospector = this.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            visibilityChecker = annotationIntrospector.findAutoDetectVisibility(annotatedClass, visibilityChecker);
        }
        if ((configOverride = this._configOverrides.findOverride(clazz)) != null) {
            visibilityChecker = visibilityChecker.withOverrides(configOverride.getVisibility());
        }
        return visibilityChecker;
    }

    @Override
    public final JsonSetter.Value getDefaultSetterInfo() {
        return this._configOverrides.getDefaultSetterInfo();
    }

    @Override
    public Boolean getDefaultMergeable() {
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public Boolean getDefaultMergeable(Class<?> clazz) {
        Boolean bl2;
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        if (configOverride != null && (bl2 = configOverride.getMergeable()) != null) {
            return bl2;
        }
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public PropertyName findRootName(JavaType javaType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(javaType, this);
    }

    @Override
    public PropertyName findRootName(Class<?> clazz) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(clazz, this);
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixIns.findMixInClassFor(clazz);
    }

    @Override
    public ClassIntrospector.MixInResolver copy() {
        throw new UnsupportedOperationException();
    }

    public final int mixInCount() {
        return this._mixIns.localSize();
    }
}

