/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import zz.com.fasterxml.jackson.annotation.JacksonInject;
import zz.com.fasterxml.jackson.annotation.JsonCreator;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.core.JsonLocation;
import zz.com.fasterxml.jackson.databind.AbstractTypeResolver;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.KeyDeserializer;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyMetadata;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import zz.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import zz.com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import zz.com.fasterxml.jackson.databind.deser.CreatorProperty;
import zz.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import zz.com.fasterxml.jackson.databind.deser.Deserializers;
import zz.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import zz.com.fasterxml.jackson.databind.deser.impl.CreatorCandidate;
import zz.com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import zz.com.fasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers;
import zz.com.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import zz.com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import zz.com.fasterxml.jackson.databind.deser.std.JsonLocationInstantiator;
import zz.com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import zz.com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import zz.com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import zz.com.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import zz.com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import zz.com.fasterxml.jackson.databind.introspect.Annotated;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import zz.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import zz.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import zz.com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import zz.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import zz.com.fasterxml.jackson.databind.jsontype.NamedType;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.type.ArrayType;
import zz.com.fasterxml.jackson.databind.type.CollectionLikeType;
import zz.com.fasterxml.jackson.databind.type.CollectionType;
import zz.com.fasterxml.jackson.databind.type.MapLikeType;
import zz.com.fasterxml.jackson.databind.type.MapType;
import zz.com.fasterxml.jackson.databind.type.ReferenceType;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.ConstantValueInstantiator;
import zz.com.fasterxml.jackson.databind.util.EnumResolver;
import zz.com.fasterxml.jackson.databind.util.NameTransformer;
import zz.com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import zz.com.fasterxml.jackson.databind.util.TokenBuffer;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_BUFFER = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        return this.withConfig(this._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        return this.withConfig(this._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        return this.withConfig(this._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        while ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) != null) {
            Class<?> clazz;
            Class<?> clazz2 = javaType.getRawClass();
            if (clazz2 == (clazz = javaType2.getRawClass()) || !clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
            }
            javaType = javaType2;
        }
        return javaType;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType javaType2 = abstractTypeResolver.findTypeMapping(deserializationConfig, javaType);
                if (ClassUtil.rawClass(javaType2) == clazz) continue;
                return javaType2;
            }
        }
        return null;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object = deserializationContext.getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object);
        }
        if (valueInstantiator == null && (valueInstantiator = this._findStdValueInstantiator(deserializationConfig, beanDescription)) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators object2 : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = object2.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                deserializationContext.reportBadTypeDefinition(beanDescription, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", object2.getClass().getName());
            }
        }
        if (valueInstantiator.getIncompleteParameter() != null) {
            AnnotatedParameter annotatedParameter = valueInstantiator.getIncompleteParameter();
            AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
            throw new IllegalArgumentException("Argument #" + annotatedParameter.getIndex() + " of constructor " + annotatedWithParams + " has no property name annotation; must have name when multiple-parameter constructor annotated as Creator");
        }
        return valueInstantiator;
    }

    private ValueInstantiator _findStdValueInstantiator(DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = beanDescription.getBeanClass();
        if (clazz == JsonLocation.class) {
            return new JsonLocationInstantiator();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (Collections.EMPTY_SET.getClass() == clazz) {
                return new ConstantValueInstantiator(Collections.EMPTY_SET);
            }
            if (Collections.EMPTY_LIST.getClass() == clazz) {
                return new ConstantValueInstantiator(Collections.EMPTY_LIST);
            }
        } else if (Map.class.isAssignableFrom(clazz) && Collections.EMPTY_MAP.getClass() == clazz) {
            return new ConstantValueInstantiator(Collections.EMPTY_MAP);
        }
        return null;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        CreatorCollector creatorCollector = new CreatorCollector(beanDescription, deserializationContext.getConfig());
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        VisibilityChecker<?> visibilityChecker = deserializationConfig.getDefaultVisibilityChecker(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = this._findCreatorsFromProperties(deserializationContext, beanDescription);
        this._addDeserializerFactoryMethods(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, map);
        if (beanDescription.getType().isConcrete()) {
            this._addDeserializerConstructors(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, map);
        }
        return creatorCollector.constructValueInstantiator(deserializationConfig);
    }

    protected Map<AnnotatedWithParams, BeanPropertyDefinition[]> _findCreatorsFromProperties(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = Collections.emptyMap();
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            Iterator<AnnotatedParameter> iterator = beanPropertyDefinition.getConstructorParameters();
            while (iterator.hasNext()) {
                AnnotatedParameter annotatedParameter = iterator.next();
                AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
                BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
                int n2 = annotatedParameter.getIndex();
                if (beanPropertyDefinitionArray == null) {
                    if (map.isEmpty()) {
                        map = new LinkedHashMap<AnnotatedWithParams, BeanPropertyDefinition[]>();
                    }
                    beanPropertyDefinitionArray = new BeanPropertyDefinition[annotatedWithParams.getParameterCount()];
                    map.put(annotatedWithParams, beanPropertyDefinitionArray);
                } else if (beanPropertyDefinitionArray[n2] != null) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Conflict: parameter #%d of %s bound to more than one property; %s vs %s", n2, annotatedWithParams, beanPropertyDefinitionArray[n2], beanPropertyDefinition);
                }
                beanPropertyDefinitionArray[n2] = beanPropertyDefinition;
            }
        }
        return map;
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated annotated, Object object) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        if (object == null) {
            return null;
        }
        if (object instanceof ValueInstantiator) {
            return (ValueInstantiator)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        Class clazz = (Class)object;
        if (ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
        if (handlerInstantiator != null && (valueInstantiator = handlerInstantiator.valueInstantiatorInstance(deserializationConfig, annotated, clazz)) != null) {
            return valueInstantiator;
        }
        return (ValueInstantiator)ClassUtil.createInstance(clazz, deserializationConfig.canOverrideAccessModifiers());
    }

    protected void _addDeserializerConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) throws JsonMappingException {
        boolean bl2 = beanDescription.isNonStaticInnerClass();
        if (bl2) {
            return;
        }
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || this._hasCreatorAnnotation(deserializationContext, annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        LinkedList<CreatorCandidate> linkedList = new LinkedList<CreatorCandidate>();
        int n2 = 0;
        for (AnnotatedConstructor object : beanDescription.getConstructors()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), object);
            if (JsonCreator.Mode.DISABLED == mode) continue;
            if (mode == null) {
                if (!visibilityChecker.isCreatorVisible(object)) continue;
                linkedList.add(CreatorCandidate.construct(annotationIntrospector, object, map.get(object)));
                continue;
            }
            switch (mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, object, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, object, map.get(object)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, object, map.get(object)));
                }
            }
            ++n2;
        }
        if (n2 > 0) {
            return;
        }
        Object object = null;
        for (CreatorCandidate creatorCandidate : linkedList) {
            Serializable serializable;
            int n3;
            int n4 = creatorCandidate.paramCount();
            AnnotatedWithParams annotatedWithParams = creatorCandidate.creator();
            if (n4 == 1) {
                BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
                boolean bl3 = this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, beanPropertyDefinition);
                if (bl3) {
                    SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[1];
                    PropertyName propertyName = creatorCandidate.paramName(0);
                    settableBeanPropertyArray[0] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, creatorCandidate.parameter(0), creatorCandidate.injection(0));
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                    continue;
                }
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, visibilityChecker.isCreatorVisible(annotatedWithParams));
                if (beanPropertyDefinition == null) continue;
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
                continue;
            }
            int n5 = -1;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n4];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                PropertyName propertyName;
                serializable = annotatedWithParams.getParameter(n3);
                BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(n3);
                JacksonInject.Value value = annotationIntrospector.findInjectableValue((AnnotatedMember)serializable);
                PropertyName propertyName2 = propertyName = beanPropertyDefinition == null ? null : beanPropertyDefinition.getFullName();
                if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
                    ++n6;
                    settableBeanPropertyArray[n3] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n3, (AnnotatedParameter)serializable, value);
                    continue;
                }
                if (value != null) {
                    ++n8;
                    settableBeanPropertyArray[n3] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n3, (AnnotatedParameter)serializable, value);
                    continue;
                }
                NameTransformer nameTransformer = annotationIntrospector.findUnwrappingNameTransformer((AnnotatedMember)serializable);
                if (nameTransformer != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, (AnnotatedParameter)serializable);
                    continue;
                }
                if (n5 >= 0) continue;
                n5 = n3;
            }
            n3 = n6 + n7;
            if (n6 > 0 || n8 > 0) {
                if (n3 + n8 == n4) {
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                    continue;
                }
                if (n6 == 0 && n8 + 1 == n4) {
                    creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                    continue;
                }
                serializable = creatorCandidate.findImplicitParamName(n5);
                if (serializable == null || ((PropertyName)serializable).isEmpty()) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", n5, annotatedWithParams);
                }
            }
            if (creatorCollector.hasDefaultCreator()) continue;
            if (object == null) {
                object = new LinkedList();
            }
            object.add((AnnotatedWithParams)annotatedWithParams);
        }
        if (object != null && !creatorCollector.hasDelegatingCreator() && !creatorCollector.hasPropertyBasedCreator()) {
            this._checkImplicitlyNamedConstructors(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, (List<AnnotatedWithParams>)object);
        }
    }

    protected void _addExplicitDelegatingCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        int n2 = -1;
        int n3 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            JacksonInject.Value value = creatorCandidate.injection(i2);
            if (value != null) {
                settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, null, i2, annotatedParameter, value);
                continue;
            }
            if (n2 < 0) {
                n2 = i2;
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", n2, i2, creatorCandidate);
        }
        if (n2 < 0) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "No argument left as delegating for Creator %s: exactly one required", creatorCandidate);
        }
        if (n3 == 1) {
            this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            if (beanPropertyDefinition != null) {
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
            }
            return;
        }
        creatorCollector.addDelegatingCreator(creatorCandidate.creator(), true, settableBeanPropertyArray, n2);
    }

    protected void _addExplicitPropertyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        int n2 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            JacksonInject.Value value = creatorCandidate.injection(i2);
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            PropertyName propertyName = creatorCandidate.paramName(i2);
            if (propertyName == null) {
                NameTransformer nameTransformer = deserializationContext.getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedParameter);
                if (nameTransformer != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                }
                if ((propertyName = creatorCandidate.findImplicitParamName(i2)) == null && value == null) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d has no property name, is not Injectable: can not use as Creator %s", i2, creatorCandidate);
                }
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, i2, annotatedParameter, value);
        }
        creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
    }

    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        boolean bl2;
        if (1 != creatorCandidate.paramCount()) {
            int n2 = creatorCandidate.findOnlyParamWithoutInjection();
            if (n2 >= 0 && creatorCandidate.paramName(n2) == null) {
                this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
                return;
            }
            this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
            return;
        }
        AnnotatedParameter annotatedParameter = creatorCandidate.parameter(0);
        JacksonInject.Value value = creatorCandidate.injection(0);
        PropertyName propertyName = creatorCandidate.explicitParamName(0);
        BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
        boolean bl3 = bl2 = propertyName != null || value != null;
        if (!bl2 && beanPropertyDefinition != null) {
            propertyName = creatorCandidate.findImplicitParamName(0);
            boolean bl4 = bl2 = propertyName != null && beanPropertyDefinition.couldSerialize();
        }
        if (bl2) {
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[]{this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, annotatedParameter, value)};
            creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
            return;
        }
        this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
        if (beanPropertyDefinition != null) {
            ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
        }
    }

    private boolean _checkIfCreatorPropertyBased(AnnotationIntrospector annotationIntrospector, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition beanPropertyDefinition) {
        String string;
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed() || annotationIntrospector.findInjectableValue(annotatedWithParams.getParameter(0)) != null) {
            return true;
        }
        return beanPropertyDefinition != null && (string = beanPropertyDefinition.getName()) != null && !string.isEmpty() && beanPropertyDefinition.couldSerialize();
    }

    private void _checkImplicitlyNamedConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, List<AnnotatedWithParams> list) throws JsonMappingException {
        Object object;
        Serializable serializable;
        AnnotatedWithParams annotatedWithParams = null;
        SettableBeanProperty[] settableBeanPropertyArray = null;
        block0: for (AnnotatedWithParams annotatedWithParams2 : list) {
            if (!visibilityChecker.isCreatorVisible(annotatedWithParams2)) continue;
            int n2 = annotatedWithParams2.getParameterCount();
            SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                serializable = annotatedWithParams2.getParameter(i2);
                object = this._findParamName((AnnotatedParameter)serializable, annotationIntrospector);
                if (object == null || ((PropertyName)object).isEmpty()) continue block0;
                settableBeanPropertyArray2[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, (PropertyName)object, ((AnnotatedParameter)serializable).getIndex(), (AnnotatedParameter)serializable, null);
            }
            if (annotatedWithParams != null) {
                annotatedWithParams = null;
                break;
            }
            annotatedWithParams = annotatedWithParams2;
            settableBeanPropertyArray = settableBeanPropertyArray2;
        }
        if (annotatedWithParams != null) {
            creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
            BasicBeanDescription basicBeanDescription = (BasicBeanDescription)beanDescription;
            for (AnnotatedWithParams annotatedWithParams3 : settableBeanPropertyArray) {
                serializable = ((SettableBeanProperty)((Object)annotatedWithParams3)).getFullName();
                if (basicBeanDescription.hasProperty((PropertyName)serializable)) continue;
                object = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), ((SettableBeanProperty)((Object)annotatedWithParams3)).getMember(), (PropertyName)serializable);
                basicBeanDescription.addProperty((BeanPropertyDefinition)object);
            }
        }
    }

    protected void _addDeserializerFactoryMethods(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) throws JsonMappingException {
        LinkedList<CreatorCandidate> linkedList = new LinkedList<CreatorCandidate>();
        int n2 = 0;
        for (AnnotatedMethod object : beanDescription.getFactoryMethods()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), object);
            int n3 = object.getParameterCount();
            if (mode == null) {
                if (n3 != 1 || !visibilityChecker.isCreatorVisible(object)) continue;
                linkedList.add(CreatorCandidate.construct(annotationIntrospector, object, null));
                continue;
            }
            if (mode == JsonCreator.Mode.DISABLED) continue;
            if (n3 == 0) {
                creatorCollector.setDefaultCreator(object);
                continue;
            }
            switch (mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, object, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, object, map.get(object)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, object, map.get(object)));
                }
            }
            ++n2;
        }
        if (n2 > 0) {
            return;
        }
        for (CreatorCandidate creatorCandidate : linkedList) {
            int n4;
            int n5 = creatorCandidate.paramCount();
            AnnotatedWithParams annotatedWithParams = creatorCandidate.creator();
            BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
            if (n5 != 1) continue;
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            boolean bl2 = this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, beanPropertyDefinition);
            if (!bl2) {
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, visibilityChecker.isCreatorVisible(annotatedWithParams));
                if (beanPropertyDefinition == null) continue;
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
                continue;
            }
            AnnotatedParameter annotatedParameter = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n5];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                PropertyName propertyName;
                AnnotatedParameter annotatedParameter2 = annotatedWithParams.getParameter(n4);
                BeanPropertyDefinition beanPropertyDefinition2 = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[n4];
                JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter2);
                PropertyName propertyName2 = propertyName = beanPropertyDefinition2 == null ? null : beanPropertyDefinition2.getFullName();
                if (beanPropertyDefinition2 != null && beanPropertyDefinition2.isExplicitlyNamed()) {
                    ++n7;
                    settableBeanPropertyArray[n4] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n4, annotatedParameter2, value);
                    continue;
                }
                if (value != null) {
                    ++n8;
                    settableBeanPropertyArray[n4] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n4, annotatedParameter2, value);
                    continue;
                }
                NameTransformer nameTransformer = annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter2);
                if (nameTransformer != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter2);
                    continue;
                }
                if (annotatedParameter != null) continue;
                annotatedParameter = annotatedParameter2;
            }
            n4 = n7 + n6;
            if (n7 <= 0 && n8 <= 0) continue;
            if (n4 + n8 == n5) {
                creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                continue;
            }
            if (n7 == 0 && n8 + 1 == n5) {
                creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of factory method %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", annotatedParameter.getIndex(), annotatedWithParams);
        }
    }

    protected boolean _handleSingleArgumentCreator(CreatorCollector creatorCollector, AnnotatedWithParams annotatedWithParams, boolean bl2, boolean bl3) {
        Class<?> clazz = annotatedWithParams.getRawParameterType(0);
        if (clazz == String.class || clazz == CharSequence.class) {
            if (bl2 || bl3) {
                creatorCollector.addStringCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl2 || bl3) {
                creatorCollector.addIntCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl2 || bl3) {
                creatorCollector.addLongCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl2 || bl3) {
                creatorCollector.addDoubleCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl2 || bl3) {
                creatorCollector.addBooleanCreator(annotatedWithParams, bl2);
            }
            return true;
        }
        if (bl2) {
            creatorCollector.addDelegatingCreator(annotatedWithParams, bl2, null, 0);
            return true;
        }
        return false;
    }

    protected void _reportUnwrappedCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedParameter annotatedParameter) throws JsonMappingException {
        deserializationContext.reportBadDefinition(beanDescription.getType(), String.format("Cannot define Creator parameter %d as `@JsonUnwrapped`: combination not yet supported", annotatedParameter.getIndex()));
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, PropertyName propertyName, int n2, AnnotatedParameter annotatedParameter, JacksonInject.Value value) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        PropertyMetadata propertyMetadata;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            propertyMetadata = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
        } else {
            serializable = annotationIntrospector.hasRequiredMarker(annotatedParameter);
            object3 = annotationIntrospector.findPropertyDescription(annotatedParameter);
            object2 = annotationIntrospector.findPropertyIndex(annotatedParameter);
            object = annotationIntrospector.findPropertyDefaultValue(annotatedParameter);
            propertyMetadata = PropertyMetadata.construct((Boolean)serializable, (String)object3, (Integer)object2, (String)object);
        }
        serializable = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter, annotatedParameter.getType());
        object3 = new BeanProperty.Std(propertyName, (JavaType)serializable, annotationIntrospector.findWrapperName(annotatedParameter), annotatedParameter, propertyMetadata);
        object2 = (TypeDeserializer)((JavaType)serializable).getTypeHandler();
        if (object2 == null) {
            object2 = this.findTypeDeserializer(deserializationConfig, (JavaType)serializable);
        }
        object = value == null ? null : value.getId();
        SettableBeanProperty settableBeanProperty = new CreatorProperty(propertyName, (JavaType)serializable, ((BeanProperty.Std)object3).getWrapperName(), (TypeDeserializer)object2, beanDescription.getClassAnnotations(), annotatedParameter, n2, object, propertyMetadata);
        JsonDeserializer<?> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer<?>)((JavaType)serializable).getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, settableBeanProperty, (JavaType)serializable);
            settableBeanProperty = ((SettableBeanProperty)settableBeanProperty).withValueDeserializer(jsonDeserializer);
        }
        return settableBeanProperty;
    }

    private PropertyName _findParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        if (annotatedParameter != null && annotationIntrospector != null) {
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName != null) {
                return propertyName;
            }
            String string = annotationIntrospector.findImplicitPropertyName(annotatedParameter);
            if (string != null && !string.isEmpty()) {
                return PropertyName.construct(string);
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext deserializationContext, ArrayType arrayType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = arrayType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            if (jsonDeserializer2 == null) {
                Class<?> clazz = javaType.getRawClass();
                if (javaType.isPrimitive()) {
                    return PrimitiveArrayDeserializers.forType(clazz);
                }
                if (clazz == String.class) {
                    return StringArrayDeserializer.instance;
                }
            }
            jsonDeserializer = new ObjectArrayDeserializer((JavaType)arrayType, jsonDeserializer2, typeDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyArrayDeserializer(deserializationConfig, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext deserializationContext, CollectionType object, BeanDescription beanDescription) throws JsonMappingException {
        Object object2;
        JsonDeserializer jsonDeserializer;
        JavaType javaType = ((CollectionLikeType)object).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer((CollectionType)object, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            object2 = ((JavaType)object).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object2)) {
                jsonDeserializer = new EnumSetDeserializer(javaType, null);
            }
        }
        if (jsonDeserializer == null) {
            if (((JavaType)object).isInterface() || ((JavaType)object).isAbstract()) {
                object2 = this._mapAbstractCollectionType((JavaType)object, deserializationConfig);
                if (object2 == null) {
                    if (((JavaType)object).getTypeHandler() == null) {
                        throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Collection type " + object);
                    }
                    jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription);
                } else {
                    object = object2;
                    beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                }
            }
            if (jsonDeserializer == null) {
                object2 = this.findValueInstantiator(deserializationContext, beanDescription);
                if (!((ValueInstantiator)object2).canCreateUsingDefault()) {
                    if (((JavaType)object).hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer((JavaType)object, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
                    }
                    jsonDeserializer = JavaUtilCollectionsDeserializers.findForCollection(deserializationContext, (JavaType)object);
                    if (jsonDeserializer != null) {
                        return jsonDeserializer;
                    }
                }
                jsonDeserializer = javaType.hasRawClass(String.class) ? new StringCollectionDeserializer((JavaType)object, jsonDeserializer2, (ValueInstantiator)object2) : new CollectionDeserializer((JavaType)object, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionDeserializer(deserializationConfig, (CollectionType)object, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<Object> clazz = javaType.getRawClass();
        if ((clazz = _collectionFallbacks.get(clazz.getName())) == null) {
            return null;
        }
        return (CollectionType)deserializationConfig.constructSpecializedType(javaType, clazz);
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext deserializationContext, CollectionLikeType collectionLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = collectionLikeType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionLikeDeserializer(deserializationConfig, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext deserializationContext, MapType mapType, BeanDescription beanDescription) throws JsonMappingException {
        Object object;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = mapType.getKeyType();
        JavaType javaType2 = mapType.getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((object = this._findCustomMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer)) == null) {
            Serializable serializable;
            Class clazz2 = mapType.getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz2)) {
                void var12_14;
                if (clazz2 == EnumMap.class) {
                    Object clazz = null;
                } else {
                    ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
                }
                serializable = javaType.getRawClass();
                if (serializable == null || !((Class)serializable).isEnum()) {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
                object = new EnumMapDeserializer(mapType, (ValueInstantiator)var12_14, null, jsonDeserializer, typeDeserializer, null);
            }
            if (object == null) {
                if (mapType.isInterface() || mapType.isAbstract()) {
                    Class<? extends Map> clazz = _mapFallbacks.get(clazz2.getName());
                    if (clazz != null) {
                        clazz2 = clazz;
                        mapType = (MapType)deserializationConfig.constructSpecializedType(mapType, clazz2);
                        beanDescription = deserializationConfig.introspectForCreation(mapType);
                    } else {
                        if (mapType.getTypeHandler() == null) {
                            throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Map type " + mapType);
                        }
                        object = AbstractDeserializer.constructForNonPOJO(beanDescription);
                    }
                } else {
                    object = JavaUtilCollectionsDeserializers.findForMap(deserializationContext, mapType);
                    if (object != null) {
                        return object;
                    }
                }
                if (object == null) {
                    ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
                    serializable = new MapDeserializer(mapType, valueInstantiator, keyDeserializer, jsonDeserializer, typeDeserializer);
                    JsonIgnoreProperties.Value value = deserializationConfig.getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    Set<String> set = value == null ? null : value.findIgnoredForDeserialization();
                    ((MapDeserializer)serializable).setIgnorableProperties(set);
                    object = serializable;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                object = beanDeserializerModifier.modifyMapDeserializer(deserializationConfig, mapType, beanDescription, (JsonDeserializer<?>)object);
            }
        }
        return object;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext deserializationContext, MapLikeType mapLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = mapLikeType.getKeyType();
        JavaType javaType2 = mapLikeType.getContentType();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapLikeDeserializer(deserializationConfig, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer == null) {
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
            SettableBeanProperty[] object = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
                if (annotatedMethod.getParameterCount() == 0) {
                    jsonDeserializer = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                Class<?> clazz2 = annotatedMethod.getRawReturnType();
                if (!clazz2.isAssignableFrom(clazz)) continue;
                jsonDeserializer = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, object);
                break;
            }
            if (jsonDeserializer == null) {
                jsonDeserializer = new EnumDeserializer(this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueAccessor()), (Boolean)deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer<?> jsonDeserializer = this._findCustomTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(clazz);
    }

    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext deserializationContext, ReferenceType referenceType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = referenceType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null && referenceType.isTypeOrSubTypeOf(AtomicReference.class)) {
            Class<?> clazz = referenceType.getRawClass();
            ValueInstantiator valueInstantiator = clazz == AtomicReference.class ? null : this.findValueInstantiator(deserializationContext, beanDescription);
            return new AtomicReferenceDeserializer(referenceType, valueInstantiator, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyReferenceDeserializer(deserializationConfig, referenceType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findTypeResolver(deserializationConfig, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedClass);
        }
        if (typeResolverBuilder.getDefaultImpl() == null && javaType.isAbstract() && (javaType2 = this.mapAbstractType(deserializationConfig, javaType)) != null && !javaType2.hasRawClass(javaType.getRawClass())) {
            typeResolverBuilder = typeResolverBuilder.defaultImpl(javaType2.getRawClass());
        }
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        KeyDeserializer keyDeserializer = null;
        if (this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers keyDeserializers;
            BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
            Iterator<KeyDeserializers> object = this._factoryConfig.keyDeserializers().iterator();
            while (object.hasNext() && (keyDeserializer = (keyDeserializers = object.next()).findKeyDeserializer(javaType, deserializationConfig, beanDescription)) == null) {
            }
        }
        if (keyDeserializer == null) {
            keyDeserializer = javaType.isEnumType() ? this._createEnumKeyDeserializer(deserializationContext, javaType) : StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
        }
        if (keyDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                keyDeserializer = beanDeserializerModifier.modifyKeyDeserializer(deserializationConfig, javaType, keyDeserializer);
            }
        }
        return keyDeserializer;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = javaType.getRawClass();
        Object t2 = deserializationConfig.introspect(javaType);
        KeyDeserializer keyDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, ((BeanDescription)t2).getClassInfo());
        if (keyDeserializer != null) {
            return keyDeserializer;
        }
        JsonDeserializer<?> jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, (BeanDescription)t2);
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        JsonDeserializer<Object> jsonDeserializer2 = this.findDeserializerFromAnnotation(deserializationContext, ((BeanDescription)t2).getClassInfo());
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer2);
        }
        jsonDeserializer = this.constructEnumResolver(clazz, deserializationConfig, ((BeanDescription)t2).findJsonValueAccessor());
        for (AnnotatedMethod annotatedMethod : ((BeanDescription)t2).getFactoryMethods()) {
            Class<?> clazz2;
            if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                if (annotatedMethod.getRawParameterType(0) != String.class) {
                    throw new IllegalArgumentException("Parameter #0 type for factory method (" + annotatedMethod + ") not suitable, must be java.lang.String");
                }
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer));
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(deserializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType);
        }
        Collection<NamedType> collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(deserializationConfig, annotatedMember, javaType);
        JavaType javaType2 = javaType.getContentType();
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        Collection<NamedType> collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType2);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType2, collection);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Class<?> clazz = javaType.getRawClass();
        if (clazz == CLASS_OBJECT) {
            JavaType javaType2;
            JavaType javaType3;
            DeserializationConfig deserializationConfig = deserializationContext.getConfig();
            if (this._factoryConfig.hasAbstractTypeResolvers()) {
                javaType3 = this._findRemappedType(deserializationConfig, List.class);
                javaType2 = this._findRemappedType(deserializationConfig, Map.class);
            } else {
                javaType2 = null;
                javaType3 = null;
            }
            return new UntypedObjectDeserializer(javaType3, javaType2);
        }
        if (clazz == CLASS_STRING || clazz == CLASS_CHAR_BUFFER) {
            return StringDeserializer.instance;
        }
        if (clazz == CLASS_ITERABLE) {
            TypeFactory typeFactory = deserializationContext.getTypeFactory();
            JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType, CLASS_ITERABLE);
            JavaType javaType4 = javaTypeArray == null || javaTypeArray.length != 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            CollectionType collectionType = typeFactory.constructCollectionType(Collection.class, javaType4);
            return this.createCollectionDeserializer(deserializationContext, collectionType, beanDescription);
        }
        if (clazz == CLASS_MAP_ENTRY) {
            JavaType javaType5 = javaType.containedTypeOrUnknown(0);
            JavaType javaType6 = javaType.containedTypeOrUnknown(1);
            TypeDeserializer typeDeserializer = (TypeDeserializer)javaType6.getTypeHandler();
            if (typeDeserializer == null) {
                typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType6);
            }
            JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType6.getValueHandler();
            KeyDeserializer keyDeserializer = (KeyDeserializer)javaType5.getValueHandler();
            return new MapEntryDeserializer(javaType, keyDeserializer, (JsonDeserializer<Object>)jsonDeserializer2, typeDeserializer);
        }
        String string = clazz.getName();
        if (clazz.isPrimitive() || string.startsWith("java.")) {
            jsonDeserializer = NumberDeserializers.find(clazz, string);
            if (jsonDeserializer == null) {
                jsonDeserializer = DateDeserializers.find(clazz, string);
            }
            if (jsonDeserializer != null) {
                return jsonDeserializer;
            }
        }
        if (clazz == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        jsonDeserializer = this.findOptionalStdDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JdkDeserializers.find(clazz, string);
    }

    protected JavaType _findRemappedType(DeserializationConfig deserializationConfig, Class<?> clazz) throws JsonMappingException {
        JavaType javaType = this.mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz));
        return javaType == null || javaType.hasRawClass(clazz) ? null : javaType;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> jsonDeserializer = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findContentDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        Object object;
        Object object2;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (javaType.isMapLikeType() && (object2 = javaType.getKeyType()) != null && (object = deserializationContext.keyDeserializerInstance(annotatedMember, jsonDeserializer = annotationIntrospector.findKeyDeserializer(annotatedMember))) != null) {
            javaType = ((MapLikeType)javaType).withKeyValueHandler(object);
            object2 = javaType.getKeyType();
        }
        if (javaType.hasContentType()) {
            object2 = annotationIntrospector.findContentDeserializer(annotatedMember);
            jsonDeserializer = deserializationContext.deserializerInstance(annotatedMember, object2);
            if (jsonDeserializer != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
            if ((object = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(object);
            }
        }
        if ((object2 = this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(object2);
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class<?> clazz, DeserializationConfig deserializationConfig, AnnotatedMember annotatedMember) {
        if (annotatedMember != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(annotatedMember.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUnsafeUsingMethod(clazz, annotatedMember, deserializationConfig.getAnnotationIntrospector());
        }
        return EnumResolver.constructUnsafe(clazz, deserializationConfig.getAnnotationIntrospector());
    }

    protected boolean _hasCreatorAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotated);
            return mode != null && mode != JsonCreator.Mode.DISABLED;
        }
        return false;
    }

    @Deprecated
    protected JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        return annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
    }

    @Deprecated
    protected JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        return this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
    }

    @Deprecated
    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        Object t2 = deserializationConfig.introspect(javaType);
        return ((BeanDescription)t2).findJsonValueMethod();
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put(NavigableMap.class.getName(), TreeMap.class);
        _mapFallbacks.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

