/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyMetadata;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import zz.com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import zz.com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import zz.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import zz.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import zz.com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import zz.com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.util.Annotations;

public class BeanDeserializerBuilder {
    protected final DeserializationConfig _config;
    protected final DeserializationContext _context;
    protected final BeanDescription _beanDesc;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDescription, DeserializationContext deserializationContext) {
        this._beanDesc = beanDescription;
        this._context = deserializationContext;
        this._config = deserializationContext.getConfig();
    }

    protected BeanDeserializerBuilder(BeanDeserializerBuilder beanDeserializerBuilder) {
        this._beanDesc = beanDeserializerBuilder._beanDesc;
        this._context = beanDeserializerBuilder._context;
        this._config = beanDeserializerBuilder._config;
        this._properties.putAll(beanDeserializerBuilder._properties);
        this._injectables = BeanDeserializerBuilder._copy(beanDeserializerBuilder._injectables);
        this._backRefProperties = BeanDeserializerBuilder._copy(beanDeserializerBuilder._backRefProperties);
        this._ignorableProps = beanDeserializerBuilder._ignorableProps;
        this._valueInstantiator = beanDeserializerBuilder._valueInstantiator;
        this._objectIdReader = beanDeserializerBuilder._objectIdReader;
        this._anySetter = beanDeserializerBuilder._anySetter;
        this._ignoreAllUnknown = beanDeserializerBuilder._ignoreAllUnknown;
        this._buildMethod = beanDeserializerBuilder._buildMethod;
        this._builderConfig = beanDeserializerBuilder._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> hashMap) {
        return hashMap == null ? null : new HashMap<String, SettableBeanProperty>(hashMap);
    }

    private static <T> List<T> _copy(List<T> list) {
        return list == null ? null : new ArrayList<T>(list);
    }

    public void addOrReplaceProperty(SettableBeanProperty settableBeanProperty, boolean bl2) {
        this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
    }

    public void addProperty(SettableBeanProperty settableBeanProperty) {
        SettableBeanProperty settableBeanProperty2 = this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
        if (settableBeanProperty2 != null && settableBeanProperty2 != settableBeanProperty) {
            throw new IllegalArgumentException("Duplicate property '" + settableBeanProperty.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String string, SettableBeanProperty settableBeanProperty) {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        settableBeanProperty.fixAccess(this._config);
        this._backRefProperties.put(string, settableBeanProperty);
    }

    public void addInjectable(PropertyName propertyName, JavaType javaType, Annotations annotations, AnnotatedMember annotatedMember, Object object) {
        boolean bl2;
        boolean bl3;
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        boolean bl4 = bl3 = (bl2 = this._config.canOverrideAccessModifiers()) && this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
        if (bl2) {
            annotatedMember.fixAccess(bl3);
        }
        this._injectables.add(new ValueInjector(propertyName, javaType, annotatedMember, object));
    }

    public void addIgnorable(String string) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(string);
    }

    public void addCreatorProperty(SettableBeanProperty settableBeanProperty) {
        this.addProperty(settableBeanProperty);
    }

    public void setAnySetter(SettableAnyProperty settableAnyProperty) {
        if (this._anySetter != null && settableAnyProperty != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = settableAnyProperty;
    }

    public void setIgnoreUnknownProperties(boolean bl2) {
        this._ignoreAllUnknown = bl2;
    }

    public void setValueInstantiator(ValueInstantiator valueInstantiator) {
        this._valueInstantiator = valueInstantiator;
    }

    public void setObjectIdReader(ObjectIdReader objectIdReader) {
        this._objectIdReader = objectIdReader;
    }

    public void setPOJOBuilder(AnnotatedMethod annotatedMethod, JsonPOJOBuilder.Value value) {
        this._buildMethod = annotatedMethod;
        this._builderConfig = value;
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this._properties.get(propertyName.getSimpleName());
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public SettableBeanProperty removeProperty(PropertyName propertyName) {
        return this._properties.remove(propertyName.getSimpleName());
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder.Value getBuilderConfig() {
        return this._builderConfig;
    }

    public boolean hasIgnorable(String string) {
        return this._ignorableProps != null && this._ignorableProps.contains(string);
    }

    public JsonDeserializer<?> build() {
        boolean bl2;
        Collection<SettableBeanProperty> collection = this._properties.values();
        this._fixAccess(collection);
        BeanPropertyMap beanPropertyMap = BeanPropertyMap.construct(collection, this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES), this._collectAliases(collection));
        beanPropertyMap.assignIndexes();
        boolean bl3 = bl2 = !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!bl2) {
            for (SettableBeanProperty settableBeanProperty : collection) {
                if (!settableBeanProperty.hasViews()) continue;
                bl2 = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            beanPropertyMap = beanPropertyMap.withProperty(objectIdValueProperty);
        }
        return new BeanDeserializer(this, this._beanDesc, beanPropertyMap, (Map<String, SettableBeanProperty>)this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl2);
    }

    public AbstractDeserializer buildAbstract() {
        return new AbstractDeserializer(this, this._beanDesc, this._backRefProperties, this._properties);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType javaType, String string) throws JsonMappingException {
        Object object;
        boolean bl2;
        Serializable serializable;
        Class<?> clazz;
        if (this._buildMethod == null) {
            if (!string.isEmpty()) {
                this._context.reportBadDefinition(this._beanDesc.getType(), String.format("Builder class %s does not have build method (name: '%s')", this._beanDesc.getBeanClass().getName(), string));
            }
        } else {
            clazz = this._buildMethod.getRawReturnType();
            if (clazz != (serializable = javaType.getRawClass()) && !clazz.isAssignableFrom((Class<?>)serializable) && !((Class)serializable).isAssignableFrom(clazz)) {
                this._context.reportBadDefinition(this._beanDesc.getType(), String.format("Build method '%s' has wrong return type (%s), not compatible with POJO type (%s)", this._buildMethod.getFullName(), clazz.getName(), javaType.getRawClass().getName()));
            }
        }
        clazz = this._properties.values();
        this._fixAccess((Collection<SettableBeanProperty>)((Object)clazz));
        serializable = BeanPropertyMap.construct((Collection<SettableBeanProperty>)((Object)clazz), this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES), this._collectAliases((Collection<SettableBeanProperty>)((Object)clazz)));
        ((BeanPropertyMap)serializable).assignIndexes();
        boolean bl3 = bl2 = !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!bl2) {
            object = clazz.iterator();
            while (object.hasNext()) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
                if (!settableBeanProperty.hasViews()) continue;
                bl2 = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            object = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            serializable = ((BeanPropertyMap)serializable).withProperty((SettableBeanProperty)object);
        }
        return new BuilderBasedDeserializer(this, this._beanDesc, javaType, (BeanPropertyMap)serializable, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl2);
    }

    protected void _fixAccess(Collection<SettableBeanProperty> collection) {
        for (SettableBeanProperty settableBeanProperty : collection) {
            settableBeanProperty.fixAccess(this._config);
        }
        if (this._anySetter != null) {
            this._anySetter.fixAccess(this._config);
        }
        if (this._buildMethod != null) {
            this._buildMethod.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
    }

    protected Map<String, List<PropertyName>> _collectAliases(Collection<SettableBeanProperty> collection) {
        HashMap<String, List<PropertyName>> hashMap = null;
        AnnotationIntrospector annotationIntrospector = this._config.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            for (SettableBeanProperty settableBeanProperty : collection) {
                List<PropertyName> list = annotationIntrospector.findPropertyAliases(settableBeanProperty.getMember());
                if (list == null || list.isEmpty()) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, List<PropertyName>>();
                }
                hashMap.put(settableBeanProperty.getName(), list);
            }
        }
        if (hashMap == null) {
            return Collections.emptyMap();
        }
        return hashMap;
    }
}

