/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.impl.BeanAsArrayBuilderDeserializer;
import zz.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import zz.com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import zz.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import zz.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import zz.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.util.NameTransformer;
import zz.com.fasterxml.jackson.databind.util.TokenBuffer;

public class BuilderBasedDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _buildMethod;
    protected final JavaType _targetType;

    public BuilderBasedDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, JavaType javaType, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, Set<String> set, boolean bl2, boolean bl3) {
        super(beanDeserializerBuilder, beanDescription, beanPropertyMap, map, set, bl2, bl3);
        this._targetType = javaType;
        this._buildMethod = beanDeserializerBuilder.getBuildMethod();
        if (this._objectIdReader != null) {
            throw new IllegalArgumentException("Cannot use Object Id with Builder-based deserialization (type " + beanDescription.getType() + ")");
        }
    }

    @Deprecated
    public BuilderBasedDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, Set<String> set, boolean bl2, boolean bl3) {
        this(beanDeserializerBuilder, beanDescription, beanDescription.getType(), beanPropertyMap, map, set, bl2, bl3);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer) {
        this(builderBasedDeserializer, builderBasedDeserializer._ignoreAllUnknown);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, boolean bl2) {
        super((BeanDeserializerBase)builderBasedDeserializer, bl2);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, NameTransformer nameTransformer) {
        super((BeanDeserializerBase)builderBasedDeserializer, nameTransformer);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, ObjectIdReader objectIdReader) {
        super((BeanDeserializerBase)builderBasedDeserializer, objectIdReader);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, Set<String> set) {
        super((BeanDeserializerBase)builderBasedDeserializer, set);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer builderBasedDeserializer, BeanPropertyMap beanPropertyMap) {
        super((BeanDeserializerBase)builderBasedDeserializer, beanPropertyMap);
        this._buildMethod = builderBasedDeserializer._buildMethod;
        this._targetType = builderBasedDeserializer._targetType;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return new BuilderBasedDeserializer(this, nameTransformer);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BuilderBasedDeserializer(this, objectIdReader);
    }

    @Override
    public BeanDeserializerBase withIgnorableProperties(Set<String> set) {
        return new BuilderBasedDeserializer(this, set);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        return new BuilderBasedDeserializer(this, beanPropertyMap);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] settableBeanPropertyArray = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayBuilderDeserializer(this, this._targetType, settableBeanPropertyArray, this._buildMethod);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.FALSE;
    }

    protected Object finishBuild(DeserializationContext deserializationContext, Object object) throws IOException {
        if (null == this._buildMethod) {
            return object;
        }
        try {
            return this._buildMethod.getMember().invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            return this.wrapInstantiationProblem(exception, deserializationContext);
        }
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.isExpectedStartObjectToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (this._vanillaProcessing) {
                return this.finishBuild(deserializationContext, this.vanillaDeserialize(jsonParser, deserializationContext, jsonToken));
            }
            Object object = this.deserializeFromObject(jsonParser, deserializationContext);
            return this.finishBuild(deserializationContext, object);
        }
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                return this.finishBuild(deserializationContext, this.deserializeFromString(jsonParser, deserializationContext));
            }
            case 7: {
                return this.finishBuild(deserializationContext, this.deserializeFromNumber(jsonParser, deserializationContext));
            }
            case 8: {
                return this.finishBuild(deserializationContext, this.deserializeFromDouble(jsonParser, deserializationContext));
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 9: 
            case 10: {
                return this.finishBuild(deserializationContext, this.deserializeFromBoolean(jsonParser, deserializationContext));
            }
            case 3: {
                return this.finishBuild(deserializationContext, this.deserializeFromArray(jsonParser, deserializationContext));
            }
            case 2: 
            case 5: {
                return this.finishBuild(deserializationContext, this.deserializeFromObject(jsonParser, deserializationContext));
            }
        }
        return deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Class<?> clazz;
        JavaType javaType = this._targetType;
        Class<?> clazz2 = this.handledType();
        if (clazz2.isAssignableFrom(clazz = object.getClass())) {
            return deserializationContext.reportBadDefinition(javaType, String.format("Deserialization of %s by passing existing Builder (%s) instance not supported", javaType, clazz2.getName()));
        }
        return deserializationContext.reportBadDefinition(javaType, String.format("Deserialization of %s by passing existing instance (of %s) not supported", javaType, clazz.getName()));
    }

    private final Object vanillaDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException {
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, string, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
            }
            jsonParser.nextToken();
        }
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jsonParser, deserializationContext);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jsonParser, deserializationContext);
            }
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object2 = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object2);
        }
        if (this._needViewProcesing && (object = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object2, (Class<?>)object);
        }
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            object = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find((String)object);
            if (settableBeanProperty != null) {
                try {
                    object2 = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object2);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object2, (String)object, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object2, (String)object);
            }
            jsonParser.nextToken();
        }
        return object2;
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        TokenBuffer tokenBuffer = null;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block22: {
                Object object2;
                object = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
                if (settableBeanProperty != null) {
                    if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                        jsonParser.skipChildren();
                    } else if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                        jsonParser.nextToken();
                        try {
                            object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow(exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                            break block22;
                        }
                        if (object2.getClass() != this._beanType.getRawClass()) {
                            return this.handlePolymorphic(jsonParser, deserializationContext, object2, tokenBuffer);
                        }
                        if (tokenBuffer != null) {
                            object2 = this.handleUnknownProperties(deserializationContext, object2, tokenBuffer);
                        }
                        return this._deserialize(jsonParser, deserializationContext, object2);
                    }
                } else if (!propertyValueBuffer.readIdProperty((String)object)) {
                    object2 = this._beanProperties.find((String)object);
                    if (object2 != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                        this.handleIgnoredProperty(jsonParser, deserializationContext, this.handledType(), (String)object);
                    } else if (this._anySetter != null) {
                        propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                    } else {
                        if (tokenBuffer == null) {
                            tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
                        }
                        tokenBuffer.writeFieldName((String)object);
                        tokenBuffer.copyCurrentStructure(jsonParser);
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            object = this.wrapInstantiationProblem(exception, deserializationContext);
        }
        if (tokenBuffer != null) {
            if (object.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, deserializationContext, object, tokenBuffer);
            }
            return this.handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        return object;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Object object2;
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        if (this._unwrappedPropertyHandler != null) {
            if (jsonParser.hasToken(JsonToken.START_OBJECT)) {
                jsonParser.nextToken();
            }
            TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
            tokenBuffer.writeStartObject();
            return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, object);
        }
        if (this._needViewProcesing && (object2 = deserializationContext.getActiveView()) != null) {
            return this.deserializeWithView(jsonParser, deserializationContext, object, (Class<?>)object2);
        }
        object2 = jsonParser.getCurrentToken();
        if (object2 == JsonToken.START_OBJECT) {
            object2 = jsonParser.nextToken();
        }
        while (object2 == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, string, deserializationContext);
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, this.handledType(), string);
            }
            object2 = jsonParser.nextToken();
        }
        return object;
    }

    protected final Object deserializeWithView(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, Class<?> clazz) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (!settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            } else {
                this.handleUnknownVanilla(jsonParser, deserializationContext, object, string);
            }
            jsonToken = jsonParser.nextToken();
        }
        return object;
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Class<?> clazz;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartObject();
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz2 = clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            }
            jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
        tokenBuffer.writeStartObject();
        Object object = null;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block16: {
                String string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                if (settableBeanProperty != null) {
                    if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                        jsonToken = jsonParser.nextToken();
                        try {
                            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow(exception, this._beanType.getRawClass(), string, deserializationContext);
                            break block16;
                        }
                        if (object.getClass() != this._beanType.getRawClass()) {
                            return this.handlePolymorphic(jsonParser, deserializationContext, object, tokenBuffer);
                        }
                        return this.deserializeWithUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
                    }
                } else if (!propertyValueBuffer.readIdProperty(string)) {
                    SettableBeanProperty settableBeanProperty2 = this._beanProperties.find(string);
                    if (settableBeanProperty2 != null) {
                        propertyValueBuffer.bufferProperty(settableBeanProperty2, settableBeanProperty2.deserialize(jsonParser, deserializationContext));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                        this.handleIgnoredProperty(jsonParser, deserializationContext, this.handledType(), string);
                    } else {
                        tokenBuffer.writeFieldName(string);
                        tokenBuffer.copyCurrentStructure(jsonParser);
                        if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, string, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        if (object == null) {
            try {
                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
            }
            catch (Exception exception) {
                return this.wrapInstantiationProblem(exception, deserializationContext);
            }
        }
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) throws IOException {
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else {
                tokenBuffer.writeFieldName(string);
                tokenBuffer.copyCurrentStructure(jsonParser);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        tokenBuffer.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(jsonParser, deserializationContext);
        }
        return this.deserializeWithExternalTypeId(jsonParser, deserializationContext, this._valueInstantiator.createUsingDefault(deserializationContext));
    }

    protected Object deserializeWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonToken = jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            if (settableBeanProperty != null) {
                if (jsonToken.isScalarValue()) {
                    externalTypeHandler.handleTypePropertyValue(jsonParser, deserializationContext, string, object);
                }
                if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                this.handleIgnoredProperty(jsonParser, deserializationContext, object, string);
            } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, object)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, string, deserializationContext);
                    }
                } else {
                    this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        return externalTypeHandler.complete(jsonParser, deserializationContext, object);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JavaType javaType = this._targetType;
        return deserializationContext.reportBadDefinition(javaType, String.format("Deserialization (of %s) with Builder, External type id, @JsonCreator not yet implemented", javaType));
    }
}

