/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.impl;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import zz.com.fasterxml.jackson.databind.introspect.Annotated;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import zz.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class CreatorCollector {
    protected static final int C_DEFAULT = 0;
    protected static final int C_STRING = 1;
    protected static final int C_INT = 2;
    protected static final int C_LONG = 3;
    protected static final int C_DOUBLE = 4;
    protected static final int C_BOOLEAN = 5;
    protected static final int C_DELEGATE = 6;
    protected static final int C_PROPS = 7;
    protected static final int C_ARRAY_DELEGATE = 8;
    protected static final String[] TYPE_DESCS = new String[]{"default", "from-String", "from-int", "from-long", "from-double", "from-boolean", "delegate", "property-based"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[9];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;
    protected AnnotatedParameter _incompleteParameter;

    public CreatorCollector(BeanDescription beanDescription, MapperConfig<?> mapperConfig) {
        this._beanDesc = beanDescription;
        this._canFixAccess = mapperConfig.canOverrideAccessModifiers();
        this._forceAccess = mapperConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    public ValueInstantiator constructValueInstantiator(DeserializationConfig deserializationConfig) {
        JavaType javaType = this._computeDelegateType(this._creators[6], this._delegateArgs);
        JavaType javaType2 = this._computeDelegateType(this._creators[8], this._arrayDelegateArgs);
        JavaType javaType3 = this._beanDesc.getType();
        AnnotatedWithParams annotatedWithParams = StdTypeConstructor.tryToOptimize(this._creators[0]);
        StdValueInstantiator stdValueInstantiator = new StdValueInstantiator(deserializationConfig, javaType3);
        stdValueInstantiator.configureFromObjectSettings(annotatedWithParams, this._creators[6], javaType, this._delegateArgs, this._creators[7], this._propertyBasedArgs);
        stdValueInstantiator.configureFromArraySettings(this._creators[8], javaType2, this._arrayDelegateArgs);
        stdValueInstantiator.configureFromStringCreator(this._creators[1]);
        stdValueInstantiator.configureFromIntCreator(this._creators[2]);
        stdValueInstantiator.configureFromLongCreator(this._creators[3]);
        stdValueInstantiator.configureFromDoubleCreator(this._creators[4]);
        stdValueInstantiator.configureFromBooleanCreator(this._creators[5]);
        stdValueInstantiator.configureIncompleteParameter(this._incompleteParameter);
        return stdValueInstantiator;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._creators[0] = this._fixAccess(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 1, bl2);
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 2, bl2);
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 3, bl2);
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 4, bl2);
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams, boolean bl2) {
        this.verifyNonDup(annotatedWithParams, 5, bl2);
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, boolean bl2, SettableBeanProperty[] settableBeanPropertyArray, int n2) {
        if (annotatedWithParams.getParameterType(n2).isCollectionLikeType()) {
            if (this.verifyNonDup(annotatedWithParams, 8, bl2)) {
                this._arrayDelegateArgs = settableBeanPropertyArray;
            }
        } else if (this.verifyNonDup(annotatedWithParams, 6, bl2)) {
            this._delegateArgs = settableBeanPropertyArray;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams annotatedWithParams, boolean bl2, SettableBeanProperty[] settableBeanPropertyArray) {
        if (this.verifyNonDup(annotatedWithParams, 7, bl2)) {
            if (settableBeanPropertyArray.length > 1) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                int n2 = settableBeanPropertyArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Integer n3;
                    String string = settableBeanPropertyArray[i2].getName();
                    if (string.isEmpty() && settableBeanPropertyArray[i2].getInjectableValueId() != null || (n3 = hashMap.put(string, i2)) == null) continue;
                    throw new IllegalArgumentException(String.format("Duplicate creator property \"%s\" (index %s vs %d)", string, n3, i2));
                }
            }
            this._propertyBasedArgs = settableBeanPropertyArray;
        }
    }

    public void addIncompeteParameter(AnnotatedParameter annotatedParameter) {
        if (this._incompleteParameter == null) {
            this._incompleteParameter = annotatedParameter;
        }
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[6] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[7] != null;
    }

    private JavaType _computeDelegateType(AnnotatedWithParams annotatedWithParams, SettableBeanProperty[] settableBeanPropertyArray) {
        if (!this._hasNonDefaultCreator || annotatedWithParams == null) {
            return null;
        }
        int n2 = 0;
        if (settableBeanPropertyArray != null) {
            int n3 = settableBeanPropertyArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (settableBeanPropertyArray[i2] != null) continue;
                n2 = i2;
                break;
            }
        }
        return annotatedWithParams.getParameterType(n2);
    }

    private <T extends AnnotatedMember> T _fixAccess(T t2) {
        if (t2 != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t2.getAnnotated()), this._forceAccess);
        }
        return t2;
    }

    protected boolean verifyNonDup(AnnotatedWithParams annotatedWithParams, int n2, boolean bl2) {
        int n3 = 1 << n2;
        this._hasNonDefaultCreator = true;
        AnnotatedWithParams annotatedWithParams2 = this._creators[n2];
        if (annotatedWithParams2 != null) {
            boolean bl3;
            if ((this._explicitCreators & n3) != 0) {
                if (!bl2) {
                    return false;
                }
                bl3 = true;
            } else {
                boolean bl4 = bl3 = !bl2;
            }
            if (bl3 && annotatedWithParams2.getClass() == annotatedWithParams.getClass()) {
                Class<?> clazz;
                Class<?> clazz2 = annotatedWithParams2.getRawParameterType(0);
                if (clazz2 == (clazz = annotatedWithParams.getRawParameterType(0))) {
                    if (this._isEnumValueOf(annotatedWithParams)) {
                        return false;
                    }
                    if (!this._isEnumValueOf(annotatedWithParams2)) {
                        throw new IllegalArgumentException(String.format("Conflicting %s creators: already had %s creator %s, encountered another: %s", TYPE_DESCS[n2], bl2 ? "explicitly marked" : "implicitly discovered", annotatedWithParams2, annotatedWithParams));
                    }
                } else if (clazz.isAssignableFrom(clazz2)) {
                    return false;
                }
            }
        }
        if (bl2) {
            this._explicitCreators |= n3;
        }
        this._creators[n2] = this._fixAccess(annotatedWithParams);
        return true;
    }

    protected boolean _isEnumValueOf(AnnotatedWithParams annotatedWithParams) {
        return annotatedWithParams.getDeclaringClass().isEnum() && "valueOf".equals(annotatedWithParams.getName());
    }

    protected static final class StdTypeConstructor
    extends AnnotatedWithParams
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int TYPE_ARRAY_LIST = 1;
        public static final int TYPE_HASH_MAP = 2;
        public static final int TYPE_LINKED_HASH_MAP = 3;
        private final AnnotatedWithParams _base;
        private final int _type;

        public StdTypeConstructor(AnnotatedWithParams annotatedWithParams, int n2) {
            super(annotatedWithParams, null);
            this._base = annotatedWithParams;
            this._type = n2;
        }

        public static AnnotatedWithParams tryToOptimize(AnnotatedWithParams annotatedWithParams) {
            if (annotatedWithParams != null) {
                Class<?> clazz = annotatedWithParams.getDeclaringClass();
                if (clazz == List.class || clazz == ArrayList.class) {
                    return new StdTypeConstructor(annotatedWithParams, 1);
                }
                if (clazz == LinkedHashMap.class) {
                    return new StdTypeConstructor(annotatedWithParams, 3);
                }
                if (clazz == HashMap.class) {
                    return new StdTypeConstructor(annotatedWithParams, 2);
                }
            }
            return annotatedWithParams;
        }

        protected final Object _construct() {
            switch (this._type) {
                case 1: {
                    return new ArrayList();
                }
                case 3: {
                    return new LinkedHashMap();
                }
                case 2: {
                    return new HashMap();
                }
            }
            throw new IllegalStateException("Unknown type " + this._type);
        }

        @Override
        public int getParameterCount() {
            return this._base.getParameterCount();
        }

        @Override
        public Class<?> getRawParameterType(int n2) {
            return this._base.getRawParameterType(n2);
        }

        @Override
        public JavaType getParameterType(int n2) {
            return this._base.getParameterType(n2);
        }

        @Override
        @Deprecated
        public Type getGenericParameterType(int n2) {
            return this._base.getGenericParameterType(n2);
        }

        @Override
        public Object call() throws Exception {
            return this._construct();
        }

        @Override
        public Object call(Object[] objectArray) throws Exception {
            return this._construct();
        }

        @Override
        public Object call1(Object object) throws Exception {
            return this._construct();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this._base.getDeclaringClass();
        }

        @Override
        public Member getMember() {
            return this._base.getMember();
        }

        @Override
        public void setValue(Object object, Object object2) throws UnsupportedOperationException, IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(Object object) throws UnsupportedOperationException, IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Annotated withAnnotations(AnnotationMap annotationMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnnotatedElement getAnnotated() {
            return this._base.getAnnotated();
        }

        @Override
        protected int getModifiers() {
            return this._base.getMember().getModifiers();
        }

        @Override
        public String getName() {
            return this._base.getName();
        }

        @Override
        public JavaType getType() {
            return this._base.getType();
        }

        @Override
        public Class<?> getRawType() {
            return this._base.getRawType();
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }

        @Override
        public int hashCode() {
            return this._base.hashCode();
        }

        @Override
        public String toString() {
            return this._base.toString();
        }
    }
}

