/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.Converter;

public abstract class JavaUtilCollectionsDeserializers {
    private static final int TYPE_SINGLETON_SET = 1;
    private static final int TYPE_SINGLETON_LIST = 2;
    private static final int TYPE_SINGLETON_MAP = 3;
    private static final int TYPE_UNMODIFIABLE_SET = 4;
    private static final int TYPE_UNMODIFIABLE_LIST = 5;
    private static final int TYPE_UNMODIFIABLE_MAP = 6;
    public static final int TYPE_AS_LIST = 7;
    private static final Class<?> CLASS_AS_ARRAYS_LIST = Arrays.asList(null, null).getClass();
    private static final Class<?> CLASS_SINGLETON_SET;
    private static final Class<?> CLASS_SINGLETON_LIST;
    private static final Class<?> CLASS_SINGLETON_MAP;
    private static final Class<?> CLASS_UNMODIFIABLE_SET;
    private static final Class<?> CLASS_UNMODIFIABLE_LIST;
    private static final Class<?> CLASS_UNMODIFIABLE_MAP;

    public static JsonDeserializer<?> findForCollection(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        JavaUtilCollectionsConverter javaUtilCollectionsConverter;
        if (javaType.hasRawClass(CLASS_AS_ARRAYS_LIST)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(7, javaType, List.class);
        } else if (javaType.hasRawClass(CLASS_SINGLETON_LIST)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(2, javaType, List.class);
        } else if (javaType.hasRawClass(CLASS_SINGLETON_SET)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(1, javaType, Set.class);
        } else if (javaType.hasRawClass(CLASS_UNMODIFIABLE_LIST)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(5, javaType, List.class);
        } else if (javaType.hasRawClass(CLASS_UNMODIFIABLE_SET)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(4, javaType, Set.class);
        } else {
            return null;
        }
        return new StdDelegatingDeserializer<Object>(javaUtilCollectionsConverter);
    }

    public static JsonDeserializer<?> findForMap(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        JavaUtilCollectionsConverter javaUtilCollectionsConverter;
        if (javaType.hasRawClass(CLASS_SINGLETON_MAP)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(3, javaType, Map.class);
        } else if (javaType.hasRawClass(CLASS_UNMODIFIABLE_MAP)) {
            javaUtilCollectionsConverter = JavaUtilCollectionsDeserializers.converter(6, javaType, Map.class);
        } else {
            return null;
        }
        return new StdDelegatingDeserializer<Object>(javaUtilCollectionsConverter);
    }

    static JavaUtilCollectionsConverter converter(int n2, JavaType javaType, Class<?> clazz) {
        return new JavaUtilCollectionsConverter(n2, javaType.findSuperType(clazz));
    }

    static {
        Set<Boolean> set = Collections.singleton(Boolean.TRUE);
        CLASS_SINGLETON_SET = set.getClass();
        CLASS_UNMODIFIABLE_SET = Collections.unmodifiableSet(set).getClass();
        List<Boolean> list = Collections.singletonList(Boolean.TRUE);
        CLASS_SINGLETON_LIST = list.getClass();
        CLASS_UNMODIFIABLE_LIST = Collections.unmodifiableList(list).getClass();
        Map<String, String> map = Collections.singletonMap("a", "b");
        CLASS_SINGLETON_MAP = map.getClass();
        CLASS_UNMODIFIABLE_MAP = Collections.unmodifiableMap(map).getClass();
    }

    private static class JavaUtilCollectionsConverter
    implements Converter<Object, Object> {
        private final JavaType _inputType;
        private final int _kind;

        private JavaUtilCollectionsConverter(int n2, JavaType javaType) {
            this._inputType = javaType;
            this._kind = n2;
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return null;
            }
            switch (this._kind) {
                case 1: {
                    Set set = (Set)object;
                    this._checkSingleton(set.size());
                    return Collections.singleton(set.iterator().next());
                }
                case 2: {
                    List list = (List)object;
                    this._checkSingleton(list.size());
                    return Collections.singletonList(list.get(0));
                }
                case 3: {
                    Map map = (Map)object;
                    this._checkSingleton(map.size());
                    Map.Entry entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
                case 4: {
                    return Collections.unmodifiableSet((Set)object);
                }
                case 5: {
                    return Collections.unmodifiableList((List)object);
                }
                case 6: {
                    return Collections.unmodifiableMap((Map)object);
                }
            }
            return object;
        }

        @Override
        public JavaType getInputType(TypeFactory typeFactory) {
            return this._inputType;
        }

        @Override
        public JavaType getOutputType(TypeFactory typeFactory) {
            return this._inputType;
        }

        private void _checkSingleton(int n2) {
            if (n2 != 1) {
                throw new IllegalArgumentException("Can not deserialize Singleton container from " + n2 + " entries");
            }
        }
    }
}

