/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.impl;

import java.io.Serializable;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.deser.NullValueProvider;
import zz.com.fasterxml.jackson.databind.exc.InvalidNullException;
import zz.com.fasterxml.jackson.databind.util.AccessPattern;

public class NullsFailProvider
implements Serializable,
NullValueProvider {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _name;
    protected final JavaType _type;

    protected NullsFailProvider(PropertyName propertyName, JavaType javaType) {
        this._name = propertyName;
        this._type = javaType;
    }

    public static NullsFailProvider constructForProperty(BeanProperty beanProperty) {
        return new NullsFailProvider(beanProperty.getFullName(), beanProperty.getType());
    }

    public static NullsFailProvider constructForRootValue(JavaType javaType) {
        return new NullsFailProvider(null, javaType);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getNullValue(DeserializationContext deserializationContext) throws JsonMappingException {
        throw InvalidNullException.from(deserializationContext, this._name, this._type);
    }
}

