/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.PropertyMetadata;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.deser.NullValueProvider;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import zz.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;

public final class ObjectIdValueProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final ObjectIdReader _objectIdReader;

    public ObjectIdValueProperty(ObjectIdReader objectIdReader, PropertyMetadata propertyMetadata) {
        super(objectIdReader.propertyName, objectIdReader.getIdType(), propertyMetadata, objectIdReader.getDeserializer());
        this._objectIdReader = objectIdReader;
    }

    protected ObjectIdValueProperty(ObjectIdValueProperty objectIdValueProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(objectIdValueProperty, jsonDeserializer, nullValueProvider);
        this._objectIdReader = objectIdValueProperty._objectIdReader;
    }

    protected ObjectIdValueProperty(ObjectIdValueProperty objectIdValueProperty, PropertyName propertyName) {
        super(objectIdValueProperty, propertyName);
        this._objectIdReader = objectIdValueProperty._objectIdReader;
    }

    @Override
    public SettableBeanProperty withName(PropertyName propertyName) {
        return new ObjectIdValueProperty(this, propertyName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._valueDeserializer == jsonDeserializer) {
            return this;
        }
        return new ObjectIdValueProperty(this, jsonDeserializer, this._nullProvider);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        return new ObjectIdValueProperty(this, this._valueDeserializer, nullValueProvider);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return null;
    }

    @Override
    public AnnotatedMember getMember() {
        return null;
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        this.deserializeSetAndReturn(jsonParser, deserializationContext, object);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        Object t2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(t2, this._objectIdReader.generator, this._objectIdReader.resolver);
        readableObjectId.bindItem(object);
        SettableBeanProperty settableBeanProperty = this._objectIdReader.idProperty;
        if (settableBeanProperty != null) {
            return settableBeanProperty.setAndReturn(object, t2);
        }
        return object;
    }

    @Override
    public void set(Object object, Object object2) throws IOException {
        this.setAndReturn(object, object2);
    }

    @Override
    public Object setAndReturn(Object object, Object object2) throws IOException {
        SettableBeanProperty settableBeanProperty = this._objectIdReader.idProperty;
        if (settableBeanProperty == null) {
            throw new UnsupportedOperationException("Should not call set() on ObjectIdProperty that has no SettableBeanProperty");
        }
        return settableBeanProperty.setAndReturn(object, object2);
    }
}

