/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.databind.util.RawValue;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    protected final Boolean _supportsUpdates;

    public BaseNodeDeserializer(Class<T> clazz, Boolean bl2) {
        super(clazz);
        this._supportsUpdates = bl2;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._supportsUpdates;
    }

    protected void _handleDuplicateField(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) throws JsonProcessingException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            deserializationContext.reportInputMismatch(JsonNode.class, "Duplicate field '%s' for ObjectNode: not allowed when FAIL_ON_READING_DUP_TREE_KEY enabled", string);
        }
    }

    protected final ObjectNode deserializeObject(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        String string = jsonParser.nextFieldName();
        while (string != null) {
            JsonNode jsonNode;
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == null) {
                jsonToken = JsonToken.NOT_AVAILABLE;
            }
            switch (jsonToken.id()) {
                case 1: {
                    jsonNode = this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 3: {
                    jsonNode = this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 12: {
                    jsonNode = this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 6: {
                    jsonNode = jsonNodeFactory.textNode(jsonParser.getText());
                    break;
                }
                case 7: {
                    jsonNode = this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 9: {
                    jsonNode = jsonNodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    jsonNode = jsonNodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    jsonNode = jsonNodeFactory.nullNode();
                    break;
                }
                default: {
                    jsonNode = this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory);
                }
            }
            JsonNode jsonNode2 = objectNode.replace(string, jsonNode);
            if (jsonNode2 != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode2, jsonNode);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    protected final ObjectNode deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        String string = jsonParser.getCurrentName();
        while (string != null) {
            JsonNode jsonNode;
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == null) {
                jsonToken = JsonToken.NOT_AVAILABLE;
            }
            switch (jsonToken.id()) {
                case 1: {
                    jsonNode = this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 3: {
                    jsonNode = this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 12: {
                    jsonNode = this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 6: {
                    jsonNode = jsonNodeFactory.textNode(jsonParser.getText());
                    break;
                }
                case 7: {
                    jsonNode = this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case 9: {
                    jsonNode = jsonNodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    jsonNode = jsonNodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    jsonNode = jsonNodeFactory.nullNode();
                    break;
                }
                default: {
                    jsonNode = this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory);
                }
            }
            JsonNode jsonNode2 = objectNode.replace(string, jsonNode);
            if (jsonNode2 != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode2, jsonNode);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    /*
     * Unable to fully structure code
     */
    protected final JsonNode updateObject(JsonParser var1_1, DeserializationContext var2_2, ObjectNode var3_3) throws IOException {
        if (var1_1.isExpectedStartObjectToken()) {
            var4_4 = var1_1.nextFieldName();
        } else {
            if (!var1_1.hasToken(JsonToken.FIELD_NAME)) {
                return (JsonNode)this.deserialize(var1_1, var2_2);
            }
            var4_4 = var1_1.getCurrentName();
        }
        while (var4_4 != null) {
            var5_5 = var1_1.nextToken();
            var6_6 = var3_3.get(var4_4);
            if (var6_6 == null) ** GOTO lbl-1000
            if (var6_6 instanceof ObjectNode) {
                var7_7 = this.updateObject(var1_1, var2_2, (ObjectNode)var6_6);
                if (var7_7 != var6_6) {
                    var3_3.set(var4_4, var7_7);
                }
            } else if (var6_6 instanceof ArrayNode) {
                var7_7 = this.updateArray(var1_1, var2_2, (ArrayNode)var6_6);
                if (var7_7 != var6_6) {
                    var3_3.set(var4_4, var7_7);
                }
            } else lbl-1000:
            // 2 sources

            {
                if (var5_5 == null) {
                    var5_5 = JsonToken.NOT_AVAILABLE;
                }
                var8_8 = var2_2.getNodeFactory();
                switch (var5_5.id()) {
                    case 1: {
                        var7_7 = this.deserializeObject(var1_1, var2_2, var8_8);
                        break;
                    }
                    case 3: {
                        var7_7 = this.deserializeArray(var1_1, var2_2, var8_8);
                        break;
                    }
                    case 12: {
                        var7_7 = this._fromEmbedded(var1_1, var2_2, var8_8);
                        break;
                    }
                    case 6: {
                        var7_7 = var8_8.textNode(var1_1.getText());
                        break;
                    }
                    case 7: {
                        var7_7 = this._fromInt(var1_1, var2_2, var8_8);
                        break;
                    }
                    case 9: {
                        var7_7 = var8_8.booleanNode(true);
                        break;
                    }
                    case 10: {
                        var7_7 = var8_8.booleanNode(false);
                        break;
                    }
                    case 11: {
                        var7_7 = var8_8.nullNode();
                        break;
                    }
                    default: {
                        var7_7 = this.deserializeAny(var1_1, var2_2, var8_8);
                    }
                }
                if (var6_6 != null) {
                    this._handleDuplicateField(var1_1, var2_2, var8_8, var4_4, var3_3, var6_6, var7_7);
                }
                var3_3.set(var4_4, var7_7);
            }
            var4_4 = var1_1.nextFieldName();
        }
        return var3_3;
    }

    protected final ArrayNode deserializeArray(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        ArrayNode arrayNode = jsonNodeFactory.arrayNode();
        block11: while (true) {
            JsonToken jsonToken = jsonParser.nextToken();
            switch (jsonToken.id()) {
                case 1: {
                    arrayNode.add(this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 3: {
                    arrayNode.add(this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 4: {
                    return arrayNode;
                }
                case 12: {
                    arrayNode.add(this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 6: {
                    arrayNode.add(jsonNodeFactory.textNode(jsonParser.getText()));
                    continue block11;
                }
                case 7: {
                    arrayNode.add(this._fromInt(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 9: {
                    arrayNode.add(jsonNodeFactory.booleanNode(true));
                    continue block11;
                }
                case 10: {
                    arrayNode.add(jsonNodeFactory.booleanNode(false));
                    continue block11;
                }
                case 11: {
                    arrayNode.add(jsonNodeFactory.nullNode());
                    continue block11;
                }
            }
            arrayNode.add(this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory));
        }
    }

    protected final JsonNode updateArray(JsonParser jsonParser, DeserializationContext deserializationContext, ArrayNode arrayNode) throws IOException {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        block11: while (true) {
            JsonToken jsonToken = jsonParser.nextToken();
            switch (jsonToken.id()) {
                case 1: {
                    arrayNode.add(this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 3: {
                    arrayNode.add(this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 4: {
                    return arrayNode;
                }
                case 12: {
                    arrayNode.add(this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 6: {
                    arrayNode.add(jsonNodeFactory.textNode(jsonParser.getText()));
                    continue block11;
                }
                case 7: {
                    arrayNode.add(this._fromInt(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block11;
                }
                case 9: {
                    arrayNode.add(jsonNodeFactory.booleanNode(true));
                    continue block11;
                }
                case 10: {
                    arrayNode.add(jsonNodeFactory.booleanNode(false));
                    continue block11;
                }
                case 11: {
                    arrayNode.add(jsonNodeFactory.nullNode());
                    continue block11;
                }
            }
            arrayNode.add(this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 5: {
                return this.deserializeObjectAtName(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 6: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case 7: {
                return this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 9: {
                return jsonNodeFactory.booleanNode(true);
            }
            case 10: {
                return jsonNodeFactory.booleanNode(false);
            }
            case 11: {
                return jsonNodeFactory.nullNode();
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        int n2 = deserializationContext.getDeserializationFeatures();
        JsonParser.NumberType numberType = (n2 & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n2) ? JsonParser.NumberType.LONG : jsonParser.getNumberType())) : jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        JsonParser.NumberType numberType = jsonParser.getNumberType();
        if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            if (jsonParser.isNaN()) {
                return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (numberType == JsonParser.NumberType.FLOAT) {
            return jsonNodeFactory.numberNode(jsonParser.getFloatValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException {
        Object object = jsonParser.getEmbeddedObject();
        if (object == null) {
            return jsonNodeFactory.nullNode();
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return jsonNodeFactory.binaryNode((byte[])object);
        }
        if (object instanceof RawValue) {
            return jsonNodeFactory.rawValueNode((RawValue)object);
        }
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return jsonNodeFactory.pojoNode(object);
    }
}

