/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.std.FactoryBasedEnumDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import zz.com.fasterxml.jackson.databind.util.EnumResolver;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected Object[] _enumsByIndex;
    private final Enum<?> _enumDefaultValue;
    protected final CompactStringObjectMap _lookupByName;
    protected CompactStringObjectMap _lookupByToString;
    protected final Boolean _caseInsensitive;

    public EnumDeserializer(EnumResolver enumResolver, Boolean bl2) {
        super(enumResolver.getEnumClass());
        this._lookupByName = enumResolver.constructLookup();
        this._enumsByIndex = enumResolver.getRawEnums();
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._caseInsensitive = bl2;
    }

    protected EnumDeserializer(EnumDeserializer enumDeserializer, Boolean bl2) {
        super(enumDeserializer);
        this._lookupByName = enumDeserializer._lookupByName;
        this._enumsByIndex = enumDeserializer._enumsByIndex;
        this._enumDefaultValue = enumDeserializer._enumDefaultValue;
        this._caseInsensitive = bl2;
    }

    @Deprecated
    public EnumDeserializer(EnumResolver enumResolver) {
        this(enumResolver, null);
    }

    @Deprecated
    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        return EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, null, null);
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod, annotatedMethod.getParameterType(0), valueInstantiator, settableBeanPropertyArray);
    }

    public static JsonDeserializer<?> deserializerForNoArgsCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod);
    }

    public EnumDeserializer withResolved(Boolean bl2) {
        if (this._caseInsensitive == bl2) {
            return this;
        }
        return new EnumDeserializer(this, bl2);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, this.handledType(), JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        if (bl2 == null) {
            bl2 = this._caseInsensitive;
        }
        return this.withResolved(bl2);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.FIELD_NAME) {
            String string;
            CompactStringObjectMap compactStringObjectMap = deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringLookup(deserializationContext) : this._lookupByName;
            Object object = compactStringObjectMap.find(string = jsonParser.getText());
            if (object == null) {
                return this._deserializeAltString(jsonParser, deserializationContext, compactStringObjectMap, string);
            }
            return object;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            int n2 = jsonParser.getIntValue();
            if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "not allowed to deserialize Enum value out of number: disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow", new Object[0]);
            }
            if (n2 >= 0 && n2 < this._enumsByIndex.length) {
                return this._enumsByIndex[n2];
            }
            if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                return this._enumDefaultValue;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "index value outside legal index range [0..%s]", this._enumsByIndex.length - 1);
            }
            return null;
        }
        return this._deserializeOther(jsonParser, deserializationContext);
    }

    private final Object _deserializeAltString(JsonParser jsonParser, DeserializationContext deserializationContext, CompactStringObjectMap compactStringObjectMap, String string) throws IOException {
        char c2;
        if ((string = string.trim()).length() == 0) {
            if (deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                return this.getEmptyValue(deserializationContext);
            }
        } else if (Boolean.TRUE.equals(this._caseInsensitive)) {
            Object object = compactStringObjectMap.findCaseInsensitive(string);
            if (object != null) {
                return object;
            }
        } else if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS) && (c2 = string.charAt(0)) >= '0' && c2 <= '9') {
            try {
                int n2 = Integer.parseInt(string);
                if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                    return deserializationContext.handleWeirdStringValue(this._enumClass(), string, "value looks like quoted Enum index, but `MapperFeature.ALLOW_COERCION_OF_SCALARS` prevents use", new Object[0]);
                }
                if (n2 >= 0 && n2 < this._enumsByIndex.length) {
                    return this._enumsByIndex[n2];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
            return this._enumDefaultValue;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return deserializationContext.handleWeirdStringValue(this._enumClass(), string, "value not one of declared Enum instance names: %s", compactStringObjectMap.keys());
        }
        return null;
    }

    protected Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._enumClass(), jsonParser);
    }

    protected Class<?> _enumClass() {
        return this.handledType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompactStringObjectMap _getToStringLookup(DeserializationContext deserializationContext) {
        CompactStringObjectMap compactStringObjectMap = this._lookupByToString;
        if (compactStringObjectMap == null) {
            EnumDeserializer enumDeserializer = this;
            synchronized (enumDeserializer) {
                compactStringObjectMap = EnumResolver.constructUnsafeUsingToString(this._enumClass(), deserializationContext.getAnnotationIntrospector()).constructLookup();
            }
            this._lookupByToString = compactStringObjectMap;
        }
        return compactStringObjectMap;
    }
}

