/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.util.VersionUtil;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import zz.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class, StringBuilder.class};
    }

    protected FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public static Std findDeserializer(Class<?> clazz) {
        int n2 = 0;
        if (clazz == File.class) {
            n2 = 1;
        } else if (clazz == URL.class) {
            n2 = 2;
        } else if (clazz == URI.class) {
            n2 = 3;
        } else if (clazz == Class.class) {
            n2 = 4;
        } else if (clazz == JavaType.class) {
            n2 = 5;
        } else if (clazz == Currency.class) {
            n2 = 6;
        } else if (clazz == Pattern.class) {
            n2 = 7;
        } else if (clazz == Locale.class) {
            n2 = 8;
        } else if (clazz == Charset.class) {
            n2 = 9;
        } else if (clazz == TimeZone.class) {
            n2 = 10;
        } else if (clazz == InetAddress.class) {
            n2 = 11;
        } else if (clazz == InetSocketAddress.class) {
            n2 = 12;
        } else if (clazz == StringBuilder.class) {
            n2 = 13;
        } else {
            return null;
        }
        return new Std(clazz, n2);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = jsonParser.getValueAsString();
        if (string != null) {
            if (string.length() == 0 || (string = string.trim()).length() == 0) {
                return this._deserializeFromEmptyString();
            }
            Exception exception = null;
            try {
                return this._deserialize(string, deserializationContext);
            }
            catch (IllegalArgumentException | MalformedURLException exception2) {
                exception = exception2;
                String string2 = "not a valid textual representation";
                String string3 = exception.getMessage();
                if (string3 != null) {
                    string2 = string2 + ", problem: " + string3;
                }
                JsonMappingException jsonMappingException = deserializationContext.weirdStringException(string, this._valueClass, string2);
                jsonMappingException.initCause(exception);
                throw jsonMappingException;
            }
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_ARRAY) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws IOException;

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportInputMismatch(this, "Don't know how to convert embedded Object of type %s into %s", object.getClass().getName(), this._valueClass.getName());
        return null;
    }

    protected T _deserializeFromEmptyString() throws IOException {
        return null;
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        public static final int STD_FILE = 1;
        public static final int STD_URL = 2;
        public static final int STD_URI = 3;
        public static final int STD_CLASS = 4;
        public static final int STD_JAVA_TYPE = 5;
        public static final int STD_CURRENCY = 6;
        public static final int STD_PATTERN = 7;
        public static final int STD_LOCALE = 8;
        public static final int STD_CHARSET = 9;
        public static final int STD_TIME_ZONE = 10;
        public static final int STD_INET_ADDRESS = 11;
        public static final int STD_INET_SOCKET_ADDRESS = 12;
        public static final int STD_STRING_BUILDER = 13;
        protected final int _kind;

        protected Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            switch (this._kind) {
                case 1: {
                    return new File(string);
                }
                case 2: {
                    return new URL(string);
                }
                case 3: {
                    return URI.create(string);
                }
                case 4: {
                    try {
                        return deserializationContext.findClass(string);
                    }
                    catch (Exception exception) {
                        return deserializationContext.handleInstantiationProblem(this._valueClass, string, ClassUtil.getRootCause(exception));
                    }
                }
                case 5: {
                    return deserializationContext.getTypeFactory().constructFromCanonical(string);
                }
                case 6: {
                    return Currency.getInstance(string);
                }
                case 7: {
                    return Pattern.compile(string);
                }
                case 8: {
                    int n2 = this._firstHyphenOrUnderscore(string);
                    if (n2 < 0) {
                        return new Locale(string);
                    }
                    String string2 = string.substring(0, n2);
                    if ((n2 = this._firstHyphenOrUnderscore(string = string.substring(n2 + 1))) < 0) {
                        return new Locale(string2, string);
                    }
                    String string3 = string.substring(0, n2);
                    return new Locale(string2, string3, string.substring(n2 + 1));
                }
                case 9: {
                    return Charset.forName(string);
                }
                case 10: {
                    return TimeZone.getTimeZone(string);
                }
                case 11: {
                    return InetAddress.getByName(string);
                }
                case 12: {
                    if (string.startsWith("[")) {
                        int n3 = string.lastIndexOf(93);
                        if (n3 == -1) {
                            throw new InvalidFormatException(deserializationContext.getParser(), "Bracketed IPv6 address must contain closing bracket", (Object)string, InetSocketAddress.class);
                        }
                        int n4 = string.indexOf(58, n3);
                        int n5 = n4 > -1 ? Integer.parseInt(string.substring(n4 + 1)) : 0;
                        return new InetSocketAddress(string.substring(0, n3 + 1), n5);
                    }
                    int n6 = string.indexOf(58);
                    if (n6 >= 0 && string.indexOf(58, n6 + 1) < 0) {
                        int n7 = Integer.parseInt(string.substring(n6 + 1));
                        return new InetSocketAddress(string.substring(0, n6), n7);
                    }
                    return new InetSocketAddress(string, 0);
                }
                case 13: {
                    return new StringBuilder(string);
                }
            }
            VersionUtil.throwInternal();
            return null;
        }

        @Override
        protected Object _deserializeFromEmptyString() throws IOException {
            if (this._kind == 3) {
                return URI.create("");
            }
            if (this._kind == 8) {
                return Locale.ROOT;
            }
            if (this._kind == 13) {
                return new StringBuilder();
            }
            return super._deserializeFromEmptyString();
        }

        protected int _firstHyphenOrUnderscore(String string) {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 != '_' && c2 != '-') continue;
                return i2;
            }
            return -1;
        }
    }
}

