/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import zz.com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (_classNames.contains(string)) {
            FromStringDeserializer.Std std = FromStringDeserializer.findDeserializer(clazz);
            if (std != null) {
                return std;
            }
            if (clazz == UUID.class) {
                return new UUIDDeserializer();
            }
            if (clazz == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (clazz == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (clazz == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
        }
        return null;
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{UUID.class, AtomicBoolean.class, StackTraceElement.class, ByteBuffer.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

