/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.KeyDeserializer;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import zz.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import zz.com.fasterxml.jackson.databind.deser.NullValueProvider;
import zz.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import zz.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import zz.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import zz.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.util.ArrayBuilders;

@JacksonStdImpl
public class MapDeserializer
extends ContainerDeserializerBase<Map<Object, Object>>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final KeyDeserializer _keyDeserializer;
    protected boolean _standardStringKey;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected final boolean _hasDefaultCreator;
    protected Set<String> _ignorableProperties;

    public MapDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._hasDefaultCreator = valueInstantiator.canCreateUsingDefault();
        this._delegateDeserializer = null;
        this._propertyBasedCreator = null;
        this._standardStringKey = this._isStdKeyDeser(javaType, keyDeserializer);
    }

    protected MapDeserializer(MapDeserializer mapDeserializer) {
        super(mapDeserializer);
        this._keyDeserializer = mapDeserializer._keyDeserializer;
        this._valueDeserializer = mapDeserializer._valueDeserializer;
        this._valueTypeDeserializer = mapDeserializer._valueTypeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = mapDeserializer._ignorableProperties;
        this._standardStringKey = mapDeserializer._standardStringKey;
    }

    protected MapDeserializer(MapDeserializer mapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Set<String> set) {
        super(mapDeserializer, nullValueProvider, mapDeserializer._unwrapSingle);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = set;
        this._standardStringKey = this._isStdKeyDeser(this._containerType, keyDeserializer);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Set<String> set) {
        if (this._keyDeserializer == keyDeserializer && this._valueDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer && this._nullProvider == nullValueProvider && this._ignorableProperties == set) {
            return this;
        }
        return new MapDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider, set);
    }

    protected final boolean _isStdKeyDeser(JavaType javaType, KeyDeserializer keyDeserializer) {
        if (keyDeserializer == null) {
            return true;
        }
        JavaType javaType2 = javaType.getKeyType();
        if (javaType2 == null) {
            return true;
        }
        Class<?> clazz = javaType2.getRawClass();
        return (clazz == String.class || clazz == Object.class) && this.isDefaultKeyDeserializer(keyDeserializer);
    }

    public void setIgnorableProperties(String[] stringArray) {
        this._ignorableProperties = stringArray == null || stringArray.length == 0 ? null : ArrayBuilders.arrayToSet(stringArray);
    }

    public void setIgnorableProperties(Set<String> set) {
        this._ignorableProperties = set == null || set.size() == 0 ? null : set;
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        Object object;
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            object = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (object == null) {
                deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, null);
        } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
            object = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
            if (object == null) {
                deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, null);
        }
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            object = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, object, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
        }
        this._standardStringKey = this._isStdKeyDeser(this._containerType, this._keyDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Set<String> set;
        JsonIgnoreProperties.Value value;
        AnnotatedMember annotatedMember;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(this._containerType.getKeyType(), beanProperty);
        } else if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(deserializationContext, beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (beanProperty != null) {
            jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        }
        JavaType javaType = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        Set<String> set2 = this._ignorableProperties;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (MapDeserializer._neitherNull(annotationIntrospector, beanProperty) && (annotatedMember = beanProperty.getMember()) != null && (value = annotationIntrospector.findPropertyIgnorals(annotatedMember)) != null && !(set = value.findIgnoredForDeserialization()).isEmpty()) {
            set2 = set2 == null ? new HashSet<String>() : new HashSet<String>(set2);
            for (String string : set) {
                set2.add(string);
            }
        }
        return this.withResolved(keyDeserializer, typeDeserializer, jsonDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer), set2);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null && this._ignorableProperties == null;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return (Map)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (!this._hasDefaultCreator) {
            return (Map)deserializationContext.handleMissingInstantiator(this.getMapClass(), this.getValueInstantiator(), jsonParser, "no default constructor found", new Object[0]);
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.FIELD_NAME && jsonToken != JsonToken.END_OBJECT) {
            if (jsonToken == JsonToken.VALUE_STRING) {
                return (Map)this._valueInstantiator.createFromString(deserializationContext, jsonParser.getText());
            }
            return (Map)this._deserializeFromEmpty(jsonParser, deserializationContext);
        }
        Map map = (Map)this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._standardStringKey) {
            this._readAndBindStringKeyMap(jsonParser, deserializationContext, map);
            return map;
        }
        this._readAndBind(jsonParser, deserializationContext, map);
        return map;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        jsonParser.setCurrentValue(map);
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.FIELD_NAME) {
            return (Map)deserializationContext.handleUnexpectedToken(this.getMapClass(), jsonParser);
        }
        if (this._standardStringKey) {
            this._readAndUpdateStringKeyMap(jsonParser, deserializationContext, map);
            return map;
        }
        this._readAndUpdate(jsonParser, deserializationContext, map);
        return map;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    public final Class<?> getMapClass() {
        return this._containerType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._containerType;
    }

    protected final void _readAndBind(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        Object object;
        String string;
        boolean bl2;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        MapReferringAccumulator mapReferringAccumulator = null;
        boolean bl3 = bl2 = jsonDeserializer.getObjectIdReader() != null;
        if (bl2) {
            mapReferringAccumulator = new MapReferringAccumulator(this._containerType.getContentType().getRawClass(), map);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.getCurrentToken();
            if (object == JsonToken.END_OBJECT) {
                return;
            }
            if (object != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.getCurrentName();
        }
        while (string != null) {
            block15: {
                object = keyDeserializer.deserializeKey(string, deserializationContext);
                JsonToken jsonToken = jsonParser.nextToken();
                if (this._ignorableProperties != null && this._ignorableProperties.contains(string)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        Object object2;
                        if (jsonToken == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) break block15;
                            object2 = this._nullProvider.getNullValue(deserializationContext);
                        } else {
                            object2 = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                        }
                        if (bl2) {
                            mapReferringAccumulator.put(object, object2);
                        } else {
                            map.put(object, object2);
                        }
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        this.handleUnresolvedReference(deserializationContext, mapReferringAccumulator, object, unresolvedForwardReference);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, map, string);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    protected final void _readAndBindStringKeyMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        JsonToken jsonToken;
        String string;
        boolean bl2;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        MapReferringAccumulator mapReferringAccumulator = null;
        boolean bl3 = bl2 = jsonDeserializer.getObjectIdReader() != null;
        if (bl2) {
            mapReferringAccumulator = new MapReferringAccumulator(this._containerType.getContentType().getRawClass(), map);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.END_OBJECT) {
                return;
            }
            if (jsonToken != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.getCurrentName();
        }
        while (string != null) {
            block15: {
                jsonToken = jsonParser.nextToken();
                if (this._ignorableProperties != null && this._ignorableProperties.contains(string)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        Object object;
                        if (jsonToken == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) break block15;
                            object = this._nullProvider.getNullValue(deserializationContext);
                        } else {
                            object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                        }
                        if (bl2) {
                            mapReferringAccumulator.put(string, object);
                        } else {
                            map.put(string, object);
                        }
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        this.handleUnresolvedReference(deserializationContext, mapReferringAccumulator, string, unresolvedForwardReference);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, map, string);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        String string = jsonParser.isExpectedStartObjectToken() ? jsonParser.nextFieldName() : (jsonParser.hasToken(JsonToken.FIELD_NAME) ? jsonParser.getCurrentName() : null);
        while (string != null) {
            block13: {
                JsonToken jsonToken = jsonParser.nextToken();
                if (this._ignorableProperties != null && this._ignorableProperties.contains(string)) {
                    jsonParser.skipChildren();
                } else {
                    Object object;
                    SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                    if (settableBeanProperty != null) {
                        if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                            jsonParser.nextToken();
                            try {
                                object = (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                return (Map)this.wrapAndThrow(exception, this._containerType.getRawClass(), string);
                            }
                            this._readAndBind(jsonParser, deserializationContext, (Map<Object, Object>)object);
                            return object;
                        }
                    } else {
                        Object object2;
                        block14: {
                            object = this._keyDeserializer.deserializeKey(string, deserializationContext);
                            try {
                                if (jsonToken == JsonToken.VALUE_NULL) {
                                    if (this._skipNullValues) break block13;
                                    object2 = this._nullProvider.getNullValue(deserializationContext);
                                    break block14;
                                }
                                object2 = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow(exception, this._containerType.getRawClass(), string);
                                return null;
                            }
                        }
                        propertyValueBuffer.bufferMapProperty(object, object2);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        try {
            return (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, this._containerType.getRawClass(), string);
            return null;
        }
    }

    protected final void _readAndUpdate(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        Object object;
        String string;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.getCurrentToken();
            if (object == JsonToken.END_OBJECT) {
                return;
            }
            if (object != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.getCurrentName();
        }
        while (string != null) {
            object = keyDeserializer.deserializeKey(string, deserializationContext);
            JsonToken jsonToken = jsonParser.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(string)) {
                jsonParser.skipChildren();
            } else {
                try {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (!this._skipNullValues) {
                            map.put(object, this._nullProvider.getNullValue(deserializationContext));
                        }
                    } else {
                        Object object2 = map.get(object);
                        Object object3 = object2 != null ? jsonDeserializer.deserialize(jsonParser, deserializationContext, object2) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                        if (object3 != object2) {
                            map.put(object, object3);
                        }
                    }
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, map, string);
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    protected final void _readAndUpdateStringKeyMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        JsonToken jsonToken;
        String string;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.END_OBJECT) {
                return;
            }
            if (jsonToken != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.getCurrentName();
        }
        while (string != null) {
            jsonToken = jsonParser.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(string)) {
                jsonParser.skipChildren();
            } else {
                try {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (!this._skipNullValues) {
                            map.put(string, this._nullProvider.getNullValue(deserializationContext));
                        }
                    } else {
                        Object object = map.get(string);
                        Object object2 = object != null ? jsonDeserializer.deserialize(jsonParser, deserializationContext, object) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                        if (object2 != object) {
                            map.put(string, object2);
                        }
                    }
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, map, string);
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    private void handleUnresolvedReference(DeserializationContext deserializationContext, MapReferringAccumulator mapReferringAccumulator, Object object, UnresolvedForwardReference unresolvedForwardReference) throws JsonMappingException {
        if (mapReferringAccumulator == null) {
            deserializationContext.reportInputMismatch(this, "Unresolved forward reference but no identity info: " + unresolvedForwardReference, new Object[0]);
        }
        ReadableObjectId.Referring referring = mapReferringAccumulator.handleUnresolvedReference(unresolvedForwardReference, object);
        unresolvedForwardReference.getRoid().appendReferring(referring);
    }

    static class MapReferring
    extends ReadableObjectId.Referring {
        private final MapReferringAccumulator _parent;
        public final Map<Object, Object> next = new LinkedHashMap<Object, Object>();
        public final Object key;

        MapReferring(MapReferringAccumulator mapReferringAccumulator, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz, Object object) {
            super(unresolvedForwardReference, clazz);
            this._parent = mapReferringAccumulator;
            this.key = object;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            this._parent.resolveForwardReference(object, object2);
        }
    }

    private static final class MapReferringAccumulator {
        private final Class<?> _valueType;
        private Map<Object, Object> _result;
        private List<MapReferring> _accumulator = new ArrayList<MapReferring>();

        public MapReferringAccumulator(Class<?> clazz, Map<Object, Object> map) {
            this._valueType = clazz;
            this._result = map;
        }

        public void put(Object object, Object object2) {
            if (this._accumulator.isEmpty()) {
                this._result.put(object, object2);
            } else {
                MapReferring mapReferring = this._accumulator.get(this._accumulator.size() - 1);
                mapReferring.next.put(object, object2);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference unresolvedForwardReference, Object object) {
            MapReferring mapReferring = new MapReferring(this, unresolvedForwardReference, this._valueType, object);
            this._accumulator.add(mapReferring);
            return mapReferring;
        }

        public void resolveForwardReference(Object object, Object object2) throws IOException {
            Iterator<MapReferring> iterator = this._accumulator.iterator();
            Map<Object, Object> map = this._result;
            while (iterator.hasNext()) {
                MapReferring mapReferring = iterator.next();
                if (mapReferring.hasId(object)) {
                    iterator.remove();
                    map.put(mapReferring.key, object2);
                    map.putAll(mapReferring.next);
                    return;
                }
                map = mapReferring.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object + "] that wasn't previously seen as unresolved.");
        }
    }
}

