/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.io.NumberInput;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.util.AccessPattern;

public class NumberDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return IntegerDeserializer.primitiveInstance;
            }
            if (clazz == Boolean.TYPE) {
                return BooleanDeserializer.primitiveInstance;
            }
            if (clazz == Long.TYPE) {
                return LongDeserializer.primitiveInstance;
            }
            if (clazz == Double.TYPE) {
                return DoubleDeserializer.primitiveInstance;
            }
            if (clazz == Character.TYPE) {
                return CharacterDeserializer.primitiveInstance;
            }
            if (clazz == Byte.TYPE) {
                return ByteDeserializer.primitiveInstance;
            }
            if (clazz == Short.TYPE) {
                return ShortDeserializer.primitiveInstance;
            }
            if (clazz == Float.TYPE) {
                return FloatDeserializer.primitiveInstance;
            }
        } else if (_classNames.contains(string)) {
            if (clazz == Integer.class) {
                return IntegerDeserializer.wrapperInstance;
            }
            if (clazz == Boolean.class) {
                return BooleanDeserializer.wrapperInstance;
            }
            if (clazz == Long.class) {
                return LongDeserializer.wrapperInstance;
            }
            if (clazz == Double.class) {
                return DoubleDeserializer.wrapperInstance;
            }
            if (clazz == Character.class) {
                return CharacterDeserializer.wrapperInstance;
            }
            if (clazz == Byte.class) {
                return ByteDeserializer.wrapperInstance;
            }
            if (clazz == Short.class) {
                return ShortDeserializer.wrapperInstance;
            }
            if (clazz == Float.class) {
                return FloatDeserializer.wrapperInstance;
            }
            if (clazz == Number.class) {
                return NumberDeserializer.instance;
            }
            if (clazz == BigDecimal.class) {
                return BigDecimalDeserializer.instance;
            }
            if (clazz == BigInteger.class) {
                return BigIntegerDeserializer.instance;
            }
        } else {
            return null;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + clazz.getName());
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, Number.class, BigDecimal.class, BigInteger.class}) {
            _classNames.add(clazz.getName());
        }
    }

    @JacksonStdImpl
    public static class BigDecimalDeserializer
    extends StdScalarDeserializer<BigDecimal> {
        public static final BigDecimalDeserializer instance = new BigDecimalDeserializer();

        public BigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigDecimal.ZERO;
        }

        @Override
        public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: 
                case 8: {
                    return jsonParser.getDecimalValue();
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (this._isEmptyOrTextualNull(string)) {
                        this._verifyNullForScalarCoercion(deserializationContext, string);
                        return (BigDecimal)this.getNullValue(deserializationContext);
                    }
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    try {
                        return new BigDecimal(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return (BigDecimal)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
                    }
                }
                case 3: {
                    return (BigDecimal)this._deserializeFromArray(jsonParser, deserializationContext);
                }
            }
            return (BigDecimal)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class BigIntegerDeserializer
    extends StdScalarDeserializer<BigInteger> {
        public static final BigIntegerDeserializer instance = new BigIntegerDeserializer();

        public BigIntegerDeserializer() {
            super(BigInteger.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigInteger.ZERO;
        }

        @Override
        public BigInteger deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    switch (jsonParser.getNumberType()) {
                        case INT: 
                        case LONG: 
                        case BIG_INTEGER: {
                            return jsonParser.getBigIntegerValue();
                        }
                    }
                    break;
                }
                case 8: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                        this._failDoubleToIntCoercion(jsonParser, deserializationContext, "java.math.BigInteger");
                    }
                    return jsonParser.getDecimalValue().toBigInteger();
                }
                case 3: {
                    return (BigInteger)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (this._isEmptyOrTextualNull(string)) {
                        this._verifyNullForScalarCoercion(deserializationContext, string);
                        return (BigInteger)this.getNullValue(deserializationContext);
                    }
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    try {
                        return new BigInteger(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return (BigInteger)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
                    }
                }
            }
            return (BigInteger)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class NumberDeserializer
    extends StdScalarDeserializer<Object> {
        public static final NumberDeserializer instance = new NumberDeserializer();

        public NumberDeserializer() {
            super(Number.class);
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) && !jsonParser.isNaN()) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (string.length() == 0) {
                        return this.getNullValue(deserializationContext);
                    }
                    if (this._hasTextualNull(string)) {
                        return this.getNullValue(deserializationContext);
                    }
                    if (this._isPosInf(string)) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if (this._isNegInf(string)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    if (this._isNaN(string)) {
                        return Double.NaN;
                    }
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    try {
                        if (!this._isIntNumber(string)) {
                            if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                                return new BigDecimal(string);
                            }
                            return Double.valueOf(string);
                        }
                        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                            return new BigInteger(string);
                        }
                        long l2 = Long.parseLong(string);
                        if (!deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                            return (int)l2;
                        }
                        return l2;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid number", new Object[0]);
                    }
                }
                case 3: {
                    return this._deserializeFromArray(jsonParser, deserializationContext);
                }
            }
            return deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 6: 
                case 7: 
                case 8: {
                    return this.deserialize(jsonParser, deserializationContext);
                }
            }
            return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class DoubleDeserializer
    extends PrimitiveOrWrapperDeserializer<Double> {
        private static final long serialVersionUID = 1L;
        static final DoubleDeserializer primitiveInstance = new DoubleDeserializer(Double.TYPE, 0.0);
        static final DoubleDeserializer wrapperInstance = new DoubleDeserializer(Double.class, null);

        public DoubleDeserializer(Class<Double> clazz, Double d2) {
            super(clazz, d2, 0.0);
        }

        @Override
        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseDouble(jsonParser, deserializationContext);
        }

        @Override
        public Double deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            return this._parseDouble(jsonParser, deserializationContext);
        }

        protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return jsonParser.getDoubleValue();
            }
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (Double)this._coerceEmptyString(deserializationContext, this._primitive);
                }
                if (this._hasTextualNull(string)) {
                    return (Double)this._coerceTextualNull(deserializationContext, this._primitive);
                }
                switch (string.charAt(0)) {
                    case 'I': {
                        if (!this._isPosInf(string)) break;
                        return Double.POSITIVE_INFINITY;
                    }
                    case 'N': {
                        if (!this._isNaN(string)) break;
                        return Double.NaN;
                    }
                    case '-': {
                        if (!this._isNegInf(string)) break;
                        return Double.NEGATIVE_INFINITY;
                    }
                }
                this._verifyStringForScalarCoercion(deserializationContext, string);
                try {
                    return DoubleDeserializer.parseDouble(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return (Double)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Double value", new Object[0]);
                }
            }
            if (jsonToken == JsonToken.VALUE_NULL) {
                return (Double)this._coerceNullToken(deserializationContext, this._primitive);
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                return (Double)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            return (Double)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class FloatDeserializer
    extends PrimitiveOrWrapperDeserializer<Float> {
        private static final long serialVersionUID = 1L;
        static final FloatDeserializer primitiveInstance = new FloatDeserializer(Float.TYPE, Float.valueOf(0.0f));
        static final FloatDeserializer wrapperInstance = new FloatDeserializer(Float.class, null);

        public FloatDeserializer(Class<Float> clazz, Float f2) {
            super(clazz, f2, Float.valueOf(0.0f));
        }

        @Override
        public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseFloat(jsonParser, deserializationContext);
        }

        protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT || jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (Float)this._coerceEmptyString(deserializationContext, this._primitive);
                }
                if (this._hasTextualNull(string)) {
                    return (Float)this._coerceTextualNull(deserializationContext, this._primitive);
                }
                switch (string.charAt(0)) {
                    case 'I': {
                        if (!this._isPosInf(string)) break;
                        return Float.valueOf(Float.POSITIVE_INFINITY);
                    }
                    case 'N': {
                        if (!this._isNaN(string)) break;
                        return Float.valueOf(Float.NaN);
                    }
                    case '-': {
                        if (!this._isNegInf(string)) break;
                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                    }
                }
                this._verifyStringForScalarCoercion(deserializationContext, string);
                try {
                    return Float.valueOf(Float.parseFloat(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return (Float)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Float value", new Object[0]);
                }
            }
            if (jsonToken == JsonToken.VALUE_NULL) {
                return (Float)this._coerceNullToken(deserializationContext, this._primitive);
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                return (Float)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            return (Float)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static final class LongDeserializer
    extends PrimitiveOrWrapperDeserializer<Long> {
        private static final long serialVersionUID = 1L;
        static final LongDeserializer primitiveInstance = new LongDeserializer(Long.TYPE, 0L);
        static final LongDeserializer wrapperInstance = new LongDeserializer(Long.class, null);

        public LongDeserializer(Class<Long> clazz, Long l2) {
            super(clazz, l2, 0L);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getLongValue();
            }
            return this._parseLong(jsonParser, deserializationContext);
        }

        protected final Long _parseLong(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    return jsonParser.getLongValue();
                }
                case 8: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                        this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Long");
                    }
                    return jsonParser.getValueAsLong();
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (string.length() == 0) {
                        return (Long)this._coerceEmptyString(deserializationContext, this._primitive);
                    }
                    if (this._hasTextualNull(string)) {
                        return (Long)this._coerceTextualNull(deserializationContext, this._primitive);
                    }
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    try {
                        return NumberInput.parseLong(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return (Long)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Long value", new Object[0]);
                    }
                }
                case 11: {
                    return (Long)this._coerceNullToken(deserializationContext, this._primitive);
                }
                case 3: {
                    return (Long)this._deserializeFromArray(jsonParser, deserializationContext);
                }
            }
            return (Long)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static final class IntegerDeserializer
    extends PrimitiveOrWrapperDeserializer<Integer> {
        private static final long serialVersionUID = 1L;
        static final IntegerDeserializer primitiveInstance = new IntegerDeserializer(Integer.TYPE, 0);
        static final IntegerDeserializer wrapperInstance = new IntegerDeserializer(Integer.class, null);

        public IntegerDeserializer(Class<Integer> clazz, Integer n2) {
            super(clazz, n2, 0);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getIntValue();
            }
            return this._parseInteger(jsonParser, deserializationContext);
        }

        @Override
        public Integer deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getIntValue();
            }
            return this._parseInteger(jsonParser, deserializationContext);
        }

        protected final Integer _parseInteger(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    return jsonParser.getIntValue();
                }
                case 8: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                        this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Integer");
                    }
                    return jsonParser.getValueAsInt();
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    int n2 = string.length();
                    if (n2 == 0) {
                        return (Integer)this._coerceEmptyString(deserializationContext, this._primitive);
                    }
                    if (this._hasTextualNull(string)) {
                        return (Integer)this._coerceTextualNull(deserializationContext, this._primitive);
                    }
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    try {
                        if (n2 > 9) {
                            long l2 = Long.parseLong(string);
                            if (this._intOverflow(l2)) {
                                return (Integer)deserializationContext.handleWeirdStringValue(this._valueClass, string, String.format("Overflow: numeric value (%s) out of range of Integer (%d - %d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE), new Object[0]);
                            }
                            return (int)l2;
                        }
                        return NumberInput.parseInt(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return (Integer)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Integer value", new Object[0]);
                    }
                }
                case 11: {
                    return (Integer)this._coerceNullToken(deserializationContext, this._primitive);
                }
                case 3: {
                    return (Integer)this._deserializeFromArray(jsonParser, deserializationContext);
                }
            }
            return (Integer)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class CharacterDeserializer
    extends PrimitiveOrWrapperDeserializer<Character> {
        private static final long serialVersionUID = 1L;
        static final CharacterDeserializer primitiveInstance = new CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000'));
        static final CharacterDeserializer wrapperInstance = new CharacterDeserializer(Character.class, null);

        public CharacterDeserializer(Class<Character> clazz, Character c2) {
            super(clazz, c2, Character.valueOf('\u0000'));
        }

        @Override
        public Character deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    this._verifyNumberForScalarCoercion(deserializationContext, jsonParser);
                    int n2 = jsonParser.getIntValue();
                    if (n2 < 0 || n2 > 65535) break;
                    return Character.valueOf((char)n2);
                }
                case 6: {
                    String string = jsonParser.getText();
                    if (string.length() == 1) {
                        return Character.valueOf(string.charAt(0));
                    }
                    if (string.length() != 0) break;
                    return (Character)this._coerceEmptyString(deserializationContext, this._primitive);
                }
                case 11: {
                    return (Character)this._coerceNullToken(deserializationContext, this._primitive);
                }
                case 3: {
                    return (Character)this._deserializeFromArray(jsonParser, deserializationContext);
                }
            }
            return (Character)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class ShortDeserializer
    extends PrimitiveOrWrapperDeserializer<Short> {
        private static final long serialVersionUID = 1L;
        static final ShortDeserializer primitiveInstance = new ShortDeserializer(Short.TYPE, (short)0);
        static final ShortDeserializer wrapperInstance = new ShortDeserializer(Short.class, null);

        public ShortDeserializer(Class<Short> clazz, Short s2) {
            super(clazz, s2, (short)0);
        }

        @Override
        public Short deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseShort(jsonParser, deserializationContext);
        }

        protected Short _parseShort(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return jsonParser.getShortValue();
            }
            if (jsonToken == JsonToken.VALUE_STRING) {
                int n2;
                String string = jsonParser.getText().trim();
                int n3 = string.length();
                if (n3 == 0) {
                    return (Short)this._coerceEmptyString(deserializationContext, this._primitive);
                }
                if (this._hasTextualNull(string)) {
                    return (Short)this._coerceTextualNull(deserializationContext, this._primitive);
                }
                this._verifyStringForScalarCoercion(deserializationContext, string);
                try {
                    n2 = NumberInput.parseInt(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Short value", new Object[0]);
                }
                if (this._shortOverflow(n2)) {
                    return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value cannot be represented as 16-bit value", new Object[0]);
                }
                return (short)n2;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Short");
                }
                return jsonParser.getShortValue();
            }
            if (jsonToken == JsonToken.VALUE_NULL) {
                return (Short)this._coerceNullToken(deserializationContext, this._primitive);
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                return (Short)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            return (Short)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class ByteDeserializer
    extends PrimitiveOrWrapperDeserializer<Byte> {
        private static final long serialVersionUID = 1L;
        static final ByteDeserializer primitiveInstance = new ByteDeserializer(Byte.TYPE, (byte)0);
        static final ByteDeserializer wrapperInstance = new ByteDeserializer(Byte.class, null);

        public ByteDeserializer(Class<Byte> clazz, Byte by2) {
            super(clazz, by2, (byte)0);
        }

        @Override
        public Byte deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getByteValue();
            }
            return this._parseByte(jsonParser, deserializationContext);
        }

        protected Byte _parseByte(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                int n2;
                String string = jsonParser.getText().trim();
                if (this._hasTextualNull(string)) {
                    return (Byte)this._coerceTextualNull(deserializationContext, this._primitive);
                }
                int n3 = string.length();
                if (n3 == 0) {
                    return (Byte)this._coerceEmptyString(deserializationContext, this._primitive);
                }
                this._verifyStringForScalarCoercion(deserializationContext, string);
                try {
                    n2 = NumberInput.parseInt(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Byte value", new Object[0]);
                }
                if (this._byteOverflow(n2)) {
                    return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value cannot be represented as 8-bit value", new Object[0]);
                }
                return (byte)n2;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Byte");
                }
                return jsonParser.getByteValue();
            }
            if (jsonToken == JsonToken.VALUE_NULL) {
                return (Byte)this._coerceNullToken(deserializationContext, this._primitive);
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                return (Byte)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return jsonParser.getByteValue();
            }
            return (Byte)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static final class BooleanDeserializer
    extends PrimitiveOrWrapperDeserializer<Boolean> {
        private static final long serialVersionUID = 1L;
        static final BooleanDeserializer primitiveInstance = new BooleanDeserializer(Boolean.TYPE, Boolean.FALSE);
        static final BooleanDeserializer wrapperInstance = new BooleanDeserializer(Boolean.class, null);

        public BooleanDeserializer(Class<Boolean> clazz, Boolean bl2) {
            super(clazz, bl2, Boolean.FALSE);
        }

        @Override
        public Boolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            return this._parseBoolean(jsonParser, deserializationContext);
        }

        @Override
        public Boolean deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            return this._parseBoolean(jsonParser, deserializationContext);
        }

        protected final Boolean _parseBoolean(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_NULL) {
                return (Boolean)this._coerceNullToken(deserializationContext, this._primitive);
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                return (Boolean)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this._parseBooleanFromInt(jsonParser, deserializationContext);
            }
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if ("true".equals(string) || "True".equals(string)) {
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    return Boolean.TRUE;
                }
                if ("false".equals(string) || "False".equals(string)) {
                    this._verifyStringForScalarCoercion(deserializationContext, string);
                    return Boolean.FALSE;
                }
                if (string.length() == 0) {
                    return (Boolean)this._coerceEmptyString(deserializationContext, this._primitive);
                }
                if (this._hasTextualNull(string)) {
                    return (Boolean)this._coerceTextualNull(deserializationContext, this._primitive);
                }
                return (Boolean)deserializationContext.handleWeirdStringValue(this._valueClass, string, "only \"true\" or \"false\" recognized", new Object[0]);
            }
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            return (Boolean)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    protected static abstract class PrimitiveOrWrapperDeserializer<T>
    extends StdScalarDeserializer<T> {
        private static final long serialVersionUID = 1L;
        protected final T _nullValue;
        protected final T _emptyValue;
        protected final boolean _primitive;

        protected PrimitiveOrWrapperDeserializer(Class<T> clazz, T t2, T t3) {
            super(clazz);
            this._nullValue = t2;
            this._emptyValue = t3;
            this._primitive = clazz.isPrimitive();
        }

        @Override
        public AccessPattern getNullAccessPattern() {
            if (this._primitive) {
                return AccessPattern.DYNAMIC;
            }
            if (this._nullValue == null) {
                return AccessPattern.ALWAYS_NULL;
            }
            return AccessPattern.CONSTANT;
        }

        @Override
        public final T getNullValue(DeserializationContext deserializationContext) throws JsonMappingException {
            if (this._primitive && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                deserializationContext.reportInputMismatch(this, "Cannot map `null` into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", this.handledType().toString());
            }
            return this._nullValue;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
            return this._emptyValue;
        }
    }
}

